/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.GoPackageManagerCollector;
import com.sourceclear.engine.component.golang.GoDependencyGraph;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.golang.TrashVendorConf;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class TrashNativeCollector
extends GoPackageManagerCollector {
    public static final String VENDOR_CONF = "vendor.conf";
    private static final String TRASH = "trash";
    private TrashVendorConf trashVendorConf = new TrashVendorConf();

    public TrashNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, attributes);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(VENDOR_CONF);
    }

    @Override
    public String getName() {
        return "Trash";
    }

    @Override
    protected List<GoPackage> getResolvedImports(File projectRoot, GoDependencyGraph goDependencyGraph, List<String> goPaths) throws CollectionException {
        File dependencyFile = new File(projectRoot, VENDOR_CONF);
        try {
            this.trashVendorConf = TrashVendorConf.parse(dependencyFile);
            return this.trashVendorConf.getImports();
        }
        catch (IOException | URISyntaxException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }

    @Override
    protected String getIdentityFilename() {
        return VENDOR_CONF;
    }

    @Override
    @Nullable
    protected String getPackageNameUnderScan() {
        return this.trashVendorConf.getPackageName();
    }

    @Override
    @Nullable
    protected String getBinName() {
        return TRASH;
    }

    @Override
    @Nullable
    protected List<String> getInstallArgs() {
        return new ArrayList<String>();
    }
}

