/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import javax.annotation.Nonnull;

public abstract class StubNativeCollector
implements NativeCollector {
    private final LogStream logStream;
    private final String simpleName;

    StubNativeCollector(LogStream logStream) {
        this.logStream = logStream;
        this.simpleName = this.getClass().getName().replaceFirst(".*\\.(.+)NativeCollector", "$1");
    }

    @Override
    public String getName() {
        return String.format("%s Native Collector", this.simpleName);
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        return true;
    }

    @Override
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, String.format("    !! %s build system not currently supported", this.simpleName));
        return LibraryGraphContainer.EMPTY_GRAPH;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).build();
    }
}

