/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.generation.BuildSystemClientType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.Utils;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.JsonComponentGraphNativeCollector;
import com.srcclr.sdk.LibraryGraphContainer;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbtNativeCollector
extends JsonComponentGraphNativeCollector {
    private static final String BUILD_SBT = "build.sbt";
    private static final String SBT = "sbt";
    private static final String buildName = "Sbt";
    private static final String PLUGIN_ORG_NAME = "com.srcclr";
    private static final String PLUGIN_NAME = "sbt-srcclr";
    private static final String DEFAULT_PLUGIN_VERSION = "[1.0.0,)";
    private static final Logger LOGGER = LoggerFactory.getLogger(SbtNativeCollector.class);
    private Path tempDirectory;

    public SbtNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, buildName, attributes);
    }

    @Override
    public String getName() {
        return buildName;
    }

    @Override
    public boolean supports(File projectPath) {
        Path project = projectPath.toPath();
        return Files.isDirectory(project, new LinkOption[0]) && Files.exists(project.resolve(BUILD_SBT), new LinkOption[0]);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(BUILD_SBT);
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        try {
            CollectorUtils.resolveExeOrThrow(SBT, "sbt was not found on the PATH\n");
        }
        catch (CollectionException e) {
            String srcclrHelpfulMsg = "Please ensure that sbt is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --sbt\nto confirm that your system can build and scan sbt projects.";
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage() + "\n" + srcclrHelpfulMsg);
            return false;
        }
        return true;
    }

    @Override
    protected Process makeGraphBuildingProcess(File projectRoot, File graphFile, boolean useFallback) throws CollectionException, IOException {
        Path project = projectRoot.toPath();
        Path innerProjectDir = project.resolve("project");
        if (!Files.exists(innerProjectDir, new LinkOption[0])) {
            Files.createDirectory(innerProjectDir, new FileAttribute[0]);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(innerProjectDir, "sbt-srcclr*.sbt");){
            for (Path sbtFile : stream) {
                try {
                    Files.delete(sbtFile);
                }
                catch (IOException e) {
                    LOGGER.warn("Could not delete {}", (Object)sbtFile.toAbsolutePath(), (Object)e);
                }
            }
        }
        Path pluginDefinitionFile = Files.createTempFile(innerProjectDir, PLUGIN_NAME, ".sbt", new FileAttribute[0]);
        this.filesToDelete.add(pluginDefinitionFile);
        String addSbtPluginDeclaration = String.format("addSbtPlugin(\"%s\" %% \"%s\" %% \"%s\")", PLUGIN_ORG_NAME, PLUGIN_NAME, this.getVersion());
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(addSbtPluginDeclaration);
        Files.write(pluginDefinitionFile, lines, Charset.defaultCharset(), StandardOpenOption.TRUNCATE_EXISTING);
        this.tempDirectory = Files.createTempDirectory(PLUGIN_NAME, new FileAttribute[0]);
        List<String> command = Arrays.asList(CollectorUtils.resolveExeOrThrow(SBT).getAbsolutePath(), "clean", String.format("srcclr %s", this.tempDirectory));
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        CollectorUtils.populateEnvVars((Map<String, Object>)this.attributes, pb);
        pb.directory(projectRoot);
        pb.redirectErrorStream(true);
        pb.command(command);
        Utils.logExecutable("Sbt Graph Building", command, LOGGER, this.logStream);
        return pb.start();
    }

    @Override
    protected void afterGraphBuildingProcess(File projectRoot, File graphFile) throws IOException {
        LibraryGraphContainer.Builder builder = new LibraryGraphContainer.Builder();
        assert (this.tempDirectory != null);
        for (Path path : Files.newDirectoryStream(this.tempDirectory)) {
            LibraryGraphContainer container = LibraryGraphSerializer.read((InputStream)Files.newInputStream(path, new OpenOption[0]));
            builder.withGraphs((Collection)container.getGraphs());
        }
        try (OutputStream stream = Files.newOutputStream(graphFile.toPath(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            LibraryGraphSerializer.write((LibraryGraphContainer)builder.build(), (OutputStream)stream);
        }
    }

    private String getVersion() {
        String version;
        String configVersion = SbtNativeCollector.configVersion((Map<String, Object>)this.attributes);
        if (!Strings.isNullOrEmpty((String)configVersion)) {
            LOGGER.debug("Using {} {} (user-specified)", (Object)PLUGIN_NAME, (Object)configVersion);
            return configVersion;
        }
        try {
            version = this.client.getGenerationVersion(BuildSystemClientType.SBT, LibraryGraphSerializer.getCurrentGeneration());
            LOGGER.debug("Using {} {}", (Object)PLUGIN_NAME, (Object)version);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to get sbt-srcclr's version from platform, defaulting to {}", (Object)DEFAULT_PLUGIN_VERSION);
            return DEFAULT_PLUGIN_VERSION;
        }
        return version;
    }

    private static String configVersion(Map<String, Object> attributes) {
        return (String)attributes.get("SBT_PLUGIN_VERSION");
    }
}

