/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.pipenv.PipenvGraph;
import com.sourceclear.engine.component.pipenv.PipenvGraphEntry;
import com.sourceclear.engine.component.pipenv.PipenvGraphPackage;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipenvNativeCollector
implements NativeCollector {
    private static final String PIPENV = "pipenv";
    private static final Logger LOGGER = LoggerFactory.getLogger(PipenvNativeCollector.class);
    private static final String RUN_INSTALL_MSG = String.format("An error occurred while getting dependencies from Pipenv.%nEnsure you can run 'pipenv install' to generate a %s and create a virtualenv.", "Pipfile.lock");
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;
    private final CollectorData.Builder telemetryBuilder = new CollectorData.Builder();

    public PipenvNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return "Pipenv";
    }

    @Override
    public boolean supports(File projectPath) {
        return Files.exists(projectPath.toPath().resolve("Pipfile.lock"), new LinkOption[0]) || Files.exists(projectPath.toPath().resolve("Pipfile"), new LinkOption[0]);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames("Pipfile.lock", "Pipfile");
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        try {
            CollectorUtils.resolveExeOrThrow(PIPENV);
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return true;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        Path projectRootPath = projectRoot.toPath();
        Path lockfile = projectRootPath.resolve("Pipfile.lock");
        boolean skipPipenvInstall = Boolean.valueOf(String.valueOf(this.attributes.get((Object)"SKIP_PIPENV_INSTALL")));
        LOGGER.debug("skipPipenvInstall: {}", (Object)skipPipenvInstall);
        if (!skipPipenvInstall) {
            LOGGER.debug("Running pipenv install.");
            this.runPipenvInstallIn(projectRoot);
        }
        if (!Files.exists(lockfile, new LinkOption[0])) {
            LOGGER.debug("{} not found. Terminating...", (Object)"Pipfile.lock");
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, String.format("%s not found,please check that you can generate a lock filefrom your %s", "Pipfile.lock", "Pipfile"));
        }
        return this.getGraphFromPipenvGraph(projectRoot);
    }

    private LibraryGraphContainer getGraphFromPipenvGraph(File projectRoot) throws CollectionException {
        Map<String, PipenvGraphEntry> deps = this.getDepMappingFromPipenvGraphJson(projectRoot);
        List<String> directs = this.getDirectsFromPipenvGraph(projectRoot);
        return PipenvNativeCollector.graphFromDirectsAndDeps(deps, directs);
    }

    static LibraryGraphContainer graphFromDirectsAndDeps(Map<String, PipenvGraphEntry> deps, List<String> directs) {
        LibraryGraph.Builder root = new LibraryGraph.Builder().withFilename("Pipfile.lock");
        for (String direct : directs) {
            HashSet<String> discovered = new HashSet<String>();
            PipenvGraphEntry pipenvGraphEntry = deps.get(direct);
            if (pipenvGraphEntry == null) continue;
            root.withDirect(PipenvNativeCollector.libraryGraphFromPipenvGraphEntry(pipenvGraphEntry, deps, discovered));
        }
        return new LibraryGraphContainer.Builder().withGraph(root.build()).build();
    }

    private static LibraryGraph libraryGraphFromPipenvGraphEntry(PipenvGraphEntry pipenvGraphEntry, Map<String, PipenvGraphEntry> deps, Set<String> discovered) {
        PipenvGraphPackage graphPackage = pipenvGraphEntry.getGraphPackage();
        String name = graphPackage.getPackageName();
        String version = graphPackage.getInstalledVersion();
        LibraryGraph.Builder builder = new LibraryGraph.Builder().withFilename("Pipfile.lock").withCoords(new Coords.Builder().withVersion(version).withCoordinate1(name).withCoordinateType(CoordinateType.PYPI).build());
        for (PipenvGraphPackage pipenvGraphPackage : pipenvGraphEntry.getDependencies()) {
            String packageName = pipenvGraphPackage.getPackageName();
            if (discovered.contains(packageName)) continue;
            discovered.add(packageName);
            PipenvGraphEntry entry = deps.get(packageName);
            if (entry == null) continue;
            builder.withDirect(PipenvNativeCollector.libraryGraphFromPipenvGraphEntry(entry, deps, discovered));
        }
        return builder.build();
    }

    private List<String> getDirectsFromPipenvGraph(File projectRoot) throws CollectionException {
        List<String> output;
        List<String> command = Arrays.asList(PIPENV, "graph");
        try {
            output = CollectorUtils.launchProcess(command, projectRoot, new HashMap<String, String>(), LOGGER, RUN_INSTALL_MSG);
        }
        catch (CollectionException e) {
            LOGGER.debug("Unable to run 'pipenv graph --json' in {}", (Object)projectRoot, (Object)e);
            throw e;
        }
        return PipenvNativeCollector.directsFromPipenvGraphLines(output);
    }

    static ArrayList<String> directsFromPipenvGraphLines(List<String> output) {
        ArrayList<String> directs = new ArrayList<String>();
        for (String line : output) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.startsWith("-")) continue;
            int equalsPos = line.indexOf("==");
            directs.add(line.substring(0, equalsPos));
        }
        return directs;
    }

    private Map<String, PipenvGraphEntry> getDepMappingFromPipenvGraphJson(File projectRoot) throws CollectionException {
        Map<String, PipenvGraphEntry> deps;
        List<String> output;
        List<String> command = Arrays.asList(PIPENV, "graph", "--json");
        try {
            output = CollectorUtils.launchProcess(command, projectRoot, new HashMap<String, String>(), LOGGER, RUN_INSTALL_MSG);
        }
        catch (CollectionException e) {
            LOGGER.debug("Unable to run 'pipenv graph --json' in {}", (Object)projectRoot, (Object)e);
            throw e;
        }
        String joinedOutput = Joiner.on((String)"\n").join(output);
        try {
            deps = PipenvGraph.parse(joinedOutput);
        }
        catch (IOException e) {
            LOGGER.debug("Unable to parse {}", (Object)joinedOutput, (Object)e);
            throw new CollectionException(CollectionErrorType.PARSE, "Unable to parse `pipenv graph --json`", "", e);
        }
        return deps;
    }

    private void runPipenvInstallIn(File projectRoot) throws CollectionException {
        List<String> command = Arrays.asList(PIPENV, "install");
        this.telemetryBuilder.setBuildCommand(Joiner.on((String)" ").join(command));
        this.telemetryBuilder.setBuildCommandType(BuildCommandType.DEFAULT);
        try {
            CollectorUtils.launchProcess(command, projectRoot, new HashMap<String, String>(), LOGGER);
        }
        catch (CollectionException e) {
            this.telemetryBuilder.setBuildCommandSuccessful(false);
            LOGGER.debug("Unable to run 'pipenv install' in {}", (Object)projectRoot, (Object)e);
            throw e;
        }
        this.telemetryBuilder.setBuildCommandSuccessful(true);
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return this.telemetryBuilder.setCollectorName(this.getName()).build();
    }
}

