/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.ComponentEngineBuilder;
import com.sourceclear.engine.component.Utils;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.natives.parsing.NPMTreeParser;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NPMNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(NPMNativeCollector.class);
    public static final String SHRINKWRAP_FILENAME = "npm-shrinkwrap.json";
    public static final String PACKAGE_LOCK_FILENAME = "package-lock.json";
    private static final String PACKAGE_FILENAME = "package.json";
    private final CollectorData.Builder collectorDataBuilder = new CollectorData.Builder();
    private final Scope scope;
    private final ImmutableMap<String, Object> attributes;
    private final LogStream logStream;

    public static Scope scope(Map<String, Object> attributes) {
        String scope = (String)attributes.get("SCOPE");
        if (Strings.isNullOrEmpty((String)scope)) {
            return Scope.NONE;
        }
        if (scope.equals("prod") || scope.equals("production")) {
            return Scope.PRODUCTION;
        }
        if (scope.equals("dev") || scope.equals("development")) {
            return Scope.DEVELOPMENT;
        }
        return Scope.NONE;
    }

    public NPMNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.scope = NPMNativeCollector.scope(attributes);
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return "NPM";
    }

    @Override
    public boolean supports(File projectPath) {
        Set<String> collectorsToRun = ComponentEngineBuilder.getCollectorsSetUpperCase(Strings.nullToEmpty((String)((String)this.attributes.get((Object)"SCAN_COLLECTORS"))));
        boolean packageDotJsonExists = CollectorUtils.fileExistsWithinFolder(projectPath, PACKAGE_FILENAME);
        boolean lockfileExists = NPMNativeCollector.isLockfileInPath(projectPath.toPath());
        boolean yarnLockDoesNotExist = !CollectorUtils.fileExistsWithinFolder(projectPath, "yarn.lock");
        boolean userRequested = collectorsToRun.contains(this.getName().toUpperCase());
        return !(!packageDotJsonExists && !lockfileExists || !yarnLockDoesNotExist && !userRequested);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return Sets.newHashSet(CollectorUtils.regexifyFileNames(PACKAGE_FILENAME, SHRINKWRAP_FILENAME, PACKAGE_LOCK_FILENAME));
    }

    @Override
    public boolean systemIsReady(File dir) {
        String flavorText = "Please ensure that npm is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --npm\nto confirm that your system can build and scan Node.js projects.";
        if (NPMNativeCollector.isLockfileInPath(dir)) {
            return true;
        }
        try {
            CollectorUtils.resolveExeOrThrow("npm", "Please ensure that npm is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --npm\nto confirm that your system can build and scan Node.js projects.");
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        try {
            Result rawGraph;
            if (CollectorUtils.fileExistsWithinFolder(projectRoot, PACKAGE_FILENAME)) {
                try {
                    rawGraph = new Result(PACKAGE_FILENAME, this.getGraphFromPackageJson(projectRoot));
                }
                catch (CollectionException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Attempt to invoke npm failed; falling back to lockfile", (Throwable)e);
                    } else {
                        LOGGER.warn("Attempt to invoke npm failed; falling back to lockfile");
                    }
                    rawGraph = this.getGraphFromLockfile(projectRoot);
                }
            } else {
                rawGraph = this.getGraphFromLockfile(projectRoot);
            }
            LibraryGraph graph = NPMTreeParser.parse(rawGraph.filename, rawGraph.tree);
            return new LibraryGraphContainer.Builder().withGraph(graph).build();
        }
        catch (CollectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CollectionException(CollectionErrorType.UNKNOWN, ex.getMessage()).initCause(ex);
        }
    }

    private Result getGraphFromLockfile(File projectRoot) throws IOException, CollectionException {
        this.collectorDataBuilder.setBuildCommandType(BuildCommandType.NOT_NEEDED);
        if (NPMNativeCollector.isLockfileInPath(projectRoot)) {
            Path lockfile = NPMNativeCollector.resolveLockfile(projectRoot);
            String filename = lockfile.getFileName().toString();
            LOGGER.debug("{} found, using it for evidence collection", (Object)filename);
            String tree = Joiner.on((String)"").join(Files.readAllLines(lockfile, Charset.defaultCharset()));
            return new Result(filename, tree);
        }
        String msg = String.format("No %s or %s found. Unable to gather package info.", PACKAGE_LOCK_FILENAME, SHRINKWRAP_FILENAME);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg);
        } else {
            LOGGER.warn(msg);
        }
        throw new CollectionException(CollectionErrorType.PARSE, String.format("SourceClear cannot scan your project because the project failed to build%nand we are unable to locate a lock file (%s or %s) for parsing.%nPlease ensure the project builds prior to scanning.%nYou can run the following commands to check that npm and the project is set up properly:%n- \"npm install\" in the project directory.%n- \"npm ls --json\" to check that there are no errors.", PACKAGE_LOCK_FILENAME, SHRINKWRAP_FILENAME));
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return this.collectorDataBuilder.setCollectorName(this.getName()).build();
    }

    private String getGraphFromPackageJson(File projectRoot) throws CollectionException {
        LOGGER.debug("{} found, using it for evidence collection", (Object)PACKAGE_FILENAME);
        File npmPath = CollectorUtils.resolveExeOrThrow("npm");
        boolean skipNpmInstall = Boolean.valueOf(String.valueOf(this.attributes.get((Object)"SKIP_NPM_INSTALL")));
        LOGGER.debug("skipNpmInstall: {}", (Object)skipNpmInstall);
        if (!skipNpmInstall) {
            this.runInstall(projectRoot, npmPath);
        }
        return this.runList(projectRoot, npmPath);
    }

    private void runInstall(File projectRoot, File npmExe) throws CollectionException {
        ArrayList commands = Lists.newArrayList((Object[])new String[]{npmExe.getAbsolutePath(), "install"});
        this.collectorDataBuilder.setBuildCommandType(BuildCommandType.DEFAULT).setBuildCommand(Joiner.on((String)" ").join((Iterable)commands)).setBuildCommandSuccessful(false);
        NPMNativeCollector.addScopeIfSpecified(commands, this.scope);
        Utils.logExecutable("NPM Install", commands, LOGGER, this.logStream);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(projectRoot);
        pb.command(commands);
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            if (process.waitFor() != 0) {
                throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", output);
            }
            this.collectorDataBuilder.setBuildCommandSuccessful(true);
        }
        catch (InterruptedException ex) {
            throw new CollectionException(CollectionErrorType.IO, "The scan was interrupted while waiting for process completion.").initCause(ex);
        }
        catch (Exception ex) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "Couldn't complete NPM install: " + ex.getMessage()).initCause(ex);
        }
    }

    private String runList(File projectRoot, File npmExe) throws CollectionException {
        String output;
        ArrayList commands = Lists.newArrayList((Object[])new String[]{npmExe.getAbsolutePath(), "ls", "--json"});
        NPMNativeCollector.addScopeIfSpecified(commands, this.scope);
        Utils.logExecutable("NPM List", commands, LOGGER, this.logStream);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        CollectorUtils.populateEnvVars(this.attributes, pb);
        pb.directory(projectRoot);
        pb.command(commands);
        pb.redirectErrorStream(false);
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("npm-ls", ".json");
            pb.redirectOutput(tmpFile);
            Process process = pb.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            Future<String> errorFuture = CollectorUtils.readAsync(process.getErrorStream(), this.logStream, LOGGER, "com.srcclr.evidence.pacakge", Stage.EVIDENCE_COLLECTION);
            int rc = process.waitFor();
            LOGGER.debug("npm ls process return code: {}", (Object)rc);
            output = FileUtils.readFileToString((File)tmpFile, (Charset)Charset.defaultCharset());
            String error = errorFuture.get();
            LOGGER.debug("npm ls process error msg: {}", (Object)error);
        }
        catch (InterruptedException ex) {
            throw new CollectionException(CollectionErrorType.IO, "The scan was interrupted while waiting for process completion.").initCause(ex);
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "Unable to launch the npm process and get the output.").initCause(ex);
        }
        catch (ExecutionException ex) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "Unable to get the error message from npm ls process: " + ex.getMessage()).initCause(ex);
        }
        finally {
            boolean tmpFileDeleted;
            if (tmpFile != null && !(tmpFileDeleted = tmpFile.delete())) {
                LOGGER.debug("unable to delete tmpFile: {}", (Object)tmpFile);
            }
        }
        return output;
    }

    static void addScopeIfSpecified(List<String> commands, Scope scope) {
        if (scope != Scope.NONE) {
            commands.add("--only=" + scope.name().toLowerCase());
        }
    }

    public static boolean isLockfileInPath(File path) {
        return NPMNativeCollector.isLockfileInPath(path.toPath());
    }

    public static boolean isLockfileInPath(Path path) {
        return CollectorUtils.isOrContainFile(path, SHRINKWRAP_FILENAME).isPresent() || CollectorUtils.isOrContainFile(path, PACKAGE_LOCK_FILENAME).isPresent();
    }

    public static Path resolveLockfile(File path) {
        return NPMNativeCollector.resolveLockfile(path.toPath());
    }

    public static Path resolveLockfile(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Path sw = path.resolve(SHRINKWRAP_FILENAME);
            if (Files.exists(sw, new LinkOption[0])) {
                return sw;
            }
            return path.resolve(PACKAGE_LOCK_FILENAME);
        }
        return path;
    }

    private static class Result {
        public final String filename;
        public final String tree;

        public Result(String filename, String tree) {
            this.filename = filename;
            this.tree = tree;
        }
    }

    public static enum Scope {
        NONE,
        PRODUCTION,
        DEVELOPMENT;

    }
}

