/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.generation.BuildSystemClientType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.CollectionResult;
import com.sourceclear.engine.component.ComponentEngineBuilder;
import com.sourceclear.engine.component.Utils;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.JsonComponentGraphNativeCollector;
import com.sourceclear.util.system.OS;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenNativeCollector
extends JsonComponentGraphNativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenNativeCollector.class);
    private static final String PLUGIN_VERSION_ENV = "SRCCLR_MAVEN_VERSION";
    static File srcclrHome = Paths.get(System.getProperty("user.home"), ".srcclr").toFile();
    static final String MAVEN_WRAPPER_VERSION = "0.1.4";
    private String customCommand;

    public MavenNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, "Maven", attributes);
        this.customCommand = Objects.toString(attributes.get((Object)"CUSTOM_MAVEN_COMMAND"), null);
    }

    @Override
    public String getName() {
        return "Maven";
    }

    @Override
    public boolean supports(File projectPath) {
        return CollectorUtils.fileExistsWithinFolder(projectPath, "pom.xml");
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return Sets.newHashSet((Object[])new Pattern[]{Pattern.compile("pom\\.xml")});
    }

    @Override
    public boolean systemIsReady(File dir) {
        try {
            this.resolveMvnOrThrow(null, "");
        }
        catch (CollectionException e) {
            String srcclrHelpfulMsg = "Please ensure that Maven is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --maven\nto confirm that your system can build and scan Maven projects.";
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage() + "\n" + srcclrHelpfulMsg);
            return false;
        }
        return true;
    }

    @Override
    public Optional<CollectionResult.Advice> adviseOnFailure() {
        return Optional.of(new CollectionResult.Advice(this.getName(), "do check that `mvn clean install dependency:tree` completes successfully as a sanity check"));
    }

    @Override
    protected Process makeGraphBuildingProcess(File projectRoot, File graphFile, boolean useFallback) throws CollectionException, IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        File mavenFile = this.resolveMvnOrThrow(pb, "");
        CollectorUtils.populateEnvVars((Map<String, Object>)this.attributes, pb);
        pb.directory(projectRoot);
        pb.redirectErrorStream(true);
        ArrayList commands = Lists.newArrayList((Object[])new String[]{mavenFile.getAbsolutePath()});
        boolean compile = Objects.equals(Boolean.TRUE, this.attributes.get((Object)"COMPILE_FIRST"));
        boolean install = Objects.equals(Boolean.TRUE, this.attributes.get((Object)"INSTALL_FIRST"));
        if (!useFallback) {
            if (this.customCommand != null) {
                commands.addAll(MavenNativeCollector.splitOnUnquotedWhitespace(this.customCommand));
                this.collectorDataBuilder.setBuildCommandType(BuildCommandType.CUSTOM);
            } else if (compile || install) {
                if (compile) {
                    commands.add("compile");
                }
                if (install) {
                    commands.add("install");
                }
                commands.add("-Dcheckstyle.skip=true");
                commands.add("-e");
                commands.add("-DskipTests");
                commands.add("-DskipITs");
                commands.add("-Dmaven.test.skip=true");
                commands.add("--fail-fast");
                commands.add("--nsu");
                commands.add("-Denforcer.skip=true");
                this.collectorDataBuilder.setBuildCommandType(BuildCommandType.DEFAULT);
            }
        } else {
            commands.add("package");
            commands.add("-Dcheckstyle.skip=true");
            commands.add("-e");
            commands.add("-DskipTests");
            commands.add("-DskipITs");
            commands.add("--fail-fast");
            commands.add("--nsu");
            commands.add("-Denforcer.skip=true");
            this.collectorDataBuilder.setBuildCommandType(BuildCommandType.FALLBACK);
        }
        String pluginVersion = this.getPluginVersion();
        commands.add(String.format("com.srcclr:srcclr-maven-plugin:%s:scan", pluginVersion));
        commands.add("--batch-mode");
        commands.add("-DheadlessOutputFile=" + graphFile);
        pb.command(commands);
        Utils.logExecutable("Maven", commands, LOGGER, this.logStream);
        this.collectorDataBuilder.setBuildCommand(Joiner.on((String)" ").join((Iterable)commands));
        return pb.start();
    }

    static Collection<String> splitOnUnquotedWhitespace(String command) {
        if (command == null) {
            return Collections.emptyList();
        }
        String regexString = "\"(?<double>[^\"].*)(?<!\\\\)\"|'(?<single>[^'].*)(?<!\\\\)'|(?<plain>\\S+)";
        Pattern regex = Pattern.compile("\"(?<double>[^\"].*)(?<!\\\\)\"|'(?<single>[^'].*)(?<!\\\\)'|(?<plain>\\S+)");
        Matcher matcher = regex.matcher(command);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            String doubleQuoted = matcher.group("double");
            String singleQuoted = matcher.group("single");
            String plain = matcher.group("plain");
            if (doubleQuoted != null) {
                result.add(doubleQuoted);
                continue;
            }
            if (singleQuoted != null) {
                result.add(singleQuoted);
                continue;
            }
            result.add(plain);
        }
        return result;
    }

    @Override
    protected boolean hasFallbackBuildProcess() {
        return this.customCommand == null;
    }

    private File resolveMvnOrThrow(@Nullable ProcessBuilder pb, String flavorText) throws CollectionException {
        String exeName = "mvn";
        String mavenPath = (String)this.attributes.get((Object)"CUSTOM_MAVEN_EXEC");
        if (!Strings.isNullOrEmpty((String)mavenPath)) {
            try {
                return CollectorUtils.ensureExistsAndExecutable(new File(mavenPath), flavorText);
            }
            catch (CollectionException e) {
                String srcclrMavenTestMsg = "Please ensure that the value of CUSTOM_MAVEN_EXEC in " + ComponentEngineBuilder.getDirectivesFile() + " is specified correctly\nand is executable.";
                throw new CollectionException(e.getExceptionType(), e.getMessage() + srcclrMavenTestMsg, e.getErrorLog());
            }
        }
        try {
            return CollectorUtils.resolveExeOrThrow("mvn", flavorText);
        }
        catch (CollectionException e) {
            LOGGER.debug("Unable to resolve system Maven, trying the wrapper", (Throwable)e);
            try {
                File mvnw = this.getOrCreateMvnWrapperFile();
                if (pb != null) {
                    Map<String, String> envMap = pb.environment();
                    envMap.put("MAVEN_BASEDIR", mvnw.getParent());
                }
                return mvnw;
            }
            catch (IOException ioe) {
                LOGGER.debug("Unable to extract Maven wrapper, good luck", (Throwable)ioe);
                throw e;
            }
        }
    }

    private void untarArchiveToDir(TarArchiveInputStream stream, File destDir) throws IOException {
        TarArchiveEntry entry;
        while ((entry = stream.getNextTarEntry()) != null) {
            if (!entry.isFile()) continue;
            File entryFile = new File(entry.getName());
            File destFile = new File(destDir, entryFile.toString());
            FileUtils.forceMkdir((File)destFile.getParentFile());
            FileOutputStream fileOutputStream = new FileOutputStream(destFile);
            Throwable throwable = null;
            try {
                IOUtils.copy((InputStream)stream, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileOutputStream == null) continue;
                if (throwable != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileOutputStream.close();
            }
        }
    }

    private void createDirectory(File file) throws IOException {
        if (!file.exists() && !file.mkdir()) {
            throw new IOException(String.format("Could not create the file %s!", file.toString()));
        }
    }

    @VisibleForTesting
    File getOrCreateMvnWrapperFile() throws IOException {
        this.createDirectory(srcclrHome);
        File mvnwDir = new File(srcclrHome, "mvnw");
        this.createDirectory(mvnwDir);
        File mvnwVersionDir = new File(mvnwDir, String.format("maven-wrapper-%s", MAVEN_WRAPPER_VERSION));
        this.createDirectory(mvnwVersionDir);
        File mvnwFile = new File(mvnwVersionDir, "mvnw");
        if (mvnwFile.exists()) {
            return mvnwFile;
        }
        try (InputStream tarGzMvnwInStream = this.getClass().getClassLoader().getResourceAsStream(String.format("io/takari/maven-wrapper-%s.tar.gz", MAVEN_WRAPPER_VERSION));
             GzipCompressorInputStream gzipInputStream = new GzipCompressorInputStream(tarGzMvnwInStream);
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)gzipInputStream);){
            this.untarArchiveToDir(tarArchiveInputStream, mvnwDir);
        }
        OS.setPosixFilePermissions(mvnwFile.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
        return mvnwFile;
    }

    private String getPluginVersion() throws IOException {
        String envVersion = System.getenv(PLUGIN_VERSION_ENV);
        if (envVersion != null) {
            return envVersion;
        }
        return this.client.getGenerationVersion(BuildSystemClientType.MAVEN, LibraryGraphSerializer.getCurrentGeneration());
    }
}

