/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.CollectionResult;
import com.sourceclear.engine.component.ComponentEngineBuilder;
import com.sourceclear.engine.component.Utils;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.JsonComponentGraphNativeCollector;
import com.sourceclear.util.fingerprints.Version;
import com.sourceclear.util.fingerprints.VersionResolver;
import com.sourceclear.util.io.SrcclrIo;
import com.sourceclear.util.system.SystemItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradleNativeCollector
extends JsonComponentGraphNativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GradleNativeCollector.class);
    private static final String GRADLEW = "gradlew";
    private static final List<String> DEFAULT_TASKS = Arrays.asList("projects", "classes");
    private static final List<String> DEFAULT_ANDROID_TASKS = Collections.singletonList("projects");
    public static final String DEFAULT_SCOPE_GRADLE_2X = "compile";
    public static final String DEFAULT_SCOPE_GRADLE_31 = "runtime";
    public static final String DEFAULT_ANDROID_CONFIGURATION = "debugCompileClasspath";
    private static final String SCOPE_ENV_VAR = "SRCCLR_SCOPE";
    private SCAN_MODE scanMode = null;
    private static final String gradlePathMsg = "Please ensure that gradle is installed and can be found on PATH.";
    private static final String gradleDirectiveMsg = String.format("If you are using a custom gradle executable, the path must be specified correctly through %s directive in %s.", "CUSTOM_GRADLE_EXEC", ComponentEngineBuilder.getDirectivesFile());
    private static final VersionResolver VERSION_RESOLVER = VersionResolver.getInstance();

    static Collection<String> gradleTasks(Map<String, Object> attributes, boolean isAndroidProject) {
        Collection<String> tasks = GradleNativeCollector.determineDefaultTasks(isAndroidProject);
        Object gradleTasks = attributes.get("GRADLE_TASKS");
        if (gradleTasks instanceof String) {
            String gradleTask = (String)gradleTasks;
            if (Strings.isNullOrEmpty((String)gradleTask)) {
                return tasks;
            }
            return Arrays.asList(gradleTask.split("\\s"));
        }
        if (gradleTasks instanceof List) {
            List tasksList = (List)gradleTasks;
            return tasksList;
        }
        LOGGER.debug("GRADLE_TASKS is neither a string or a list: {}", gradleTasks);
        LOGGER.debug("Running default tasks: {}", tasks);
        return tasks;
    }

    private static Collection<String> determineDefaultTasks(boolean isAndroidProject) {
        if (isAndroidProject) {
            return DEFAULT_ANDROID_TASKS;
        }
        return DEFAULT_TASKS;
    }

    static String defaultScope(boolean android, Optional<String> gradleVersion) {
        if (android) {
            return DEFAULT_ANDROID_CONFIGURATION;
        }
        if (!gradleVersion.filter(StringUtils::isNotBlank).isPresent()) {
            return DEFAULT_SCOPE_GRADLE_2X;
        }
        Version resolvedVersion = VERSION_RESOLVER.resolve(gradleVersion.get());
        if (resolvedVersion.compareTo(VERSION_RESOLVER.resolve("3.1")) < 0) {
            return DEFAULT_SCOPE_GRADLE_2X;
        }
        return DEFAULT_SCOPE_GRADLE_31;
    }

    private static String getGradleVersion(List<String> gradleVersionCommand) throws Exception {
        Process process = new ProcessBuilder(new String[0]).command(gradleVersionCommand).start();
        return GradleNativeCollector.getGradleVersion(process);
    }

    @VisibleForTesting
    static String getGradleVersion(Process process) throws Exception {
        Pattern gradleVersionPattern = SystemItem.GRADLE.getVersionPattern();
        String version = null;
        IOUtils.closeQuietly((OutputStream)process.getOutputStream());
        Future<String> output = SrcclrIo.readAsync(process.getInputStream());
        Future<String> error = SrcclrIo.readAsync(process.getErrorStream());
        int rc = process.waitFor();
        if (rc == 0) {
            for (Future outFuture : Arrays.asList(output, error)) {
                Matcher m = gradleVersionPattern.matcher((CharSequence)outFuture.get());
                if (!m.matches()) continue;
                version = m.group("version");
                break;
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (Future outFuture : Arrays.asList(output, error)) {
                sb.append((String)outFuture.get());
            }
            LOGGER.debug("non-zero rc when getting gradle version: {}. stderr: {}", (Object)rc, (Object)sb.toString());
        }
        return version == null ? null : version.trim();
    }

    public GradleNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, "Gradle", attributes);
    }

    @Override
    public String getName() {
        return "Gradle";
    }

    @Override
    public boolean supports(File projectPath) {
        return Files.exists(GradleNativeCollector.getGradlew(projectPath.toPath(), (Map<String, Object>)this.attributes), new LinkOption[0]) || CollectorUtils.fileExistsWithinFolder(projectPath, "build.gradle");
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames("build.gradle");
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        boolean systemReady;
        String gradlewURL = "https://docs.gradle.org/current/userguide/gradle_wrapper.html";
        Path gradlew = GradleNativeCollector.getGradlew(projectDir.toPath(), (Map<String, Object>)this.attributes);
        String gradlewMsg = String.format("Please ensure that \"%s\" exist (and is executable) in the\n\"%s\" folder (See %s for more information.)", gradlew.toAbsolutePath(), projectDir.getAbsolutePath(), "https://docs.gradle.org/current/userguide/gradle_wrapper.html");
        String resolveGradleErrorMessage = "";
        if (Files.exists(gradlew, new LinkOption[0])) {
            try {
                CollectorUtils.ensureExistsAndExecutable(gradlew.toFile(), "gradlew was found in the project directory but it is not executable.\n Ensure that the correct permissions are set in order to use it. Error: ");
                this.scanMode = SCAN_MODE.GRADLE_WRAPPER;
                systemReady = true;
            }
            catch (CollectionException e) {
                resolveGradleErrorMessage = e.getMessage();
                this.scanMode = null;
                systemReady = false;
            }
        } else {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, "gradlew does not exist in project directory. Attempting to use gradle...");
            try {
                this.resolveGradleExeOrThrow();
                this.scanMode = SCAN_MODE.RAW_GRADLE;
                systemReady = true;
            }
            catch (CollectionException resolveGradleExeException) {
                resolveGradleErrorMessage = resolveGradleExeException.getMessage();
                this.scanMode = null;
                systemReady = false;
            }
        }
        if (!systemReady) {
            String testGradleMsg = "After ensuring the above conditions are set up, you may run\n  srcclr test --gradle\nto confirm your system can build and scan Gradle projects.";
            String srcclrHelpfulMsg = String.format("\nPLEASE NOTE: SourceClear currently requires one of the following conditions to be satisfied to scan Gradle projects:\n1) %s\n2) %s\n3) %s\n\n%s", gradlewMsg, gradlePathMsg, gradleDirectiveMsg, "After ensuring the above conditions are set up, you may run\n  srcclr test --gradle\nto confirm your system can build and scan Gradle projects.");
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, resolveGradleErrorMessage + "\n" + srcclrHelpfulMsg);
        }
        return systemReady;
    }

    @Override
    public Optional<CollectionResult.Advice> adviseOnFailure() {
        if (this.scanMode == null) {
            return Optional.empty();
        }
        return Optional.of(new CollectionResult.Advice(this.getName(), String.format("do check that `%s app:dependencies` (possibly replacing \"app\" with your subproject name) completes successfully as a sanity check; you may need to provide the name of a configuration from there via SRCCLR_SCOPE", new Object[]{this.scanMode})));
    }

    private File resolveGradleExeOrThrow() throws CollectionException {
        String gradleExe = "gradle";
        String gradlePath = (String)this.attributes.get((Object)"CUSTOM_GRADLE_EXEC");
        if (!Strings.isNullOrEmpty((String)gradlePath)) {
            return CollectorUtils.ensureExistsAndExecutable(new File(gradlePath), gradleDirectiveMsg);
        }
        return CollectorUtils.resolveExeOrThrow("gradle", gradlePathMsg);
    }

    private File generateInitScript() throws IOException {
        String initScriptContents = IOUtils.toString((InputStream)GradleNativeCollector.class.getResourceAsStream("/srcclrgraph.gradle"), (Charset)Charset.defaultCharset());
        File scriptFile = File.createTempFile("init-", ".gradle");
        scriptFile.deleteOnExit();
        try (FileOutputStream os = new FileOutputStream(scriptFile);){
            IOUtils.write((String)initScriptContents, (OutputStream)os, (Charset)Charset.defaultCharset());
        }
        return scriptFile;
    }

    @Override
    protected Process makeGraphBuildingProcess(File projectRoot, File graphFile, boolean useFallback) throws CollectionException, IOException {
        String scopeToUse;
        String gradleExecutablePath;
        File initScript;
        try {
            initScript = this.generateInitScript();
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "Couldn't create temporary init script: " + ex.getMessage()).initCause(ex);
        }
        if (this.scanMode == null) {
            LOGGER.debug("scanMode is null when makeGraphBuildingProcess() is called. Calling systemIsReady() to set scanMode first...");
            if (!this.systemIsReady(projectRoot)) {
                throw new CollectionException(CollectionErrorType.SYSTEM, "Gradle system not ready for build");
            }
        }
        if (this.scanMode == SCAN_MODE.GRADLE_WRAPPER) {
            Path gradlew = GradleNativeCollector.getGradlew(projectRoot.toPath(), (Map<String, Object>)this.attributes);
            CollectorUtils.ensureExistsAndExecutable(gradlew.toFile(), "");
            gradleExecutablePath = gradlew.toRealPath(new LinkOption[0]).toString();
        } else {
            gradleExecutablePath = this.resolveGradleExeOrThrow().getAbsolutePath();
        }
        String customScope = (String)this.attributes.get((Object)"SCOPE");
        boolean isAndroidProject = this.isAndroidProject(gradleExecutablePath, projectRoot);
        if (StringUtils.isNotBlank((CharSequence)customScope)) {
            scopeToUse = customScope;
            LOGGER.debug("user custom scope: {}", (Object)scopeToUse);
        } else {
            Optional<String> gradleVersion = this.getGradleVersion(gradleExecutablePath);
            scopeToUse = GradleNativeCollector.defaultScope(isAndroidProject, gradleVersion);
            LOGGER.debug("default scope set to: {}", (Object)scopeToUse);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(gradleExecutablePath);
        if (this.attributes.containsKey((Object)"GRADLE_LOCATION")) {
            commands.add("-p");
            commands.add(projectRoot.getAbsolutePath());
        }
        commands.add("-Psrcclr.graph.location=" + graphFile.getAbsolutePath());
        commands.add("--init-script");
        commands.add(initScript.toString());
        commands.addAll(GradleNativeCollector.gradleTasks((Map<String, Object>)this.attributes, isAndroidProject));
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        CollectorUtils.populateEnvVars((Map<String, Object>)this.attributes, pb);
        pb.environment().put(SCOPE_ENV_VAR, scopeToUse);
        String gradleFilterTask = (String)this.attributes.get((Object)"GRADLE_FILTER_TASK");
        if (!Strings.isNullOrEmpty((String)gradleFilterTask)) {
            pb.environment().put("GRADLE_FILTER_TASK", gradleFilterTask);
        }
        pb.directory(projectRoot);
        pb.redirectErrorStream(true);
        pb.command(commands);
        Utils.logExecutable("Gradle Graph Building", commands, LOGGER, this.logStream);
        return pb.start();
    }

    private Optional<String> getGradleVersion(String gradleExecutablePath) {
        Optional<String> gradleVersion;
        try {
            ArrayList<String> gradleVersionCommand = new ArrayList<String>();
            gradleVersionCommand.add(gradleExecutablePath);
            gradleVersionCommand.add("--version");
            LOGGER.debug("Executing '{}' to get gradle version.", (Object)Joiner.on((String)" ").join(gradleVersionCommand));
            gradleVersion = Optional.ofNullable(GradleNativeCollector.getGradleVersion(gradleVersionCommand));
        }
        catch (Exception ex) {
            LOGGER.info("Error encountered when checking version of '{}': ", (Object)gradleExecutablePath, (Object)ex);
            gradleVersion = Optional.empty();
        }
        LOGGER.debug("version found from executing '{}': '{}'", (Object)gradleExecutablePath, gradleVersion);
        return gradleVersion;
    }

    private boolean isAndroidProject(String gradleExecutable, File projectRoot) {
        try {
            boolean result;
            List<String> command = Arrays.asList(gradleExecutable, "androidDependencies");
            Process process = new ProcessBuilder(new String[0]).command(command).directory(projectRoot).redirectErrorStream(true).start();
            try {
                OutputStream ignored = process.getOutputStream();
                Throwable throwable = null;
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.debug("Error occurred when closing OutputStream of %s", (Object)command.toString(), (Object)ex);
                return false;
            }
            CollectorUtils.readAsync(process.getInputStream(), this.logStream, LOGGER, "com.srcclr.evidence.compilation", Stage.EVIDENCE_COLLECTION);
            int rc = process.waitFor();
            boolean bl = result = rc == 0;
            if (result) {
                LOGGER.debug("Using Android project defaults");
            }
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    static Path getGradlew(Path projectRoot, Map<String, Object> attributes) {
        boolean gradleLocationIsDefined;
        String gradleLocation = (String)attributes.get("GRADLE_LOCATION");
        boolean bl = gradleLocationIsDefined = gradleLocation != null;
        if (gradleLocationIsDefined) {
            return projectRoot.resolve(gradleLocation).toAbsolutePath();
        }
        return projectRoot.resolve(GRADLEW);
    }

    private static enum SCAN_MODE {
        GRADLE_WRAPPER("./gradlew"),
        RAW_GRADLE("gradle");

        private final String name;

        private SCAN_MODE(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

