/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.ComponentEngineBuilder;
import com.sourceclear.engine.component.Utils;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.GoPackageManagerCollector;
import com.sourceclear.engine.component.golang.GoDependencyGraph;
import com.sourceclear.engine.component.golang.GoPackage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GoGetNativeCollector
extends GoPackageManagerCollector {
    private static final Set<String> GO_PACKAGE_MANAGER_FILES = Sets.newHashSet((Object[])new String[]{"Godeps/Godeps.json", "vendor/vendor.json", ".gopmfile", "vendor/manifest", "vendor.yml", "glide.yaml", "glide.lock", "vendor.conf", "Gomfile", "bunchfile", "Goopfile", ".go.yaml", "GLOCKFILE", "goproject.json", "gopack.config", "Nut.toml", "Gopkg.toml", "Gopkg.lock"});
    private static final String VENDOR = "vendor";
    private static final String GO = "go";
    private static final String GIT = "git";
    private static final Set<String> GO_EXTENSIONS = Sets.newHashSet((Object[])new String[]{".go"});
    private static final Set<String> IGNORED_DIRECTORIES = Sets.newHashSet((Object[])new String[]{"vendor", "node_modules"});

    public GoGetNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, attributes);
    }

    @Override
    public String getName() {
        return "go get";
    }

    @Override
    public boolean supports(File projectPath) {
        try {
            boolean goFiles = this.containsGoFiles(projectPath);
            boolean noPackageManagerFiles = !this.goPackageManagerFileExist(projectPath);
            boolean userSpecified = this.isSpecifiedByUser();
            return goFiles && (noPackageManagerFiles || userSpecified);
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, "Error while checking whether GoGetNativeCollector supports project: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return Sets.newHashSet((Object[])new Pattern[]{Pattern.compile(".+\\.go")});
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        return super.systemIsReady(projectDir) && this.gitIsInstalled();
    }

    @Override
    protected List<GoPackage> getResolvedImports(File projectRoot, GoDependencyGraph goDependencyGraph, List<String> goPaths) throws CollectionException {
        Path vendorDirectory = projectRoot.toPath().resolve(VENDOR);
        ArrayList<Path> goPathSrcDirectories = new ArrayList<Path>();
        for (String path : goPaths) {
            Path srcPath;
            if (!StringUtils.isNotBlank((String)path) || !Files.exists(srcPath = Paths.get(path, "src"), new LinkOption[0])) continue;
            goPathSrcDirectories.add(srcPath);
        }
        ArrayList<Path> directoriesToSearch = new ArrayList<Path>();
        if (Files.exists(vendorDirectory, new LinkOption[0])) {
            LOGGER.debug("adding '{}' to directoriesToSearch", (Object)vendorDirectory);
            directoriesToSearch.add(vendorDirectory);
        }
        LOGGER.debug("adding '{}' to directoriesToSearch", goPathSrcDirectories);
        directoriesToSearch.addAll(goPathSrcDirectories);
        Set<GoDependencyGraph> directDeps = goDependencyGraph.getChildren();
        return this.getImportsAndTheirRevisions(directDeps, directoriesToSearch);
    }

    @Override
    @Nullable
    protected String getPackageNameUnderScan() {
        return null;
    }

    @Override
    protected String getIdentityFilename() {
        return "";
    }

    @Override
    @Nullable
    protected String getBinName() {
        return GO;
    }

    @Override
    @Nullable
    protected List<String> getInstallArgs() {
        return Lists.newArrayList((Object[])new String[]{"get", "-d", "./..."});
    }

    private boolean containsGoFiles(File projectPath) throws CollectionException {
        FileTypeVisitor fileTypeVisitor = new FileTypeVisitor(GO_EXTENSIONS, IGNORED_DIRECTORIES, LOGGER);
        try {
            Files.walkFileTree(projectPath.toPath(), fileTypeVisitor);
            return !fileTypeVisitor.getFiles().isEmpty();
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error searching project folder for go files: " + e.getMessage()).initCause(e);
        }
    }

    private boolean goPackageManagerFileExist(File projectPath) {
        for (String configFileNames : GO_PACKAGE_MANAGER_FILES) {
            Path filePath = Paths.get(projectPath.getAbsolutePath(), configFileNames);
            if (!Files.exists(filePath, new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecifiedByUser() {
        Set<String> collectorsToRun = ComponentEngineBuilder.getCollectorsSetUpperCase(Strings.nullToEmpty((String)((String)this.attributes.get((Object)"SCAN_COLLECTORS"))));
        return collectorsToRun.contains(this.getName().toUpperCase());
    }

    private boolean gitIsInstalled() {
        try {
            CollectorUtils.resolveExeOrThrow(GIT);
            return true;
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
    }

    private List<GoPackage> getImportsAndTheirRevisions(Set<GoDependencyGraph> goDependencyGraphs, List<Path> directoriesToSearch) throws CollectionException {
        ArrayList<GoPackage> resolvedImports = new ArrayList<GoPackage>();
        for (GoDependencyGraph goDependencyGraph : goDependencyGraphs) {
            GoPackage goPackage = this.getGoPackage(goDependencyGraph.getImportPath(), directoriesToSearch);
            if (goPackage != null) {
                resolvedImports.add(goPackage);
            }
            resolvedImports.addAll(this.getImportsAndTheirRevisions(goDependencyGraph.getChildren(), directoriesToSearch));
        }
        return resolvedImports;
    }

    private GoPackage getGoPackage(String importPath, List<Path> directoriesToSearch) throws CollectionException {
        for (Path directory : directoriesToSearch) {
            Path subDirectory = directory.resolve(importPath);
            if (!Files.exists(subDirectory, new LinkOption[0])) continue;
            if (!Utils.directoryIsGitRepoOrGitSubRepo(subDirectory)) {
                LOGGER.debug("{} does not have git repository. Unable to get checked out revision.", (Object)subDirectory);
                continue;
            }
            Pair<String, String> revAndRepo = this.getRevAndRepoWithGitCommand(subDirectory);
            try {
                if (StringUtils.isNotBlank((String)((String)revAndRepo.getRight()))) {
                    return new GoPackage(importPath, (String)revAndRepo.getLeft(), 0, (String)revAndRepo.getRight());
                }
                return new GoPackage(importPath, (String)revAndRepo.getLeft(), 0);
            }
            catch (URISyntaxException e) {
                throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, e.getMessage()).initCause(e);
            }
        }
        return null;
    }

    private Pair<String, String> getRevAndRepoWithGitCommand(Path directory) throws CollectionException {
        String remote;
        String hash = Utils.getCheckedOutRevision(directory);
        try {
            remote = Utils.getRepositoryUrl(directory).trim();
        }
        catch (CollectionException e) {
            remote = "";
        }
        remote = remote.endsWith(".git") ? remote.substring(0, remote.length() - 4) : remote;
        return Pair.of((Object)hash, (Object)remote);
    }
}

