/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.ComponentEngineBuilder;
import com.sourceclear.engine.component.Utils;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.gem.Gem;
import com.sourceclear.engine.component.gem.GemfileDotLockToGraph;
import com.sourceclear.engine.component.gem.GemfileParser;
import com.sourceclear.util.io.SrcclrIo;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GemNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GemNativeCollector.class);
    private static final String GEMFILE = "Gemfile";
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;

    public GemNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return "Gem";
    }

    @Override
    public boolean supports(File projectPath) {
        return CollectorUtils.fileExistsWithinFolder(projectPath, GEMFILE) || CollectorUtils.fileExistsWithinFolder(projectPath, "Gemfile.lock");
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(GEMFILE, "Gemfile.lock");
    }

    @Override
    public boolean systemIsReady(File dir) {
        if (CollectorUtils.fileExistsWithinFolder(dir, "Gemfile.lock")) {
            return true;
        }
        try {
            this.resolveBundleExeOrThrow();
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        File lockFile = new File(projectRoot, "Gemfile.lock");
        boolean forceBundleInstall = Objects.equals(Boolean.TRUE, this.attributes.get((Object)"FORCE_BUNDLE_INSTALL"));
        try {
            if (!lockFile.canRead() || forceBundleInstall) {
                try {
                    this.createLockFile(projectRoot);
                }
                catch (CollectionException ex) {
                    if (!lockFile.canRead()) {
                        throw ex;
                    }
                    LOGGER.warn("***** Could not run 'bundle install', attempting to scan using the existing Gemfile.lock *****");
                }
            }
            LibraryGraph graph = GemfileDotLockToGraph.convert(lockFile.toPath());
            String scope = (String)this.attributes.get((Object)"SCOPE");
            if (!Strings.isNullOrEmpty((String)scope)) {
                Path gemfile = projectRoot.toPath().resolve(GEMFILE);
                if (Files.exists(gemfile, new LinkOption[0])) {
                    List<Gem> gems;
                    try (FileReader reader = new FileReader(gemfile.toFile());){
                        gems = GemfileParser.parse(reader);
                    }
                    catch (Exception ex) {
                        LOGGER.debug("Parsing {} did not pan out", (Object)gemfile, (Object)ex);
                        throw new CollectionException(CollectionErrorType.PARSE, "Unable to parse Gemfile:" + ex.getMessage()).initCause(ex);
                    }
                    graph = GemNativeCollector.filterSubgraphInGroup(graph, scope, gems);
                } else {
                    throw new CollectionException(CollectionErrorType.IO, "Gemfile not found. Unable to limit scan to bundler group");
                }
            }
            return new LibraryGraphContainer.Builder().withGraph(graph).build();
        }
        catch (CollectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CollectionException(CollectionErrorType.UNKNOWN, ex.getMessage()).initCause(ex);
        }
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).build();
    }

    static LibraryGraph filterSubgraphInGroup(LibraryGraph graph, String group, List<Gem> gems) {
        Set<Gem> gemsInGroup = GemNativeCollector.filterGemsInGroup(gems, group);
        HashSet<String> gemNames = new HashSet<String>();
        for (Gem gem : gemsInGroup) {
            gemNames.add(gem.getName());
        }
        HashSet<LibraryGraph> directsInGroup = new HashSet<LibraryGraph>();
        for (LibraryGraph directDependency : graph.getDirects()) {
            if (!gemNames.contains(directDependency.getCoords().getCoordinate1())) continue;
            directsInGroup.add(directDependency);
        }
        graph = new LibraryGraph.Builder().withDirects(directsInGroup).build();
        return graph;
    }

    static Set<Gem> filterGemsInGroup(List<Gem> gems, String group) {
        HashSet<Gem> gemsInGroup = new HashSet<Gem>();
        for (Gem gem : gems) {
            if (!gem.getGroups().contains(group)) continue;
            gemsInGroup.add(gem);
        }
        return gemsInGroup;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return true;
    }

    private void createLockFile(File projectRoot) throws CollectionException {
        int retValue;
        String output;
        File bundleFile = this.resolveBundleExeOrThrow();
        ArrayList commands = Lists.newArrayList((Object[])new String[]{bundleFile.getAbsolutePath(), "install", "--path", "vendor/bundle"});
        Utils.logExecutable("Bundle Install", commands, LOGGER, this.logStream);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        CollectorUtils.populateEnvVars(this.attributes, pb);
        pb.directory(projectRoot);
        pb.command(commands);
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            output = CollectorUtils.readAndLog(process.getInputStream(), this.logStream, LOGGER, "com.srcclr.evidence.pacakge", Stage.EVIDENCE_COLLECTION);
            retValue = process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new CollectionException(CollectionErrorType.IO, "The scan was interrupted while waiting for process completion.").initCause(ex);
        }
        catch (Exception ex) {
            throw new CollectionException(CollectionErrorType.IO, "An I/O error happened while running Bundler", ex.getMessage());
        }
        if (retValue != 0) {
            String suggestPossibleErrors = "SourceClear couldn't build the project\n" + projectRoot + " because bundle install failed.\n\nBecause of this, SourceClear cannot scan it. We suggest checking the following:\n1) If you specified true for " + "FORCE_BUNDLE_INSTALL" + " in " + ComponentEngineBuilder.getDirectivesFile() + ", ensure that Gemfile is readable and is not corrupted.\n2) If you do not wish to force a bundle install, ensure that Gemfile.lock is readable and not corrupted.\nPlease ensure that the error is resolved before scanning.";
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, suggestPossibleErrors, output);
        }
    }

    private File resolveBundleExeOrThrow() throws CollectionException {
        String exeName = "bundle";
        String cannotFindExe = String.format("Cannot find the \"%s\" executable on PATH.", "bundle");
        String flavorText = "Please ensure that bundle is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --gem\nto confirm that srcclr can build and scan Gem projects.";
        String cannotFindError = String.format("%s%n%s", cannotFindExe, "Please ensure that bundle is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --gem\nto confirm that srcclr can build and scan Gem projects.");
        String bundlePath = SrcclrIo.resolveExecutable("bundle");
        if (Strings.isNullOrEmpty((String)bundlePath)) {
            throw new CollectionException(CollectionErrorType.SYSTEM, cannotFindError);
        }
        File bundleFile = new File(bundlePath);
        if (!bundleFile.canExecute()) {
            String fullPathname = bundleFile.getAbsolutePath();
            String cannotExecFileMsg = String.format("Cannot use \"%s\" because it is not executable", fullPathname);
            throw new CollectionException(CollectionErrorType.SYSTEM, String.format("%s%n%s", cannotExecFileMsg, "Please ensure that bundle is installed and can be found on PATH.\nAfter that, you may run:\n  srcclr test --gem\nto confirm that srcclr can build and scan Gem projects."));
        }
        return bundleFile;
    }
}

