/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.analysis.dotnet.Executable;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.common.FeatureFlag;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.dllutils.DLLAnalyzer;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLLNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DLLNativeCollector.class);
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attrs;
    private final boolean shallow;
    private ImmutableSet<Path> dllsFound;
    private final FileTypeVisitor dllVisitor = new FileTypeVisitor(Sets.newHashSet((Object[])new String[]{".dll"}), Sets.newHashSet((Object[])new String[]{"bin", "obj"}), LOGGER);
    private final Client client;

    static ImmutableSet<Path> findDLLsInFolder(File projectRoot) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(projectRoot.toPath(), "*.dll");){
            ImmutableSet immutableSet = new ImmutableSet.Builder().addAll((Iterable)StreamSupport.stream(dirStream.spliterator(), false).collect(Collectors.toSet())).build();
            return immutableSet;
        }
    }

    public DLLNativeCollector(LogStream logStream, ImmutableMap<String, Object> attrs, boolean shallow) {
        this.logStream = logStream;
        this.attrs = attrs;
        this.shallow = shallow;
        SourceClearClient.Builder builder = new SourceClearClient.Builder().withExpBackOffInitial(0);
        URI apiBase = (URI)attrs.get((Object)"API_BASE_URI");
        if (apiBase != null) {
            builder.withBaseURI(apiBase);
        }
        this.client = builder.build();
    }

    @Override
    public String getName() {
        return "DLL";
    }

    @Override
    public boolean supports(File projectPath) {
        if (!FeatureFlag.featureIsOn(FeatureFlag.Flag.ENABLE_DOTNET, this.attrs)) {
            return false;
        }
        try {
            if (this.shallow) {
                LOGGER.debug("shallow=true. DLLNativeCollector searches for dlls in the project directory only.");
                this.dllsFound = DLLNativeCollector.findDLLsInFolder(projectPath);
            } else {
                Files.walkFileTree(projectPath.toPath(), this.dllVisitor);
                this.dllsFound = this.dllVisitor.getFiles();
            }
        }
        catch (IOException ioexception) {
            LOGGER.debug("Unable to search project '{}' for dlls: ", (Object)projectPath, (Object)ioexception);
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, String.format("Unable to search project '%s' for dlls.", projectPath));
            return false;
        }
        return !this.dllsFound.isEmpty();
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return Sets.newHashSet((Object[])new Pattern[]{Pattern.compile(".+\\.dll")});
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        return !this.dllsFound.isEmpty();
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        DLLAnalyzer dllAnalyzer = new DLLAnalyzer(this.buildSrcdot());
        Set dllLibraryGraphs = this.dllsFound.stream().flatMap(dll -> dllAnalyzer.analyze((Path)dll, projectRoot.toPath().relativize((Path)dll).toString()).stream()).collect(Collectors.toSet());
        LOGGER.debug("Found {} library graphs for {} dlls.", (Object)dllLibraryGraphs.size(), (Object)this.dllsFound.size());
        return new LibraryGraphContainer.Builder().withGraphs(dllLibraryGraphs).build();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }

    @VisibleForTesting
    Executable buildSrcdot() {
        return new Executable(this.client);
    }
}

