/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.composer.ComposerCollectorUtils;
import com.sourceclear.engine.component.composer.ComposerLock;
import com.sourceclear.engine.component.composer.ComposerParser;
import com.sourceclear.engine.component.composer.ComposerTreeNode;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposerNativeCollector
implements NativeCollector {
    private static final String COMPOSER_JSON = "composer.json";
    private static final String COMPOSER_LOCK = "composer.lock";
    private static final String COMPOSER = "composer";
    private static final String PHP = "php";
    private static final String COMPOSER_PHAR = "composer.phar";
    private static final String NO_ANSI = "--no-ansi";
    private static final String NO_INTERACTION = "--no-interaction";
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerNativeCollector.class);
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;
    private ImmutableList<String> composerCommand = null;
    private final CollectorData.Builder collectorDataBuilder = new CollectorData.Builder();

    public ComposerNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return "Composer";
    }

    @Override
    public boolean supports(File projectPath) {
        return Files.exists(projectPath.toPath().resolve(COMPOSER_JSON), new LinkOption[0]) || Files.exists(projectPath.toPath().resolve(COMPOSER_LOCK), new LinkOption[0]);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(COMPOSER_LOCK, COMPOSER_JSON);
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        try {
            CollectorUtils.resolveExeOrThrow(PHP, "php could not be found on $PATH\n");
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        if (Files.exists(projectDir.toPath().resolve(COMPOSER_PHAR), new LinkOption[0])) {
            this.composerCommand = new ImmutableList.Builder().add((Object)PHP).add((Object)COMPOSER_PHAR).build();
        } else {
            try {
                CollectorUtils.resolveExeOrThrow(COMPOSER, String.format("Project does not have %s and %s could not be found on $PATH\n", COMPOSER_PHAR, COMPOSER));
            }
            catch (CollectionException e) {
                this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
                return false;
            }
            this.composerCommand = new ImmutableList.Builder().add((Object)COMPOSER).build();
        }
        return true;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        boolean noValidTreeOutput;
        ComposerTreeNode rootNode;
        if (this.composerCommand == null || this.composerCommand.isEmpty()) {
            throw new RuntimeException("composerCommand is empty. This should not happen.");
        }
        LOGGER.debug("composerCommand: {}", (Object)Joiner.on((String)" ").join(this.composerCommand));
        String scope = Strings.nullToEmpty((String)((String)this.attributes.get((Object)"SCOPE"))).trim();
        LOGGER.debug("scope: '{}'", (Object)scope);
        boolean noDev = "--no-dev".equals(scope);
        ImmutableList installOptions = StringUtils.isNotBlank((String)scope) ? new ImmutableList.Builder().add((Object)scope).build() : ImmutableList.of();
        boolean skipComposerInstall = Boolean.valueOf(String.valueOf(this.attributes.get((Object)"SKIP_COMPOSER_INSTALL")));
        if (!skipComposerInstall) {
            LOGGER.debug("Running composer install.");
            this.runInstall(this.composerCommand, projectRoot, (ImmutableList<String>)installOptions);
        } else {
            this.collectorDataBuilder.setBuildCommandType(BuildCommandType.NOT_NEEDED);
        }
        try {
            List<String> composerTree = ComposerNativeCollector.runComposerTree(this.composerCommand, projectRoot);
            rootNode = ComposerParser.parseComposerTree(composerTree);
        }
        catch (CollectionException ce) {
            LOGGER.debug("error running composer tree to get dependencies tree: ", (Throwable)ce);
            LOGGER.debug("will attempt to parse files for dependencies tree instead.");
            rootNode = null;
        }
        Path composerDotLockPath = projectRoot.toPath().resolve(COMPOSER_LOCK);
        if (!Files.exists(composerDotLockPath, new LinkOption[0])) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, String.format("Unable to proceed collecting graph information because %s does not exist in folder.", COMPOSER_LOCK));
        }
        ComposerLock composerLock = ComposerParser.parseComposerLockFile(composerDotLockPath);
        LOGGER.debug("Finished parsing composer tree output and {} file.", (Object)composerDotLockPath);
        String filename = COMPOSER_LOCK;
        LibraryGraph.Builder rootGraphBuilder = new LibraryGraph.Builder();
        rootGraphBuilder.withFilename(COMPOSER_LOCK);
        HashSet<LibraryGraph> projectDirects = new HashSet<LibraryGraph>();
        boolean bl = noValidTreeOutput = rootNode == null || rootNode.getChildren().isEmpty();
        if (noValidTreeOutput) {
            LOGGER.debug("composer show --tree command output is empty. Unable to get graph. Parsing dependencies file as a fallback.");
            projectDirects.addAll(ComposerCollectorUtils.libraryGraphsFromLockFileAndJsonIfItExists(LOGGER, COMPOSER_LOCK, noDev, composerLock, projectRoot.toPath().resolve(COMPOSER_JSON)));
        } else {
            Map<String, Coords> packageNameToCoords = ComposerParser.composerLockPackagesToCoords(noDev, composerLock);
            projectDirects.addAll(ComposerNativeCollector.buildGraphs(rootNode.getChildren(), packageNameToCoords, COMPOSER_LOCK));
        }
        rootGraphBuilder.withDirects(projectDirects);
        return new LibraryGraphContainer.Builder().withGraph(rootGraphBuilder.build()).build();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return this.collectorDataBuilder.setCollectorName(this.getName()).build();
    }

    static Set<LibraryGraph> buildGraphs(Collection<ComposerTreeNode> nodes, Map<String, Coords> packageNameToCoords, String filename) {
        HashSet<LibraryGraph> graphs = new HashSet<LibraryGraph>();
        for (ComposerTreeNode node : nodes) {
            if (node.getName().equalsIgnoreCase(PHP)) continue;
            Set<LibraryGraph> directs = ComposerNativeCollector.buildGraphs(node.getChildren(), packageNameToCoords, filename);
            if (!packageNameToCoords.containsKey(node.getName())) {
                LOGGER.debug("Can't find {} in {}, skipping this dependency in the graph.", (Object)node.getName(), (Object)COMPOSER_LOCK);
                continue;
            }
            graphs.add(new LibraryGraph.Builder().withCoords(packageNameToCoords.get(node.getName())).withFilename(filename).withDirects(directs).build());
        }
        return graphs;
    }

    private static List<String> runComposerTree(ImmutableList<String> composerCommand, File projectRoot) throws CollectionException {
        ImmutableList command = new ImmutableList.Builder().addAll(composerCommand).add((Object)"show").add((Object)"--tree").add((Object)NO_ANSI).add((Object)NO_INTERACTION).build();
        return CollectorUtils.launchProcess((List<String>)command, projectRoot, null, LOGGER);
    }

    private void runInstall(ImmutableList<String> composerCommand, File projectRoot, ImmutableList<String> options) throws CollectionException {
        ImmutableList command = new ImmutableList.Builder().addAll(composerCommand).add((Object)"install").add((Object)NO_ANSI).add((Object)NO_INTERACTION).addAll(options).build();
        this.collectorDataBuilder.setBuildCommandType(BuildCommandType.DEFAULT).setBuildCommand(Joiner.on((String)" ").join((Iterable)command)).setBuildCommandSuccessful(false);
        CollectorUtils.launchProcess((List<String>)command, projectRoot, null, LOGGER);
        this.collectorDataBuilder.setBuildCommandSuccessful(true);
    }
}

