/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component;

import com.google.common.base.Joiner;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.CollectionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;

public final class Utils {
    private static final String GIT_FOLDER = ".git";
    private static final String GIT_REPO_FILE = ".gitrepo";

    public static void logExecutable(String name, List<String> commands, Logger logger, LogStream logStream) {
        ArrayList<String> quoted = new ArrayList<String>();
        for (String command : commands) {
            if (command.contains(" ")) {
                command = String.format("\"%s\"", StringEscapeUtils.escapeJava((String)command));
            }
            quoted.add(command);
        }
        String cmd = Joiner.on((String)" ").join(quoted);
        String logMessage = String.format("Running %s with: %s", name, cmd);
        logger.info(logMessage);
    }

    public static boolean directoryIsGitRepoOrGitSubRepo(Path directory) {
        return Files.exists(directory.resolve(GIT_FOLDER), new LinkOption[0]) || Files.exists(directory.resolve(GIT_REPO_FILE), new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCheckedOutRevision(Path directory) throws CollectionException {
        List<String> getHashCommand = Arrays.asList("git", "rev-parse", "--verify", "HEAD");
        Path dotGitRepoFile = directory.resolve(GIT_REPO_FILE);
        if (!Files.exists(dotGitRepoFile, new LinkOption[0])) return Utils.processWithCommand(getHashCommand, directory).trim();
        try (FileInputStream inputStream = new FileInputStream(dotGitRepoFile.toFile());){
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("commit").trim();
            return string;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error parsing '" + dotGitRepoFile + "'.", e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRepositoryUrl(Path directory) throws CollectionException {
        List<String> getRemoteCommand = Arrays.asList("git", "config", "--get", "remote.origin.url");
        Path dotGitRepoFile = directory.resolve(GIT_REPO_FILE);
        if (!Files.exists(dotGitRepoFile, new LinkOption[0])) return Utils.processWithCommand(getRemoteCommand, directory).trim();
        try (FileInputStream inputStream = new FileInputStream(dotGitRepoFile.toFile());){
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("remote").trim();
            return string;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error parsing '" + dotGitRepoFile + "'.", e.getMessage());
        }
    }

    private Utils() {
    }

    private static String processWithCommand(List<String> command, Path workingDirectory) throws CollectionException {
        try {
            String outAndErr;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.directory(workingDirectory.toFile());
            processBuilder.command(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            int rc = process.waitFor();
            try (InputStream is = process.getInputStream();){
                outAndErr = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            }
            if (rc != 0) {
                throw new CollectionException(CollectionErrorType.SYSTEM, outAndErr);
            }
            return outAndErr;
        }
        catch (IOException | InterruptedException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }
}

