/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.CollectionResult;
import com.sourceclear.engine.component.ComponentEngine;
import com.sourceclear.engine.component.collectors.AntNativeCollector;
import com.sourceclear.engine.component.collectors.GradleNativeCollector;
import com.sourceclear.engine.component.collectors.MavenNativeCollector;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.collectors.SbtNativeCollector;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveEngine
implements ComponentEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecursiveEngine.class);
    protected static final int DEFAULT_MAX_DEPTH = 10;
    private static final ImmutableSet<String> DEFAULT_IGNORED_FOLDERS = new ImmutableSet.Builder().add((Object)"temp").add((Object)"src/main/java").add((Object)"src/test/java").add((Object)"vendor/bundle").add((Object)"target").add((Object)"bower_components").add((Object)"node_modules").build();
    private static final ImmutableList<Class<? extends NativeCollector>> SINGLE_LEVEL_COLLECTORS = ImmutableList.of(MavenNativeCollector.class, GradleNativeCollector.class, AntNativeCollector.class, SbtNativeCollector.class);
    private final ImmutableSet<NativeCollector> collectors;
    private final ImmutableMap<String, Object> scanAttributes;
    private final LogStream logStream;
    private final File projectRoot;
    private final Set<String> utilizedCollectors = new HashSet<String>();
    private final Set<Pattern> ignoredFolders = new HashSet<Pattern>();
    private final Map<NativeCollector, Set<Path>> collectorMap = new HashMap<NativeCollector, Set<Path>>();

    @Nullable
    protected static Path searchUpstream(Path currentPath, Set<Path> allPaths) {
        for (Path previousPath : allPaths) {
            if (previousPath.equals(currentPath) || !currentPath.toString().startsWith(previousPath.toString())) continue;
            return previousPath;
        }
        return null;
    }

    public RecursiveEngine(File projectRoot, ImmutableSet<NativeCollector> collectors, LogStream logStream, ImmutableMap<String, Object> scanAttributes) {
        this.collectors = collectors;
        this.scanAttributes = scanAttributes;
        this.logStream = logStream;
        this.projectRoot = projectRoot;
        ImmutableSet<String> attrIgnoredFolders = (ImmutableSet<String>)scanAttributes.get((Object)"IGNORE_FOLDERS");
        if (attrIgnoredFolders == null) {
            LOGGER.debug("Using default ignored folders");
            attrIgnoredFolders = DEFAULT_IGNORED_FOLDERS;
        }
        for (String str : attrIgnoredFolders) {
            this.ignoredFolders.add(Pattern.compile(".*" + str + "$"));
        }
    }

    @Override
    public String getName() {
        return "Recursive Native Engine";
    }

    @Override
    public CollectionResult collect() throws CollectionException {
        this.logStream.log("com.srcclr.evidence.files.collecting", Stage.EVIDENCE_COLLECTION, "Searching for supported projects (this may take a minute)...");
        CollectionResult.Builder resultBuilder = new CollectionResult.Builder().withScanAttributes(this.scanAttributes);
        LibraryGraphContainer.Builder graphBuilder = new LibraryGraphContainer.Builder();
        boolean isMethodsSupported = false;
        AgentRuntimeData.Builder agentRuntimeDataBuilder = new AgentRuntimeData.Builder();
        try {
            this.scanTree();
        }
        catch (IOException ex) {
            LOGGER.debug("Couldn't walk the project", (Throwable)ex);
            throw new CollectionException(CollectionErrorType.IO, "Couldn't walk the project: " + ex.getMessage()).withScanAttributes(this.scanAttributes);
        }
        for (Map.Entry<NativeCollector, Set<Path>> entry : this.collectorMap.entrySet()) {
            NativeCollector collector = entry.getKey();
            for (Path path : entry.getValue()) {
                Path upstream = RecursiveEngine.searchUpstream(path, entry.getValue());
                if (SINGLE_LEVEL_COLLECTORS.contains(collector.getClass()) && upstream != null) {
                    LOGGER.debug("Ignoring {}, as it appears to be a submodule of {}", (Object)path, (Object)upstream);
                    continue;
                }
                if (!collector.systemIsReady(path.toFile())) {
                    this.logStream.log("com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION, this.formatMessage(collector, "Build environment is not setup, skipping"));
                    continue;
                }
                if (!collector.supports(path.toFile())) continue;
                try {
                    this.logStream.log("com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION, this.formatMessage(collector, "Scanning " + path.toString()));
                    LibraryGraphContainer graphs = collector.collect(path.toFile());
                    graphBuilder.withGraphs(this.rewriteGraphs(this.projectRoot.toPath(), path, graphs.getGraphs()));
                    isMethodsSupported |= collector.isMethodsSupported(path.toFile());
                    this.utilizedCollectors.add(collector.getName());
                }
                catch (Exception ex) {
                    this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, this.formatMessage(collector, String.format("Couldn't scan %s, skipping.  See the logs for details", path.toString())));
                }
                agentRuntimeDataBuilder.addCollectorsRun(collector.getCollectorData());
            }
        }
        return resultBuilder.withGraphs(graphBuilder.build()).withMethodsSupported(isMethodsSupported).withAgentRuntimeData(agentRuntimeDataBuilder.build()).withScanAttributes(this.scanAttributes).build();
    }

    @Override
    public List<String> getCollectorsList() {
        return new ArrayList<String>(this.utilizedCollectors);
    }

    protected Map<NativeCollector, Set<Path>> getCollectorMap() {
        return this.collectorMap;
    }

    protected void scanTree() throws IOException {
        Files.walkFileTree(this.projectRoot.toPath(), new HashSet<FileVisitOption>(), this.parseMaxDepth(), new RecursiveFileVisitor());
    }

    protected ImmutableMap<String, Object> getScanAttributes() {
        return this.scanAttributes;
    }

    protected boolean ignoreFolder(String filePath) {
        for (Pattern p : this.ignoredFolders) {
            if (!p.matcher(filePath).matches()) continue;
            LOGGER.debug("Ignoring " + filePath);
            return true;
        }
        return false;
    }

    protected int parseMaxDepth() {
        String maxDepStr;
        int maxDepth = 10;
        Object obj = this.scanAttributes.get((Object)"MAX_DEPTH");
        if (obj == null) {
            obj = 10;
        }
        if (!(maxDepStr = Strings.nullToEmpty((String)obj.toString())).isEmpty()) {
            try {
                maxDepth = Integer.parseInt(maxDepStr);
                if (maxDepth < 1) {
                    this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, String.format("Bad maxDepth value (%s), ignoring...", maxDepStr));
                    maxDepth = 10;
                }
            }
            catch (NumberFormatException ex) {
                this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, String.format("Bad maxDepth value (%s), ignoring...", maxDepStr));
            }
        }
        return maxDepth;
    }

    private String formatMessage(NativeCollector collector, String message) {
        String title = String.format("[%s]", collector.getName());
        return String.format("%s%s", Strings.padEnd((String)title, (int)15, (char)' '), message);
    }

    private Set<LibraryGraph> rewriteGraphs(Path originalRoot, Path currentRoot, Set<LibraryGraph> graphs) {
        if (graphs == null) {
            return null;
        }
        if (graphs.isEmpty()) {
            return graphs;
        }
        HashSet<LibraryGraph> set = new HashSet<LibraryGraph>();
        for (LibraryGraph graph : graphs) {
            set.add(this.rewriteGraph(originalRoot, currentRoot, graph));
        }
        return set;
    }

    private LibraryGraph rewriteGraph(Path originalRoot, Path currentRoot, LibraryGraph graph) {
        if (graph == null) {
            return null;
        }
        String rewrittenPath = null;
        if (graph.getFilename() != null) {
            Path filePath = Paths.get(graph.getFilename(), new String[0]);
            Path fullPath = currentRoot.resolve(filePath);
            rewrittenPath = originalRoot.relativize(fullPath).toString();
        }
        return new LibraryGraph.Builder().withCoords(graph.getCoords()).withBytecodeHash(graph.getBytecodeHash()).withDirects(this.rewriteGraphs(originalRoot, currentRoot, graph.getDirects())).withLineNumber(graph.getLineNumber()).withModuleName(graph.getModuleName()).withSha1(graph.getSha1()).withSha2(graph.getSha2()).withFilename(rewrittenPath).build();
    }

    private class RecursiveFileVisitor
    extends SimpleFileVisitor<Path> {
        private RecursiveFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path folder, BasicFileAttributes attrs) {
            return RecursiveEngine.this.ignoreFolder(folder.toString()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
            for (NativeCollector c : RecursiveEngine.this.collectors) {
                for (Pattern p : c.patternsOfInterest()) {
                    if (!p.matcher(path.getFileName().toString()).matches()) continue;
                    this.addFolderToCollector(path, c);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private void addFolderToCollector(Path path, NativeCollector collector) {
            LinkedHashSet<Path> paths = (LinkedHashSet<Path>)RecursiveEngine.this.collectorMap.get(collector);
            if (paths == null) {
                paths = new LinkedHashSet<Path>();
                RecursiveEngine.this.collectorMap.put(collector, paths);
            }
            paths.add(path.getParent());
        }
    }
}

