/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.CollectionResult;
import com.sourceclear.engine.component.ComponentEngine;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.collectors.StubNativeCollector;
import com.sourceclear.engine.component.linecount.LineCounter;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeLocalEngine
implements ComponentEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLocalEngine.class);
    private final ImmutableSet<NativeCollector> collectors;
    private final ImmutableMap<String, Object> scanAttributes;
    private final LogStream logStream;
    private final File projectRoot;

    NativeLocalEngine(File projectRoot, ImmutableSet<NativeCollector> collectors, LogStream logStream, ImmutableMap<String, Object> scanAttributes) {
        this.projectRoot = projectRoot;
        this.collectors = collectors;
        this.logStream = logStream;
        this.scanAttributes = scanAttributes;
    }

    @Override
    public String getName() {
        return "Native Local Engine";
    }

    @Override
    public CollectionResult collect() throws CollectionException {
        CollectionResult.Builder resultBuilder = new CollectionResult.Builder().withScanAttributes(this.scanAttributes);
        LibraryGraphContainer.Builder graphBuilder = new LibraryGraphContainer.Builder();
        boolean isMethodsSupported = false;
        AgentRuntimeData.Builder agentRuntimeDataBuilder = new AgentRuntimeData.Builder();
        for (NativeCollector collector : this.collectors) {
            if (!collector.supports(this.projectRoot)) continue;
            if (collector instanceof StubNativeCollector) {
                agentRuntimeDataBuilder.addUnsupportedBuildSystems(collector.getCollectorData());
                continue;
            }
            this.logStream.log("com.srcclr.evidence.start", Stage.EVIDENCE_COLLECTION, "Running the " + collector.getName() + " scanner");
            LOGGER.debug("Collector \"{}\" started", (Object)collector.getName());
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                graphBuilder.withGraphs((Collection)collector.collect(this.projectRoot).getGraphs());
            }
            catch (CollectionException ce) {
                agentRuntimeDataBuilder.addCollectorsRun(collector.getCollectorData());
                ce.withAgentRuntimeData(agentRuntimeDataBuilder.build()).withScanAttributes(this.scanAttributes);
                throw ce;
            }
            isMethodsSupported = isMethodsSupported || collector.isMethodsSupported(this.projectRoot);
            agentRuntimeDataBuilder.addCollectorsRun(collector.getCollectorData());
            LOGGER.debug("Collector \"{}\" completed in {}.{}s", new Object[]{collector.getName(), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS) / 100L % 10L});
        }
        resultBuilder.withMethodsSupported(isMethodsSupported);
        resultBuilder.withGraphs(graphBuilder.build());
        resultBuilder.withAgentRuntimeData(agentRuntimeDataBuilder.build());
        this.logStream.log("com.srcclr.evidence.end", Stage.EVIDENCE_COLLECTION, "Scanning completed");
        CollectionResult collectionResult = resultBuilder.build();
        if (!collectionResult.getEvidence().isEmpty()) {
            try {
                LOGGER.debug("Begin counting lines of code");
                long loc = LineCounter.countLOC(this.projectRoot, this.buildClient());
                resultBuilder.withLineCount(loc);
                LOGGER.debug("Done counting lines of code");
                this.logStream.log("com.srcclr.evidence.line.counting.report", Stage.LINE_COUNTING, String.format("Found %d lines of code", loc));
                collectionResult = resultBuilder.build();
            }
            catch (Exception ex) {
                this.logStream.log("com.srcclr.evidence.line.counting.issue", Stage.LINE_COUNTING, "Couldn't count lines of code: " + ex.getMessage());
                LOGGER.info("Couldn't count lines of code", (Throwable)ex);
            }
        } else {
            LOGGER.debug("No evidence found hence not counting lines of code.");
            List<CollectionResult.Advice> advice = this.collectors.stream().filter(c -> c.supports(this.projectRoot)).map(NativeCollector::adviseOnFailure).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            collectionResult = resultBuilder.withAdvice(advice).build();
        }
        return collectionResult;
    }

    @Override
    public List<String> getCollectorsList() {
        ArrayList<String> collectorsList = new ArrayList<String>(this.collectors.size());
        for (NativeCollector nc : this.collectors) {
            if (nc instanceof StubNativeCollector) continue;
            collectorsList.add(nc.getName());
        }
        return collectorsList;
    }

    @VisibleForTesting
    ImmutableMap<String, Object> getScanAttributes() {
        return ImmutableMap.copyOf(this.scanAttributes);
    }

    private Client buildClient() {
        SourceClearClient.Builder builder = new SourceClearClient.Builder().withExpBackOffInitial(0);
        URI apiBase = (URI)this.scanAttributes.get((Object)"API_BASE_URI");
        if (apiBase != null) {
            builder.withBaseURI(apiBase);
        }
        return builder.build();
    }
}

