/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.base.Joiner;
import com.sourceclear.engine.common.ProcessNonZeroRCException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);

    public static String launchProcess(@Nonnull File workingDirectory, @Nonnull List<String> command) throws IOException, InterruptedException, ProcessNonZeroRCException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(workingDirectory);
        String commandString = Joiner.on((String)" ").join(command);
        LOGGER.debug("Launching process with command: {}", (Object)commandString);
        Process process = processBuilder.start();
        try (OutputStream outputStream2 = process.getOutputStream();){
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException outputStream2) {
            // empty catch block
        }
        String output = "";
        try (InputStream inputStream = process.getInputStream();){
            output = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        int rc = process.waitFor();
        if (rc != 0) {
            LOGGER.debug("Process exited with non-zero rc: {}", (Object)rc);
            throw new ProcessNonZeroRCException(String.format("Process '%s' exited with non-zero rc.", commandString), output, rc);
        }
        return output;
    }
}

