/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.sourceclear.engine.common.StoredFileVisitor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import org.slf4j.Logger;

public class FileTypeVisitor
extends StoredFileVisitor {
    protected final Set<String> extensions;
    private final Set<String> ignoredDirectories;
    private final Logger logger;

    public FileTypeVisitor(Set<String> extensions, Set<String> ignoredDirectories, Logger logger) {
        this.extensions = extensions;
        this.ignoredDirectories = ignoredDirectories;
        this.logger = logger;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return this.ignoredDirectories.contains(dir.getFileName().toString()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        for (String extension : this.extensions) {
            if (!file.getFileName().toString().endsWith(extension)) continue;
            this.files.add(file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException ex) throws IOException {
        this.logger.info("Couldn't visit file: " + file.toString(), (Throwable)ex);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public Set<String> getFileTypesLookedFor() {
        return this.extensions;
    }
}

