/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.sourceclear.bytecode.ClassDiffInfo;
import com.sourceclear.bytecode.ClassFingerprint;
import com.sourceclear.bytecode.CompClassRemapper;
import com.sourceclear.bytecode.CompClassVisitor;
import com.sourceclear.bytecode.CompDiffInfo;
import com.sourceclear.bytecode.MethodDiffInfo;
import com.sourceclear.bytecode.MethodFingerprint;
import com.sourceclear.bytecode.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompFingerprint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CompFingerprint.class.getName());
    private Map<String, ClassFingerprint> classMap = Maps.newHashMap();

    public CompFingerprint() {
        this(new HashMap<String, ClassFingerprint>());
    }

    public CompFingerprint(Map<String, ClassFingerprint> classMap) {
        this.classMap = classMap;
    }

    public void read(InputStream is) throws IOException {
        JarInputStream jis = new JarInputStream(is);
        for (Map.Entry<JarEntry, InputStream> entry : this.readEntries(jis).entrySet()) {
            CompClassVisitor ccv;
            HashSet<String> imports = new HashSet<String>();
            HashSet<String> calledMethods = new HashSet<String>();
            HashSet<String> algorithmsSet = new HashSet<String>();
            HashSet<String> methodsSet = new HashSet<String>();
            HashSet<String> fieldsSet = new HashSet<String>();
            HashMap<String, List<Integer>> methodsMap = new HashMap<String, List<Integer>>();
            CompClassRemapper entryCCR = new CompClassRemapper(imports);
            try (InputStream stream = entry.getValue();){
                ClassReader entryCR = new ClassReader(stream);
                ccv = new CompClassVisitor("", fieldsSet, methodsSet, methodsMap, calledMethods, algorithmsSet, 327680);
                RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)ccv, (Remapper)entryCCR);
                entryCR.accept((ClassVisitor)cv, 8);
            }
            catch (RuntimeException exception) {
                throw new IOException("Error reading bytecode", exception);
            }
            ClassFingerprint classSig = new ClassFingerprint(Util.immutableMapConstruct(methodsMap), (ImmutableSet<String>)ImmutableSet.copyOf(fieldsSet), (ImmutableSet<String>)ImmutableSet.copyOf(calledMethods), (ImmutableSet<String>)ImmutableSet.copyOf(imports), (ImmutableSet<String>)ImmutableSet.copyOf(algorithmsSet));
            this.classMap.put(ccv.getClassName(), classSig);
        }
    }

    public void readSetOfClasses(Set<byte[]> classSet) throws IOException {
        for (byte[] barr : classSet) {
            ByteArrayInputStream is = new ByteArrayInputStream(barr);
            HashSet<String> imports = new HashSet<String>();
            HashSet<String> calledMethods = new HashSet<String>();
            HashSet<String> algorithmsSet = new HashSet<String>();
            HashSet<String> methodsSet = new HashSet<String>();
            HashSet<String> fieldsSet = new HashSet<String>();
            HashMap<String, List<Integer>> methodsMap = new HashMap<String, List<Integer>>();
            CompClassRemapper entryCCR = new CompClassRemapper(imports);
            ClassReader entryCR = new ClassReader((InputStream)is);
            CompClassVisitor ccv = new CompClassVisitor("", fieldsSet, methodsSet, methodsMap, calledMethods, algorithmsSet, 327680);
            RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)ccv, (Remapper)entryCCR);
            entryCR.accept((ClassVisitor)cv, 8);
            ClassFingerprint classSig = new ClassFingerprint(Util.immutableMapConstruct(methodsMap), (ImmutableSet<String>)ImmutableSet.copyOf(fieldsSet), (ImmutableSet<String>)ImmutableSet.copyOf(calledMethods), (ImmutableSet<String>)ImmutableSet.copyOf(imports), (ImmutableSet<String>)ImmutableSet.copyOf(algorithmsSet));
            this.classMap.put(ccv.getClassName(), classSig);
        }
    }

    public ByteArrayOutputStream serializeClassMap() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this.classMap);
        }
        return baos;
    }

    public void deserializeClassMap(InputStream is) throws IOException {
        try (ObjectInputStream ois = new ObjectInputStream(is);){
            this.classMap = (Map)ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error("Class not found" + ex.getMessage());
        }
    }

    public CompDiffInfo diff(Map<String, ClassFingerprint> othersig) {
        ImmutableList.Builder classesAdded = new ImmutableList.Builder();
        ImmutableMap.Builder classesModified = new ImmutableMap.Builder();
        for (String otherclass : othersig.keySet()) {
            if (!this.classMap.containsKey(otherclass)) {
                classesAdded.add((Object)otherclass);
                continue;
            }
            ClassDiffInfo classdiff = this.classMap.get(otherclass).diffClass(othersig.get(otherclass));
            if (classdiff.getFieldsAdded().isEmpty() && classdiff.getFieldsRemoved().isEmpty() && classdiff.getMethodsAdded().isEmpty() && classdiff.getMethodsRemoved().isEmpty()) continue;
            classesModified.put((Object)otherclass, (Object)classdiff);
        }
        ImmutableList classesRemoved = Util.addedItems(ImmutableSet.copyOf(othersig.keySet()), ImmutableSet.copyOf(this.classMap.keySet()));
        return new CompDiffInfo((ImmutableList<String>)classesAdded.build(), classesRemoved, (ImmutableMap<String, ClassDiffInfo>)classesModified.build());
    }

    public boolean isSimilar(CompDiffInfo jdf, double classSim, double methodSim, double fieldSim, double insnSim) {
        int numofClasses = this.classMap.size() + jdf.getClassesAdded().size();
        if (numofClasses == 0) {
            return false;
        }
        double classesSame = 1.0 - (double)(jdf.getClassesAdded().size() + jdf.getClassesRemoved().size()) / (double)numofClasses;
        if (classesSame >= classSim) {
            for (String modifiedClass : jdf.getClassesModified().keySet()) {
                ClassDiffInfo di = (ClassDiffInfo)jdf.getClassesModified().get((Object)modifiedClass);
                int numofMethods = this.classMap.get(modifiedClass).getMethodsMap().size() + di.getMethodsAdded().size();
                if (numofMethods == 0) continue;
                double methodsSame = 1.0 - (double)(di.getMethodsAdded().size() + di.getMethodsRemoved().size()) / (double)numofMethods;
                int numofFields = this.classMap.get(modifiedClass).getFieldsSet().size() + di.getFieldsAdded().size();
                if (numofFields == 0) continue;
                double fieldsSame = 1.0 - (double)(di.getFieldsAdded().size() + di.getFieldsRemoved().size()) / (double)numofFields;
                if (methodsSame >= methodSim && fieldsSame >= fieldSim) {
                    for (String modifiedMethod : di.getChangedMethods().keySet()) {
                        double insnSame;
                        MethodDiffInfo mdi = (MethodDiffInfo)di.getChangedMethods().get((Object)modifiedMethod);
                        int numofInsn = ((MethodFingerprint)this.classMap.get(modifiedClass).getMethodsMap().get((Object)modifiedMethod)).getOpCodes().size() + mdi.getInsnAdded().size();
                        if (numofInsn == 0 || (insnSame = 1.0 - (double)(mdi.getInsnAdded().size() + mdi.getInsnRemoved().size()) / (double)numofInsn) >= insnSim) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public double getSimilarity(CompDiffInfo jdf) {
        if (jdf.isEmpty() && this.classMap.isEmpty()) {
            return 0.0;
        }
        int numofClasses = this.classMap.size() + jdf.getClassesAdded().size();
        double simMeasure = 1.0;
        double classSim = 1.0 - (double)(jdf.getClassesAdded().size() + jdf.getClassesRemoved().size()) / (double)numofClasses;
        double methodSim = 1.0;
        double fieldSim = 1.0;
        double insnSim = 1.0;
        if (numofClasses == 0) {
            return simMeasure;
        }
        UnmodifiableIterator it = jdf.getClassesModified().keySet().iterator();
        if (!it.hasNext()) {
            methodSim = classSim;
            fieldSim = classSim;
            insnSim = classSim;
        }
        while (it.hasNext()) {
            String modifiedClass = (String)it.next();
            ClassDiffInfo di = (ClassDiffInfo)jdf.getClassesModified().get((Object)modifiedClass);
            int numofMethods = this.classMap.get(modifiedClass).getMethodsMap().size() + di.getMethodsAdded().size();
            if (numofMethods == 0) continue;
            double methodsSame = 1.0 - (double)(di.getMethodsAdded().size() + di.getMethodsRemoved().size()) / (double)numofMethods;
            methodSim = (methodSim + methodsSame) / 2.0;
            int numofFields = this.classMap.get(modifiedClass).getFieldsSet().size() + di.getFieldsAdded().size();
            if (numofFields == 0) continue;
            double fieldsSame = 1.0 - (double)(di.getFieldsAdded().size() + di.getFieldsRemoved().size()) / (double)numofFields;
            fieldSim = (fieldSim + fieldsSame) / 2.0;
            if (di.getChangedMethods().isEmpty()) {
                insnSim = (0.0 + insnSim) / 2.0;
            }
            for (String modifiedMethod : di.getChangedMethods().keySet()) {
                MethodDiffInfo mdi = (MethodDiffInfo)di.getChangedMethods().get((Object)modifiedMethod);
                int numofInsn = ((MethodFingerprint)this.classMap.get(modifiedClass).getMethodsMap().get((Object)modifiedMethod)).getOpCodes().size() + mdi.getInsnAdded().size();
                if (numofInsn == 0) continue;
                double insnSame = 1.0 - (double)(mdi.getInsnAdded().size() + mdi.getInsnRemoved().size()) / (double)numofInsn;
                insnSim = (insnSim + insnSame) / 2.0;
            }
        }
        simMeasure = (classSim + 0.1 * methodSim + 0.1 * fieldSim + 0.01 * insnSim) / 1.21;
        return (double)Math.round(simMeasure * 100.0) / 100.0;
    }

    private Map<JarEntry, InputStream> readEntries(JarInputStream jis) throws IOException {
        JarEntry jarEntry;
        HashMap map = Maps.newHashMap();
        while ((jarEntry = jis.getNextJarEntry()) != null) {
            if (jarEntry.isDirectory() || !jarEntry.getName().toLowerCase().endsWith(".class")) {
                jis.closeEntry();
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)jis, (OutputStream)baos);
            jis.closeEntry();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            map.put(jarEntry, bais);
        }
        return map;
    }

    public Map<String, ClassFingerprint> getClassMap() {
        return this.classMap;
    }
}

