/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.UserModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class UserModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private long id;
    private String name = null;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    UserModel_Builder() {
    }

    public static UserModel.Builder from(UserModel value) {
        return new UserModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public UserModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (UserModel.Builder)this;
    }

    public UserModel.Builder mapId(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setId((Long)mapper.apply(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    public UserModel.Builder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        return (UserModel.Builder)this;
    }

    @JsonProperty(value="name")
    public UserModel.Builder setName(Optional<? extends String> name) {
        if (name.isPresent()) {
            return this.setName(name.get());
        }
        return this.clearName();
    }

    public UserModel.Builder setNullableName(@Nullable String name) {
        if (name != null) {
            return this.setName(name);
        }
        return this.clearName();
    }

    public UserModel.Builder mapName(UnaryOperator<String> mapper) {
        return this.setName(this.getName().map(mapper));
    }

    public UserModel.Builder clearName() {
        this.name = null;
        return (UserModel.Builder)this;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public UserModel.Builder mergeFrom(UserModel value) {
        UserModel.Builder _defaults = new UserModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.ID) || !Objects.equals(value.getId(), ((UserModel_Builder)_defaults).getId())) {
            this.setId(value.getId());
        }
        value.getName().ifPresent(this::setName);
        return (UserModel.Builder)this;
    }

    public UserModel.Builder mergeFrom(UserModel.Builder template) {
        UserModel.Builder base = template;
        UserModel.Builder _defaults = new UserModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.ID) || !_defaults._unsetProperties.contains((Object)Property.ID) && Objects.equals(template.getId(), ((UserModel_Builder)_defaults).getId()))) {
            this.setId(template.getId());
        }
        template.getName().ifPresent(this::setName);
        return (UserModel.Builder)this;
    }

    public UserModel.Builder clear() {
        UserModel.Builder _defaults = new UserModel.Builder();
        this.id = _defaults.id;
        this.name = _defaults.name;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (UserModel.Builder)this;
    }

    public UserModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public UserModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements UserModel {
        private final long id;
        private final String name;
        private final EnumSet<Property> _unsetProperties;

        Partial(UserModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this._unsetProperties);
        }

        public String toString() {
            return "partial UserModel{" + COMMA_JOINER.join(!this._unsetProperties.contains((Object)Property.ID) ? "id=" + this.id : null, this.name != null ? "name=" + this.name : null, new Object[0]) + "}";
        }
    }

    private static final class Value
    implements UserModel {
        private final long id;
        private final String name;

        private Value(UserModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "UserModel{" + COMMA_JOINER.join((Object)("id=" + this.id), this.name != null ? "name=" + this.name : null, new Object[0]) + "}";
        }
    }

    private static enum Property {
        ID("id");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

