/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.diff.IssueLibraryDependencyMode;
import com.sourceclear.api.data.diff.LibraryResourceModel;
import com.sourceclear.api.data.evidence.CoordinateType;
import com.sourceclear.api.data.evidence.LanguageType;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class LibraryResourceModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private String name;
    private String version;
    @Nullable
    private String commitHash = null;
    private String instanceRef;
    private LanguageType languageType;
    private CoordinateType coordinateType;
    private String coord1;
    private String coord2;
    private IssueLibraryDependencyMode dependencyMode;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    LibraryResourceModel_Builder() {
    }

    public static LibraryResourceModel.Builder from(LibraryResourceModel value) {
        return new LibraryResourceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="name")
    public LibraryResourceModel.Builder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapName(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    @JsonProperty(value="version")
    public LibraryResourceModel.Builder setVersion(String version) {
        this.version = (String)Preconditions.checkNotNull((Object)version);
        this._unsetProperties.remove((Object)Property.VERSION);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapVersion(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setVersion((String)mapper.apply(this.getVersion()));
    }

    public String getVersion() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VERSION) ? 1 : 0) != 0, (Object)"version not set");
        return this.version;
    }

    @JsonProperty(value="commitHash")
    public LibraryResourceModel.Builder setCommitHash(@Nullable String commitHash) {
        this.commitHash = commitHash;
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapCommitHash(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        String commitHash = this.getCommitHash();
        if (commitHash != null) {
            this.setCommitHash((String)mapper.apply(commitHash));
        }
        return (LibraryResourceModel.Builder)this;
    }

    @Nullable
    public String getCommitHash() {
        return this.commitHash;
    }

    @JsonProperty(value="instanceRef")
    public LibraryResourceModel.Builder setInstanceRef(String instanceRef) {
        this.instanceRef = (String)Preconditions.checkNotNull((Object)instanceRef);
        this._unsetProperties.remove((Object)Property.INSTANCE_REF);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapInstanceRef(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setInstanceRef((String)mapper.apply(this.getInstanceRef()));
    }

    public String getInstanceRef() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.INSTANCE_REF) ? 1 : 0) != 0, (Object)"instanceRef not set");
        return this.instanceRef;
    }

    @JsonProperty(value="languageType")
    public LibraryResourceModel.Builder setLanguageType(LanguageType languageType) {
        this.languageType = (LanguageType)Preconditions.checkNotNull((Object)languageType);
        this._unsetProperties.remove((Object)Property.LANGUAGE_TYPE);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapLanguageType(UnaryOperator<LanguageType> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setLanguageType((LanguageType)mapper.apply(this.getLanguageType()));
    }

    public LanguageType getLanguageType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LANGUAGE_TYPE) ? 1 : 0) != 0, (Object)"languageType not set");
        return this.languageType;
    }

    @JsonProperty(value="coordinateType")
    public LibraryResourceModel.Builder setCoordinateType(CoordinateType coordinateType) {
        this.coordinateType = (CoordinateType)((Object)Preconditions.checkNotNull((Object)((Object)coordinateType)));
        this._unsetProperties.remove((Object)Property.COORDINATE_TYPE);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapCoordinateType(UnaryOperator<CoordinateType> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setCoordinateType((CoordinateType)((Object)mapper.apply(this.getCoordinateType())));
    }

    public CoordinateType getCoordinateType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.COORDINATE_TYPE) ? 1 : 0) != 0, (Object)"coordinateType not set");
        return this.coordinateType;
    }

    @JsonProperty(value="coord1")
    public LibraryResourceModel.Builder setCoord1(String coord1) {
        this.coord1 = (String)Preconditions.checkNotNull((Object)coord1);
        this._unsetProperties.remove((Object)Property.COORD1);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapCoord1(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setCoord1((String)mapper.apply(this.getCoord1()));
    }

    public String getCoord1() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.COORD1) ? 1 : 0) != 0, (Object)"coord1 not set");
        return this.coord1;
    }

    @JsonProperty(value="coord2")
    public LibraryResourceModel.Builder setCoord2(String coord2) {
        this.coord2 = (String)Preconditions.checkNotNull((Object)coord2);
        this._unsetProperties.remove((Object)Property.COORD2);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapCoord2(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setCoord2((String)mapper.apply(this.getCoord2()));
    }

    public String getCoord2() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.COORD2) ? 1 : 0) != 0, (Object)"coord2 not set");
        return this.coord2;
    }

    @JsonProperty(value="dependencyMode")
    public LibraryResourceModel.Builder setDependencyMode(IssueLibraryDependencyMode dependencyMode) {
        this.dependencyMode = (IssueLibraryDependencyMode)((Object)Preconditions.checkNotNull((Object)((Object)dependencyMode)));
        this._unsetProperties.remove((Object)Property.DEPENDENCY_MODE);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mapDependencyMode(UnaryOperator<IssueLibraryDependencyMode> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setDependencyMode((IssueLibraryDependencyMode)((Object)mapper.apply(this.getDependencyMode())));
    }

    public IssueLibraryDependencyMode getDependencyMode() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? 1 : 0) != 0, (Object)"dependencyMode not set");
        return this.dependencyMode;
    }

    public LibraryResourceModel.Builder mergeFrom(LibraryResourceModel value) {
        LibraryResourceModel.Builder _defaults = new LibraryResourceModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((LibraryResourceModel_Builder)_defaults).getName())) {
            this.setName(value.getName());
        }
        if (_defaults._unsetProperties.contains((Object)Property.VERSION) || !Objects.equals(value.getVersion(), ((LibraryResourceModel_Builder)_defaults).getVersion())) {
            this.setVersion(value.getVersion());
        }
        if (!Objects.equals(value.getCommitHash(), ((LibraryResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(value.getCommitHash());
        }
        if (_defaults._unsetProperties.contains((Object)Property.INSTANCE_REF) || !Objects.equals(value.getInstanceRef(), ((LibraryResourceModel_Builder)_defaults).getInstanceRef())) {
            this.setInstanceRef(value.getInstanceRef());
        }
        if (_defaults._unsetProperties.contains((Object)Property.LANGUAGE_TYPE) || !Objects.equals(value.getLanguageType(), ((LibraryResourceModel_Builder)_defaults).getLanguageType())) {
            this.setLanguageType(value.getLanguageType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.COORDINATE_TYPE) || !Objects.equals((Object)value.getCoordinateType(), (Object)((LibraryResourceModel_Builder)_defaults).getCoordinateType())) {
            this.setCoordinateType(value.getCoordinateType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.COORD1) || !Objects.equals(value.getCoord1(), ((LibraryResourceModel_Builder)_defaults).getCoord1())) {
            this.setCoord1(value.getCoord1());
        }
        if (_defaults._unsetProperties.contains((Object)Property.COORD2) || !Objects.equals(value.getCoord2(), ((LibraryResourceModel_Builder)_defaults).getCoord2())) {
            this.setCoord2(value.getCoord2());
        }
        if (_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !Objects.equals((Object)value.getDependencyMode(), (Object)((LibraryResourceModel_Builder)_defaults).getDependencyMode())) {
            this.setDependencyMode(value.getDependencyMode());
        }
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder mergeFrom(LibraryResourceModel.Builder template) {
        LibraryResourceModel.Builder base = template;
        LibraryResourceModel.Builder _defaults = new LibraryResourceModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !_defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((LibraryResourceModel_Builder)_defaults).getName()))) {
            this.setName(template.getName());
        }
        if (!(base._unsetProperties.contains((Object)Property.VERSION) || !_defaults._unsetProperties.contains((Object)Property.VERSION) && Objects.equals(template.getVersion(), ((LibraryResourceModel_Builder)_defaults).getVersion()))) {
            this.setVersion(template.getVersion());
        }
        if (!Objects.equals(template.getCommitHash(), ((LibraryResourceModel_Builder)_defaults).getCommitHash())) {
            this.setCommitHash(template.getCommitHash());
        }
        if (!(base._unsetProperties.contains((Object)Property.INSTANCE_REF) || !_defaults._unsetProperties.contains((Object)Property.INSTANCE_REF) && Objects.equals(template.getInstanceRef(), ((LibraryResourceModel_Builder)_defaults).getInstanceRef()))) {
            this.setInstanceRef(template.getInstanceRef());
        }
        if (!(base._unsetProperties.contains((Object)Property.LANGUAGE_TYPE) || !_defaults._unsetProperties.contains((Object)Property.LANGUAGE_TYPE) && Objects.equals(template.getLanguageType(), ((LibraryResourceModel_Builder)_defaults).getLanguageType()))) {
            this.setLanguageType(template.getLanguageType());
        }
        if (!(base._unsetProperties.contains((Object)Property.COORDINATE_TYPE) || !_defaults._unsetProperties.contains((Object)Property.COORDINATE_TYPE) && Objects.equals((Object)template.getCoordinateType(), (Object)((LibraryResourceModel_Builder)_defaults).getCoordinateType()))) {
            this.setCoordinateType(template.getCoordinateType());
        }
        if (!(base._unsetProperties.contains((Object)Property.COORD1) || !_defaults._unsetProperties.contains((Object)Property.COORD1) && Objects.equals(template.getCoord1(), ((LibraryResourceModel_Builder)_defaults).getCoord1()))) {
            this.setCoord1(template.getCoord1());
        }
        if (!(base._unsetProperties.contains((Object)Property.COORD2) || !_defaults._unsetProperties.contains((Object)Property.COORD2) && Objects.equals(template.getCoord2(), ((LibraryResourceModel_Builder)_defaults).getCoord2()))) {
            this.setCoord2(template.getCoord2());
        }
        if (!(base._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) && Objects.equals((Object)template.getDependencyMode(), (Object)((LibraryResourceModel_Builder)_defaults).getDependencyMode()))) {
            this.setDependencyMode(template.getDependencyMode());
        }
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel.Builder clear() {
        LibraryResourceModel.Builder _defaults = new LibraryResourceModel.Builder();
        this.name = _defaults.name;
        this.version = _defaults.version;
        this.commitHash = _defaults.commitHash;
        this.instanceRef = _defaults.instanceRef;
        this.languageType = _defaults.languageType;
        this.coordinateType = _defaults.coordinateType;
        this.coord1 = _defaults.coord1;
        this.coord2 = _defaults.coord2;
        this.dependencyMode = _defaults.dependencyMode;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (LibraryResourceModel.Builder)this;
    }

    public LibraryResourceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public LibraryResourceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements LibraryResourceModel {
        private final String name;
        private final String version;
        @Nullable
        private final String commitHash;
        private final String instanceRef;
        private final LanguageType languageType;
        private final CoordinateType coordinateType;
        private final String coord1;
        private final String coord2;
        private final IssueLibraryDependencyMode dependencyMode;
        private final EnumSet<Property> _unsetProperties;

        Partial(LibraryResourceModel_Builder builder) {
            this.name = builder.name;
            this.version = builder.version;
            this.commitHash = builder.commitHash;
            this.instanceRef = builder.instanceRef;
            this.languageType = builder.languageType;
            this.coordinateType = builder.coordinateType;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.dependencyMode = builder.dependencyMode;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        @JsonProperty(value="version")
        public String getVersion() {
            if (this._unsetProperties.contains((Object)Property.VERSION)) {
                throw new UnsupportedOperationException("version not set");
            }
            return this.version;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="instanceRef")
        public String getInstanceRef() {
            if (this._unsetProperties.contains((Object)Property.INSTANCE_REF)) {
                throw new UnsupportedOperationException("instanceRef not set");
            }
            return this.instanceRef;
        }

        @Override
        @JsonProperty(value="languageType")
        public LanguageType getLanguageType() {
            if (this._unsetProperties.contains((Object)Property.LANGUAGE_TYPE)) {
                throw new UnsupportedOperationException("languageType not set");
            }
            return this.languageType;
        }

        @Override
        @JsonProperty(value="coordinateType")
        public CoordinateType getCoordinateType() {
            if (this._unsetProperties.contains((Object)Property.COORDINATE_TYPE)) {
                throw new UnsupportedOperationException("coordinateType not set");
            }
            return this.coordinateType;
        }

        @Override
        @JsonProperty(value="coord1")
        public String getCoord1() {
            if (this._unsetProperties.contains((Object)Property.COORD1)) {
                throw new UnsupportedOperationException("coord1 not set");
            }
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        public String getCoord2() {
            if (this._unsetProperties.contains((Object)Property.COORD2)) {
                throw new UnsupportedOperationException("coord2 not set");
            }
            return this.coord2;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            if (this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE)) {
                throw new UnsupportedOperationException("dependencyMode not set");
            }
            return this.dependencyMode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals(this.instanceRef, other.instanceRef) && Objects.equals(this.languageType, other.languageType) && Objects.equals((Object)this.coordinateType, (Object)other.coordinateType) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.version, this.commitHash, this.instanceRef, this.languageType, this.coordinateType, this.coord1, this.coord2, this.dependencyMode, this._unsetProperties});
        }

        public String toString() {
            return "partial LibraryResourceModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.NAME) ? "name=" + this.name : null), (Object)(!this._unsetProperties.contains((Object)Property.VERSION) ? "version=" + this.version : null), new Object[]{this.commitHash != null ? "commitHash=" + this.commitHash : null, !this._unsetProperties.contains((Object)Property.INSTANCE_REF) ? "instanceRef=" + this.instanceRef : null, !this._unsetProperties.contains((Object)Property.LANGUAGE_TYPE) ? "languageType=" + this.languageType : null, !this._unsetProperties.contains((Object)Property.COORDINATE_TYPE) ? "coordinateType=" + (Object)((Object)this.coordinateType) : null, !this._unsetProperties.contains((Object)Property.COORD1) ? "coord1=" + this.coord1 : null, !this._unsetProperties.contains((Object)Property.COORD2) ? "coord2=" + this.coord2 : null, !this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? "dependencyMode=" + (Object)((Object)this.dependencyMode) : null}) + "}";
        }
    }

    private static final class Value
    implements LibraryResourceModel {
        private final String name;
        private final String version;
        @Nullable
        private final String commitHash;
        private final String instanceRef;
        private final LanguageType languageType;
        private final CoordinateType coordinateType;
        private final String coord1;
        private final String coord2;
        private final IssueLibraryDependencyMode dependencyMode;

        private Value(LibraryResourceModel_Builder builder) {
            this.name = builder.name;
            this.version = builder.version;
            this.commitHash = builder.commitHash;
            this.instanceRef = builder.instanceRef;
            this.languageType = builder.languageType;
            this.coordinateType = builder.coordinateType;
            this.coord1 = builder.coord1;
            this.coord2 = builder.coord2;
            this.dependencyMode = builder.dependencyMode;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @JsonProperty(value="version")
        public String getVersion() {
            return this.version;
        }

        @Override
        @JsonProperty(value="commitHash")
        @Nullable
        public String getCommitHash() {
            return this.commitHash;
        }

        @Override
        @JsonProperty(value="instanceRef")
        public String getInstanceRef() {
            return this.instanceRef;
        }

        @Override
        @JsonProperty(value="languageType")
        public LanguageType getLanguageType() {
            return this.languageType;
        }

        @Override
        @JsonProperty(value="coordinateType")
        public CoordinateType getCoordinateType() {
            return this.coordinateType;
        }

        @Override
        @JsonProperty(value="coord1")
        public String getCoord1() {
            return this.coord1;
        }

        @Override
        @JsonProperty(value="coord2")
        public String getCoord2() {
            return this.coord2;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            return this.dependencyMode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.commitHash, other.commitHash) && Objects.equals(this.instanceRef, other.instanceRef) && Objects.equals(this.languageType, other.languageType) && Objects.equals((Object)this.coordinateType, (Object)other.coordinateType) && Objects.equals(this.coord1, other.coord1) && Objects.equals(this.coord2, other.coord2) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.version, this.commitHash, this.instanceRef, this.languageType, this.coordinateType, this.coord1, this.coord2, this.dependencyMode});
        }

        public String toString() {
            return "LibraryResourceModel{" + COMMA_JOINER.join((Object)("name=" + this.name), (Object)("version=" + this.version), new Object[]{this.commitHash != null ? "commitHash=" + this.commitHash : null, "instanceRef=" + this.instanceRef, "languageType=" + this.languageType, "coordinateType=" + (Object)((Object)this.coordinateType), "coord1=" + this.coord1, "coord2=" + this.coord2, "dependencyMode=" + (Object)((Object)this.dependencyMode)}) + "}";
        }
    }

    private static enum Property {
        NAME("name"),
        VERSION("version"),
        INSTANCE_REF("instanceRef"),
        LANGUAGE_TYPE("languageType"),
        COORDINATE_TYPE("coordinateType"),
        COORD1("coord1"),
        COORD2("coord2"),
        DEPENDENCY_MODE("dependencyMode");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

