/*
 * Decompiled with CFR 0.152.
 */
package org.appspot.apprtc;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.appspot.apprtc.AppRTCBluetoothManager;
import org.appspot.apprtc.AppRTCProximitySensor;
import org.appspot.apprtc.util.AppRTCUtils;
import org.webrtc.ThreadUtils;

public class AppRTCAudioManager {
    private static final String TAG = "AppRTCAudioManager";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private final Context apprtcContext;
    @Nullable
    private AudioManager audioManager;
    @Nullable
    private AudioManagerEvents audioManagerEvents;
    private AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    private AudioDevice defaultAudioDevice;
    private AudioDevice selectedAudioDevice;
    private AudioDevice userSelectedAudioDevice;
    @Nullable
    private final String useSpeakerphone = "auto";
    @Nullable
    private AppRTCProximitySensor proximitySensor;
    private final AppRTCBluetoothManager bluetoothManager;
    private Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
    private BroadcastReceiver wiredHeadsetReceiver;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;

    private void onProximitySensorChangedState() {
        if (!SPEAKERPHONE_AUTO.equals(SPEAKERPHONE_AUTO)) {
            return;
        }
        if (this.audioDevices.size() == 2 && this.audioDevices.contains((Object)AudioDevice.EARPIECE) && this.audioDevices.contains((Object)AudioDevice.SPEAKER_PHONE)) {
            if (this.proximitySensor.sensorReportsNearState()) {
                this.setAudioDeviceInternal(AudioDevice.EARPIECE);
            } else {
                this.setAudioDeviceInternal(AudioDevice.SPEAKER_PHONE);
            }
        }
    }

    static AppRTCAudioManager create(Context context) {
        return new AppRTCAudioManager(context);
    }

    private AppRTCAudioManager(Context context) {
        Log.d((String)TAG, (String)"ctor");
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.bluetoothManager = AppRTCBluetoothManager.create(context, this);
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = AudioManagerState.UNINITIALIZED;
        this.defaultAudioDevice = SPEAKERPHONE_AUTO.equals(SPEAKERPHONE_FALSE) ? AudioDevice.EARPIECE : AudioDevice.SPEAKER_PHONE;
        this.proximitySensor = AppRTCProximitySensor.create(context, this::onProximitySensorChangedState);
        Log.d((String)TAG, (String)("defaultAudioDevice: " + (Object)((Object)this.defaultAudioDevice)));
        AppRTCUtils.logDeviceInfo(TAG);
    }

    public void start(AudioManagerEvents audioManagerEvents) {
        Log.d((String)TAG, (String)"start");
        ThreadUtils.checkIsOnMainThread();
        if (this.amState == AudioManagerState.RUNNING) {
            Log.e((String)TAG, (String)"AudioManager is already active");
            return;
        }
        Log.d((String)TAG, (String)"AudioManager starts...");
        this.audioManagerEvents = audioManagerEvents;
        this.amState = AudioManagerState.RUNNING;
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                String typeOfChange;
                switch (focusChange) {
                    case 1: {
                        typeOfChange = "AUDIOFOCUS_GAIN";
                        break;
                    }
                    case 2: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                        break;
                    }
                    case 4: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                        break;
                    }
                    case 3: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                        break;
                    }
                    case -1: {
                        typeOfChange = "AUDIOFOCUS_LOSS";
                        break;
                    }
                    case -2: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                        break;
                    }
                    case -3: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                        break;
                    }
                    default: {
                        typeOfChange = "AUDIOFOCUS_INVALID";
                    }
                }
                Log.d((String)AppRTCAudioManager.TAG, (String)("onAudioFocusChange: " + typeOfChange));
            }
        };
        int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 2);
        if (result == 1) {
            Log.d((String)TAG, (String)"Audio focus request granted for VOICE_CALL streams");
        } else {
            Log.e((String)TAG, (String)"Audio focus request failed");
        }
        this.audioManager.setMode(3);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = AudioDevice.NONE;
        this.selectedAudioDevice = AudioDevice.NONE;
        this.audioDevices.clear();
        this.bluetoothManager.start();
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        Log.d((String)TAG, (String)"AudioManager started");
    }

    public void stop() {
        Log.d((String)TAG, (String)"stop");
        ThreadUtils.checkIsOnMainThread();
        if (this.amState != AudioManagerState.RUNNING) {
            Log.e((String)TAG, (String)("Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.amState)));
            return;
        }
        this.amState = AudioManagerState.UNINITIALIZED;
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        this.bluetoothManager.stop();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        Log.d((String)TAG, (String)"Abandoned audio focus for VOICE_CALL streams");
        if (this.proximitySensor != null) {
            this.proximitySensor.stop();
            this.proximitySensor = null;
        }
        this.audioManagerEvents = null;
        Log.d((String)TAG, (String)"AudioManager stopped");
    }

    private void setAudioDeviceInternal(AudioDevice device) {
        Log.d((String)TAG, (String)("setAudioDeviceInternal(device=" + (Object)((Object)device) + ")"));
        AppRTCUtils.assertIsTrue(this.audioDevices.contains((Object)device));
        switch (device) {
            case SPEAKER_PHONE: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case BLUETOOTH: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Invalid audio device selection");
            }
        }
        this.selectedAudioDevice = device;
    }

    public void setDefaultAudioDevice(AudioDevice defaultDevice) {
        ThreadUtils.checkIsOnMainThread();
        switch (defaultDevice) {
            case SPEAKER_PHONE: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case EARPIECE: {
                if (this.hasEarpiece()) {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                this.defaultAudioDevice = AudioDevice.SPEAKER_PHONE;
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Invalid default audio device selection");
            }
        }
        Log.d((String)TAG, (String)("setDefaultAudioDevice(device=" + (Object)((Object)this.defaultAudioDevice) + ")"));
        this.updateAudioDeviceState();
    }

    public void selectAudioDevice(AudioDevice device) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.audioDevices.contains((Object)device)) {
            Log.e((String)TAG, (String)("Can not select " + (Object)((Object)device) + " from available " + this.audioDevices));
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    public Set<AudioDevice> getAudioDevices() {
        ThreadUtils.checkIsOnMainThread();
        return Collections.unmodifiableSet(new HashSet<AudioDevice>(this.audioDevices));
    }

    public AudioDevice getSelectedAudioDevice() {
        ThreadUtils.checkIsOnMainThread();
        return this.selectedAudioDevice;
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.audioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    private boolean hasEarpiece() {
        return this.apprtcContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                Log.d((String)TAG, (String)"hasWiredHeadset: found wired headset");
                return true;
            }
            if (type != 11) continue;
            Log.d((String)TAG, (String)"hasWiredHeadset: found USB audio device");
            return true;
        }
        return false;
    }

    public void updateAudioDeviceState() {
        AudioDevice newAudioDevice;
        boolean needBluetoothAudioStop;
        ThreadUtils.checkIsOnMainThread();
        Log.d((String)TAG, (String)("--- updateAudioDeviceState: wired headset=" + this.hasWiredHeadset + ", BT state=" + (Object)((Object)this.bluetoothManager.getState())));
        Log.d((String)TAG, (String)("Device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)this.selectedAudioDevice) + ", user selected=" + (Object)((Object)this.userSelectedAudioDevice)));
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_DISCONNECTING) {
            this.bluetoothManager.updateDevice();
        }
        HashSet<AudioDevice> newAudioDevices = new HashSet<AudioDevice>();
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(AudioDevice.BLUETOOTH);
        }
        if (this.hasWiredHeadset) {
            newAudioDevices.add(AudioDevice.WIRED_HEADSET);
        } else {
            newAudioDevices.add(AudioDevice.SPEAKER_PHONE);
            if (this.hasEarpiece()) {
                newAudioDevices.add(AudioDevice.EARPIECE);
            }
        }
        boolean audioDeviceSetUpdated = !this.audioDevices.equals(newAudioDevices);
        this.audioDevices = newAudioDevices;
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == AudioDevice.BLUETOOTH) {
            this.userSelectedAudioDevice = AudioDevice.NONE;
        }
        if (this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.SPEAKER_PHONE) {
            this.userSelectedAudioDevice = AudioDevice.WIRED_HEADSET;
        }
        if (!this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = AudioDevice.SPEAKER_PHONE;
        }
        boolean needBluetoothAudioStart = this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == AudioDevice.NONE || this.userSelectedAudioDevice == AudioDevice.BLUETOOTH);
        boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING) && this.userSelectedAudioDevice != AudioDevice.NONE && this.userSelectedAudioDevice != AudioDevice.BLUETOOTH;
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED) {
            Log.d((String)TAG, (String)("Need BT audio: start=" + needBluetoothAudioStart + ", stop=" + needBluetoothAudioStop + ", BT state=" + (Object)((Object)this.bluetoothManager.getState())));
        }
        if (needBluetoothAudioStop) {
            this.bluetoothManager.stopScoAudio();
            this.bluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !needBluetoothAudioStop && !this.bluetoothManager.startScoAudio()) {
            this.audioDevices.remove((Object)AudioDevice.BLUETOOTH);
            audioDeviceSetUpdated = true;
        }
        if ((newAudioDevice = this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED ? AudioDevice.BLUETOOTH : (this.hasWiredHeadset ? AudioDevice.WIRED_HEADSET : this.defaultAudioDevice)) != this.selectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            Log.d((String)TAG, (String)("New device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)newAudioDevice)));
            if (this.audioManagerEvents != null) {
                this.audioManagerEvents.onAudioDeviceChanged(this.selectedAudioDevice, this.audioDevices);
            }
        }
        Log.d((String)TAG, (String)"--- updateAudioDeviceState done");
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            Log.d((String)AppRTCAudioManager.TAG, (String)("WiredHeadsetReceiver.onReceive" + AppRTCUtils.getThreadInfo() + ": a=" + intent.getAction() + ", s=" + (state == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast()));
            AppRTCAudioManager.this.hasWiredHeadset = state == 1;
            AppRTCAudioManager.this.updateAudioDeviceState();
        }
    }

    public static interface AudioManagerEvents {
        public void onAudioDeviceChanged(AudioDevice var1, Set<AudioDevice> var2);
    }

    public static enum AudioManagerState {
        UNINITIALIZED,
        PREINITIALIZED,
        RUNNING;

    }

    public static enum AudioDevice {
        SPEAKER_PHONE,
        WIRED_HEADSET,
        EARPIECE,
        BLUETOOTH,
        NONE;

    }
}

