/*
 * Decompiled with CFR 0.152.
 */
package com.src.webrtc.android;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.src.webrtc.android.DataTrack;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.DataChannel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/src/webrtc/android/RemoteDataTrack;", "Lcom/src/webrtc/android/DataTrack;", "id", "", "dataChannel", "Lorg/webrtc/DataChannel;", "(Ljava/lang/String;Lorg/webrtc/DataChannel;)V", "handler", "Landroid/os/Handler;", "getId", "()Ljava/lang/String;", "messageListener", "Lcom/src/webrtc/android/DataTrack$MessageListener;", "registerMessageListener", "", "release", "Companion", "library_release"})
public final class RemoteDataTrack
extends DataTrack {
    private DataTrack.MessageListener messageListener;
    private final Handler handler;
    @NotNull
    private final String id;
    private final DataChannel dataChannel;
    private static final String TAG = "[rtc]RemoteDataTrack";
    public static final Companion Companion = new Companion(null);

    @Override
    public void release() {
        this.dataChannel.dispose();
    }

    public final void registerMessageListener(@Nullable DataTrack.MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public RemoteDataTrack(@NotNull String id, @NotNull DataChannel dataChannel) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)dataChannel, (String)"dataChannel");
        this.id = id;
        this.dataChannel = dataChannel;
        this.handler = new Handler(Looper.getMainLooper());
        this.dataChannel.registerObserver(new DataChannel.Observer(){

            public void onBufferedAmountChange(long p0) {
            }

            public void onStateChange() {
            }

            public void onMessage(@NotNull DataChannel.Buffer buffer) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
                    Log.d((String)RemoteDataTrack.TAG, (String)("onMessage " + dataChannel.label() + ' ' + dataChannel.state()));
                    DataTrack.MessageListener messageListener = messageListener;
                    if (messageListener == null) break block0;
                    DataTrack.MessageListener messageListener2 = messageListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    DataTrack.MessageListener it = messageListener2;
                    boolean bl3 = false;
                    ByteBuffer byteBuffer = buffer.data;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer.data");
                    DataChannel.Buffer copiedBuffer = new DataChannel.Buffer(Companion.cloneByteBuffer(byteBuffer), buffer.binary);
                    handler.post(new Runnable(copiedBuffer, it, this, buffer){
                        final /* synthetic */ DataChannel.Buffer $copiedBuffer;
                        final /* synthetic */ DataTrack.MessageListener $it;
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ DataChannel.Buffer $buffer$inlined;
                        {
                            this.$copiedBuffer = buffer;
                            this.$it = messageListener;
                            this.this$0 = var3_3;
                            this.$buffer$inlined = buffer2;
                        }

                        public final void run() {
                            Log.d((String)"[rtc]RemoteDataTrack", (String)("onMessage, label: " + RemoteDataTrack.access$getDataChannel$p(this.this$0.this).label()));
                            if (!this.$copiedBuffer.binary) {
                                ByteBuffer data = this.$copiedBuffer.data;
                                byte[] bytes = new byte[data.capacity()];
                                data.get(bytes);
                                Charset charset = Charset.forName("UTF-8");
                                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
                                Charset charset2 = charset;
                                boolean bl = false;
                                String msg = new String(bytes, charset2);
                                Log.d((String)"[rtc]RemoteDataTrack", (String)("onMessage: " + msg));
                                this.$it.onMessage(this.this$0.this, msg);
                            } else {
                                RemoteDataTrack remoteDataTrack = this.this$0.this;
                                ByteBuffer byteBuffer = this.$copiedBuffer.data;
                                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"copiedBuffer.data");
                                this.$it.onMessage(remoteDataTrack, byteBuffer);
                            }
                        }
                    });
                }
            }
        });
    }

    public static final /* synthetic */ void access$setMessageListener$p(RemoteDataTrack $this, DataTrack.MessageListener messageListener) {
        $this.messageListener = messageListener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/src/webrtc/android/RemoteDataTrack$Companion;", "", "()V", "TAG", "", "cloneByteBuffer", "Ljava/nio/ByteBuffer;", "original", "library_release"})
    public static final class Companion {
        private final ByteBuffer cloneByteBuffer(ByteBuffer original) {
            ByteBuffer clone = ByteBuffer.allocate(original.capacity());
            original.rewind();
            clone.put(original);
            original.rewind();
            clone.flip();
            ByteBuffer byteBuffer = clone;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"clone");
            return byteBuffer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

