/*
 * Decompiled with CFR 0.152.
 */
package com.src.webrtc.android;

import android.content.Context;
import android.util.Log;
import com.src.webrtc.android.AudioOptions;
import com.src.webrtc.android.EglBaseProvider;
import com.src.webrtc.android.ExecutorProvider;
import com.src.webrtc.android.VideoConstraints;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.appspot.apprtc.PeerConnectionClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.MediaConstraints;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J9\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\r\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\f0\u0012J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u001dR\u00020\u001eJI\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b\u0014\u0012\b\b\r\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\f0\u0012J\u0006\u0010&\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/src/webrtc/android/MediaFactory;", "", "appContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "eglBase", "Lorg/webrtc/EglBase;", "executor", "Ljava/util/concurrent/ExecutorService;", "factory", "Lorg/webrtc/PeerConnectionFactory;", "createAudioTrack", "", "name", "", "audioOptions", "Lcom/src/webrtc/android/AudioOptions;", "result", "Lkotlin/Function1;", "Lorg/webrtc/AudioTrack;", "Lkotlin/ParameterName;", "track", "createJavaAudioDevice", "Lorg/webrtc/audio/AudioDeviceModule;", "createPeerConnection", "Lorg/webrtc/PeerConnection;", "rtcConfig", "Lorg/webrtc/PeerConnection$RTCConfiguration;", "pcObserver", "Lorg/appspot/apprtc/PeerConnectionClient$PCObserver;", "Lorg/appspot/apprtc/PeerConnectionClient;", "createVideoTrack", "context", "constraints", "Lcom/src/webrtc/android/VideoConstraints;", "videoCapturer", "Lorg/webrtc/VideoCapturer;", "Lorg/webrtc/VideoTrack;", "release", "Companion", "library_release"})
public final class MediaFactory {
    private final EglBase eglBase;
    private final ExecutorService executor;
    private PeerConnectionFactory factory;
    private final Context appContext;
    private static final String TAG = "[rtc]MediaFactory";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static MediaFactory INSTANCE;
    private static final String VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL = "WebRTC-IntelVP8/Enabled/";
    public static final Companion Companion;

    public final void createVideoTrack(@NotNull Context context, @NotNull String name, @NotNull VideoConstraints constraints, @NotNull VideoCapturer videoCapturer, @NotNull Function1<? super VideoTrack, Unit> result) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)videoCapturer, (String)"videoCapturer");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        this.executor.execute(new Runnable(this, videoCapturer, context, constraints, result, name){
            final /* synthetic */ MediaFactory this$0;
            final /* synthetic */ VideoCapturer $videoCapturer;
            final /* synthetic */ Context $context;
            final /* synthetic */ VideoConstraints $constraints;
            final /* synthetic */ Function1 $result;
            final /* synthetic */ String $name;

            public final void run() {
                VideoSource videoSource;
                SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create((String)"CaptureThread", (EglBase.Context)MediaFactory.access$getEglBase$p(this.this$0).getEglBaseContext());
                VideoSource videoSource2 = videoSource = MediaFactory.access$getFactory$p(this.this$0).createVideoSource(this.$videoCapturer.isScreencast());
                if (videoSource2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$videoCapturer.initialize(surfaceTextureHelper, this.$context, videoSource2.getCapturerObserver());
                int width = this.$constraints.getResolution().getWidth();
                int height = this.$constraints.getResolution().getHeight();
                int fps = this.$constraints.getFps();
                this.$videoCapturer.startCapture(width, height, fps);
                VideoTrack videoTrack = MediaFactory.access$getFactory$p(this.this$0).createVideoTrack(this.$name, videoSource);
                Intrinsics.checkExpressionValueIsNotNull((Object)videoTrack, (String)"factory.createVideoTrack(name, videoSource)");
                this.$result.invoke((Object)videoTrack);
            }
            {
                this.this$0 = mediaFactory;
                this.$videoCapturer = videoCapturer;
                this.$context = context;
                this.$constraints = videoConstraints;
                this.$result = function1;
                this.$name = string2;
            }
        });
    }

    public final void createAudioTrack(@NotNull String name, @NotNull AudioOptions audioOptions, @NotNull Function1<? super AudioTrack, Unit> result) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)audioOptions, (String)"audioOptions");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        this.executor.execute(new Runnable(this, audioOptions, result, name){
            final /* synthetic */ MediaFactory this$0;
            final /* synthetic */ AudioOptions $audioOptions;
            final /* synthetic */ Function1 $result;
            final /* synthetic */ String $name;

            public final void run() {
                MediaConstraints constraints = new MediaConstraints();
                if (!this.$audioOptions.getEchoCancellation()) {
                    constraints.mandatory.add(new MediaConstraints.KeyValuePair("googEchoCancellation", "false"));
                }
                if (!this.$audioOptions.getAutoGainControl()) {
                    constraints.mandatory.add(new MediaConstraints.KeyValuePair("googAutoGainControl", "false"));
                }
                if (!this.$audioOptions.getHighPassFilter()) {
                    constraints.mandatory.add(new MediaConstraints.KeyValuePair("googHighpassFilter", "false"));
                }
                if (!this.$audioOptions.getNoiseSuppression()) {
                    constraints.mandatory.add(new MediaConstraints.KeyValuePair("googNoiseSuppression", "false"));
                }
                AudioSource audioSource = MediaFactory.access$getFactory$p(this.this$0).createAudioSource(constraints);
                AudioTrack audioTrack = MediaFactory.access$getFactory$p(this.this$0).createAudioTrack(this.$name, audioSource);
                Intrinsics.checkExpressionValueIsNotNull((Object)audioTrack, (String)"factory.createAudioTrack(name, audioSource)");
                this.$result.invoke((Object)audioTrack);
            }
            {
                this.this$0 = mediaFactory;
                this.$audioOptions = audioOptions;
                this.$result = function1;
                this.$name = string2;
            }
        });
    }

    @Nullable
    public final PeerConnection createPeerConnection(@NotNull PeerConnection.RTCConfiguration rtcConfig, @NotNull PeerConnectionClient.PCObserver pcObserver) {
        Intrinsics.checkParameterIsNotNull((Object)rtcConfig, (String)"rtcConfig");
        Intrinsics.checkParameterIsNotNull((Object)pcObserver, (String)"pcObserver");
        PeerConnectionFactory peerConnectionFactory = this.factory;
        if (peerConnectionFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"factory");
        }
        return peerConnectionFactory.createPeerConnection(rtcConfig, (PeerConnection.Observer)pcObserver);
    }

    public final void release() {
        Log.d((String)TAG, (String)"release");
        PeerConnectionFactory peerConnectionFactory = this.factory;
        if (peerConnectionFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"factory");
        }
        peerConnectionFactory.dispose();
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
        EglBaseProvider.INSTANCE.release(this);
        INSTANCE = null;
    }

    private final AudioDeviceModule createJavaAudioDevice() {
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback2 = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                Log.e((String)"[rtc]MediaFactory", (String)("onWebRtcAudioRecordInitError: " + errorMessage));
            }

            public void onWebRtcAudioRecordStartError(@NotNull JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, @NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorCode, (String)"errorCode");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                Log.e((String)"[rtc]MediaFactory", (String)("onWebRtcAudioRecordStartError: " + errorCode + ". " + errorMessage));
            }

            public void onWebRtcAudioRecordError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                Log.e((String)"[rtc]MediaFactory", (String)("onWebRtcAudioRecordError: " + errorMessage));
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback2 = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                Log.e((String)"[rtc]MediaFactory", (String)("onWebRtcAudioTrackInitError: " + errorMessage));
            }

            public void onWebRtcAudioTrackStartError(@NotNull JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, @NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorCode, (String)"errorCode");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                Log.e((String)"[rtc]MediaFactory", (String)("onWebRtcAudioTrackStartError: " + errorCode + ". " + errorMessage));
            }

            public void onWebRtcAudioTrackError(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                Log.e((String)"[rtc]MediaFactory", (String)("onWebRtcAudioTrackError: " + errorMessage));
            }
        };
        JavaAudioDeviceModule.AudioRecordStateCallback audioRecordStateCallback2 = new JavaAudioDeviceModule.AudioRecordStateCallback(){

            public void onWebRtcAudioRecordStart() {
                Log.i((String)"[rtc]MediaFactory", (String)"Audio recording starts");
            }

            public void onWebRtcAudioRecordStop() {
                Log.i((String)"[rtc]MediaFactory", (String)"Audio recording stops");
            }
        };
        JavaAudioDeviceModule.AudioTrackStateCallback audioTrackStateCallback2 = new JavaAudioDeviceModule.AudioTrackStateCallback(){

            public void onWebRtcAudioTrackStart() {
                Log.i((String)"[rtc]MediaFactory", (String)"Audio playout starts");
            }

            public void onWebRtcAudioTrackStop() {
                Log.i((String)"[rtc]MediaFactory", (String)"Audio playout stops");
            }
        };
        return (AudioDeviceModule)JavaAudioDeviceModule.builder((Context)this.appContext).setUseHardwareAcousticEchoCanceler(true).setUseHardwareNoiseSuppressor(true).setAudioRecordErrorCallback(audioRecordErrorCallback2).setAudioTrackErrorCallback(audioTrackErrorCallback2).setAudioRecordStateCallback(audioRecordStateCallback2).setAudioTrackStateCallback(audioTrackStateCallback2).createAudioDeviceModule();
    }

    private MediaFactory(Context appContext) {
        this.appContext = appContext;
        this.eglBase = EglBaseProvider.INSTANCE.getEglBase(this);
        this.executor = ExecutorProvider.INSTANCE.get();
        Log.d((String)TAG, (String)"init");
        final String fieldTrials = MediaFactory.Companion.getFieldTrials();
        this.executor.execute(new Runnable(){

            @Override
            public final void run() {
                block0: {
                    Log.d((String)MediaFactory.TAG, (String)("Initialize WebRTC. Field trials: " + fieldTrials));
                    PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder((Context)appContext).setFieldTrials(fieldTrials).setEnableInternalTracer(true).createInitializationOptions());
                    AudioDeviceModule adm = this.createJavaAudioDevice();
                    PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
                    Log.d((String)MediaFactory.TAG, (String)("Factory networkIgnoreMask option: " + options.networkIgnoreMask));
                    DefaultVideoEncoderFactory encoderFactory = new DefaultVideoEncoderFactory(eglBase.getEglBaseContext(), true, false);
                    DefaultVideoDecoderFactory decoderFactory = new DefaultVideoDecoderFactory(eglBase.getEglBaseContext());
                    PeerConnectionFactory peerConnectionFactory = PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule(adm).setVideoEncoderFactory((VideoEncoderFactory)encoderFactory).setVideoDecoderFactory((VideoDecoderFactory)decoderFactory).createPeerConnectionFactory();
                    Intrinsics.checkExpressionValueIsNotNull((Object)peerConnectionFactory, (String)"PeerConnectionFactory.bu\u2026tePeerConnectionFactory()");
                    factory = peerConnectionFactory;
                    Log.d((String)MediaFactory.TAG, (String)"Peer connection factory created.");
                    AudioDeviceModule audioDeviceModule = adm;
                    if (audioDeviceModule == null) break block0;
                    audioDeviceModule.release();
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ PeerConnectionFactory access$getFactory$p(MediaFactory $this) {
        PeerConnectionFactory peerConnectionFactory = $this.factory;
        if (peerConnectionFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"factory");
        }
        return peerConnectionFactory;
    }

    public /* synthetic */ MediaFactory(Context appContext, DefaultConstructorMarker $constructor_marker) {
        this(appContext);
    }

    @JvmStatic
    @NotNull
    public static final MediaFactory get(@NotNull Context context) {
        return Companion.get(context);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/src/webrtc/android/MediaFactory$Companion;", "", "()V", "AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT", "", "AUDIO_ECHO_CANCELLATION_CONSTRAINT", "AUDIO_HIGH_PASS_FILTER_CONSTRAINT", "AUDIO_NOISE_SUPPRESSION_CONSTRAINT", "INSTANCE", "Lcom/src/webrtc/android/MediaFactory;", "TAG", "VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL", "get", "context", "Landroid/content/Context;", "getFieldTrials", "library_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MediaFactory get(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            MediaFactory mediaFactory = INSTANCE;
            if (mediaFactory == null) {
                MediaFactory mediaFactory2 = new MediaFactory(context, null);
                boolean bl = false;
                boolean bl2 = false;
                MediaFactory $this$apply = mediaFactory2;
                boolean bl3 = false;
                INSTANCE = $this$apply;
                mediaFactory = mediaFactory2;
            }
            return mediaFactory;
        }

        private final String getFieldTrials() {
            String fieldTrials = "";
            fieldTrials = fieldTrials + MediaFactory.VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL;
            return fieldTrials;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

