/*
 * Decompiled with CFR 0.152.
 */
package org.appspot.apprtc;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import org.webrtc.PeerConnection;

public class RtcEventLog {
    private static final String TAG = "RtcEventLog";
    private static final int OUTPUT_FILE_MAX_BYTES = 10000000;
    private final PeerConnection peerConnection;
    private RtcEventLogState state = RtcEventLogState.INACTIVE;

    public RtcEventLog(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new NullPointerException("The peer connection is null.");
        }
        this.peerConnection = peerConnection;
    }

    public void start(File outputFile) {
        ParcelFileDescriptor fileDescriptor;
        if (this.state == RtcEventLogState.STARTED) {
            Log.e((String)TAG, (String)"RtcEventLog has already started.");
            return;
        }
        try {
            fileDescriptor = ParcelFileDescriptor.open((File)outputFile, (int)0x3C000000);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to create a new file", (Throwable)e);
            return;
        }
        boolean success = this.peerConnection.startRtcEventLog(fileDescriptor.detachFd(), 10000000);
        if (!success) {
            Log.e((String)TAG, (String)"Failed to start RTC event log.");
            return;
        }
        this.state = RtcEventLogState.STARTED;
        Log.d((String)TAG, (String)"RtcEventLog started.");
    }

    public void stop() {
        if (this.state != RtcEventLogState.STARTED) {
            Log.e((String)TAG, (String)"RtcEventLog was not started.");
            return;
        }
        this.peerConnection.stopRtcEventLog();
        this.state = RtcEventLogState.STOPPED;
        Log.d((String)TAG, (String)"RtcEventLog stopped.");
    }

    static enum RtcEventLogState {
        INACTIVE,
        STARTED,
        STOPPED;

    }
}

