/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.kotlin.KotlinGenerator;
import com.squareup.wire.kotlin.RpcCallStyle;
import com.squareup.wire.kotlin.RpcRole;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.fakefilesystem.FakeFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0007JL\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0016\u001a\u00020\r2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\rJ$\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u00020!2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#2\u0006\u0010$\u001a\u00020\rJ\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/squareup/wire/schema/RepoBuilder;", "", "()V", "fs", "Lokio/fakefilesystem/FakeFileSystem;", "root", "Lokio/Path;", "schema", "Lcom/squareup/wire/schema/Schema;", "schemaLoader", "Lcom/squareup/wire/schema/SchemaLoader;", "add", "path", "", "name", "protoFile", "addLocal", "generateCode", "typeName", "profileName", "generateGrpcKotlin", "", "serviceName", "rpcName", "rpcCallStyle", "Lcom/squareup/wire/kotlin/RpcCallStyle;", "rpcRole", "Lcom/squareup/wire/kotlin/RpcRole;", "nameSuffix", "generateKotlin", "boxOneOfsMinSize", "", "profile", "Lcom/squareup/wire/java/Profile;", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "messageTypeName", "wire-test-utils"})
public final class RepoBuilder {
    private final FakeFileSystem fs = new FakeFileSystem(null, 1, null);
    private final Path root = Path.Companion.get("/source");
    private final SchemaLoader schemaLoader = new SchemaLoader((FileSystem)this.fs);
    private Schema schema;

    @NotNull
    public final RepoBuilder add(@NotNull String name, @NotNull String protoFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        boolean bl = StringsKt.endsWith$default((String)name, (String)".proto", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".wire", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "unexpected file extension: " + name;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path relativePath = Path.Companion.get(name);
        try {
            Path resolvedPath = this.root.resolve(relativePath);
            Path parent = resolvedPath.parent();
            if (parent != null) {
                this.fs.createDirectories(parent);
            }
            FileSystem this_$iv = (FileSystem)this.fs;
            boolean $i$f$write = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(resolvedPath));
            boolean $i$f$use = false;
            BufferedSink result$iv$iv = null;
            Throwable thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl5 = false;
                BufferedSink $this$write = it$iv;
                boolean bl6 = false;
                result$iv$iv = $this$write.writeUtf8(protoFile);
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                if (thrown$iv$iv == null) {
                    thrown$iv$iv = t$iv$iv;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
            }
            if (thrown$iv$iv != null) {
                throw thrown$iv$iv;
            }
            Intrinsics.checkNotNull((Object)result$iv$iv);
        }
        catch (IOException e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RepoBuilder add(@NotNull String path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File("../wire-tests/src/commonTest/proto/java/" + path);
        Closeable closeable = (Closeable)Okio.source((File)file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Source source = (Source)closeable;
            boolean bl3 = false;
            String protoFile = Okio.buffer((Source)source).readUtf8();
            RepoBuilder repoBuilder = this.add(path, protoFile);
            return repoBuilder;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RepoBuilder addLocal(@NotNull String path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        Closeable closeable = (Closeable)Okio.source((File)file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Source source = (Source)closeable;
            boolean bl3 = false;
            String protoFile = Okio.buffer((Source)source).readUtf8();
            RepoBuilder repoBuilder = this.add(path, protoFile);
            return repoBuilder;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Schema schema() throws IOException {
        Schema result = this.schema;
        if (result == null) {
            SchemaLoader.initRoots$default((SchemaLoader)this.schemaLoader, (List)CollectionsKt.listOf((Object)Location.Companion.get("/source")), null, (int)2, null);
            this.schema = result = this.schemaLoader.loadSchema();
        }
        return result;
    }

    private final Profile profile(String profileName) throws IOException {
        if (profileName == null) {
            return new Profile(null, 1, null);
        }
        return this.schemaLoader.loadProfile(profileName, this.schema());
    }

    @NotNull
    public final ProtoAdapter<Object> protoAdapter(@NotNull String messageTypeName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)messageTypeName, (String)"messageTypeName");
        return this.schema().protoAdapter(messageTypeName, true);
    }

    @JvmOverloads
    @NotNull
    public final String generateCode(@NotNull String typeName, @Nullable String profileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Schema schema = this.schema();
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withProfile(this.profile(profileName));
        Type type = schema.getType(typeName);
        TypeSpec typeSpec = javaGenerator.generateType(type);
        String packageName = javaGenerator.generatedTypeName(type).packageName();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        String string = javaFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaFile.toString()");
        return string;
    }

    public static /* synthetic */ String generateCode$default(RepoBuilder repoBuilder, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return repoBuilder.generateCode(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final String generateCode(@NotNull String typeName) throws IOException {
        return RepoBuilder.generateCode$default(this, typeName, null, 2, null);
    }

    @NotNull
    public final String generateKotlin(@NotNull String typeName, @Nullable String profileName, int boxOneOfsMinSize) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Schema schema = this.schema();
        KotlinGenerator kotlinGenerator = KotlinGenerator.Companion.get$default((KotlinGenerator.Companion)KotlinGenerator.Companion, (Schema)schema, (Profile)this.profile(profileName), (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null, (int)boxOneOfsMinSize, (boolean)false, null, (int)1788, null);
        Type type = schema.getType(typeName);
        Intrinsics.checkNotNull((Object)type);
        Type type2 = type;
        com.squareup.kotlinpoet.TypeSpec typeSpec = kotlinGenerator.generateType(type2);
        String packageName = kotlinGenerator.generatedTypeName(type2).getPackageName();
        FileSpec fileSpec = FileSpec.Companion.builder(packageName, "_").addType(typeSpec).addImport("com.squareup.wire.kotlin", new String[]{"decodeMessage"}).build();
        return fileSpec.toString();
    }

    public static /* synthetic */ String generateKotlin$default(RepoBuilder repoBuilder, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            n = 5000;
        }
        return repoBuilder.generateKotlin(string, string2, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> generateGrpcKotlin(@NotNull String serviceName, @Nullable String rpcName, @NotNull RpcCallStyle rpcCallStyle, @NotNull RpcRole rpcRole, @Nullable String profileName, @Nullable String nameSuffix) {
        Object object;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Rpc rpc;
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)rpcCallStyle, (String)"rpcCallStyle");
        Intrinsics.checkNotNullParameter((Object)rpcRole, (String)"rpcRole");
        if (rpcRole == RpcRole.NONE) {
            return CollectionsKt.emptyList();
        }
        Schema schema = this.schema();
        KotlinGenerator grpcGenerator = KotlinGenerator.Companion.get$default((KotlinGenerator.Companion)KotlinGenerator.Companion, (Schema)schema, (Profile)this.profile(profileName), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (RpcCallStyle)rpcCallStyle, (RpcRole)rpcRole, (int)0, (boolean)false, (String)nameSuffix, (int)816, null);
        Service service = schema.getService(serviceName);
        Intrinsics.checkNotNull((Object)service);
        Service service2 = service;
        String string = rpcName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Rpc rpc2 = service2.rpc(rpcName);
            rpc = rpc2;
            Intrinsics.checkNotNull((Object)rpc2);
        } else {
            rpc = null;
        }
        Rpc rpc3 = rpc;
        Object $this$map$iv = grpcGenerator.generateServiceTypeSpecs(service2, rpc3);
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        boolean bl = false;
        FileSpec fileSpec = iterator.entrySet().iterator();
        while (fileSpec.hasNext()) {
            void typeName;
            void $dstr$typeName$typeSpec;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = fileSpec.next();
            collection = destination$iv$iv;
            boolean bl4 = false;
            void var22_25 = $dstr$typeName$typeSpec;
            boolean bl5 = false;
            ClassName className = (ClassName)var22_25.getKey();
            var22_25 = $dstr$typeName$typeSpec;
            bl5 = false;
            com.squareup.kotlinpoet.TypeSpec typeSpec = (com.squareup.kotlinpoet.TypeSpec)var22_25.getValue();
            object = FileSpec.Companion.builder(typeName.getPackageName(), "_").addType(typeSpec).build();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p1;
            Object item$iv$iv = iterator.next();
            fileSpec = (FileSpec)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            object = p1.toString();
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List generateGrpcKotlin$default(RepoBuilder repoBuilder, String string, String string2, RpcCallStyle rpcCallStyle, RpcRole rpcRole, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            rpcCallStyle = RpcCallStyle.SUSPENDING;
        }
        if ((n & 8) != 0) {
            rpcRole = RpcRole.CLIENT;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        return repoBuilder.generateGrpcKotlin(string, string2, rpcCallStyle, rpcRole, string3, string4);
    }
}

