/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.testing;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001aC\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f0\u000b\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u0012\u0010\u0013\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u001a&\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001a\u00a8\u0006\u001b"}, d2={"add", "", "Lokio/FileSystem;", "pathString", "", "contents", "charset", "Ljava/nio/charset/Charset;", "bom", "Lokio/ByteString;", "addZip", "", "Lkotlin/Pair;", "(Lokio/FileSystem;Ljava/lang/String;[Lkotlin/Pair;)V", "exists", "", "find", "", "path", "get", "symlink", "linkPathString", "targetPathString", "visitAll", "Lokio/Path;", "block", "Lkotlin/Function1;", "wire-test-utils"})
public final class FilesKt {
    public static final void add(@NotNull FileSystem $this$add, @NotNull String pathString, @NotNull String contents, @NotNull Charset charset, @NotNull ByteString bom) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)bom, (String)"bom");
        Path path = Path.Companion.get(pathString);
        if (path.parent() != null) {
            Path path2 = path.parent();
            Intrinsics.checkNotNull((Object)path2);
            $this$add.createDirectories(path2);
        }
        FileSystem this_$iv = $this$add;
        boolean $i$f$write = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(path));
        boolean $i$f$use = false;
        BufferedSink result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
            boolean bl = false;
            BufferedSink $this$write = it$iv;
            boolean bl2 = false;
            $this$write.write(bom.toByteArray());
            result$iv$iv = $this$write.writeString(contents, charset);
        }
        catch (Throwable t$iv$iv) {
            thrown$iv$iv = t$iv$iv;
        }
        try {
            Closeable closeable = $this$use$iv$iv;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable t$iv$iv) {
            if (thrown$iv$iv == null) {
                thrown$iv$iv = t$iv$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
        }
        if (thrown$iv$iv != null) {
            throw thrown$iv$iv;
        }
        Intrinsics.checkNotNull(result$iv$iv);
    }

    public static /* synthetic */ void add$default(FileSystem fileSystem, String string, String string2, Charset charset, ByteString byteString, int n, Object object) {
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 8) != 0) {
            byteString = ByteString.EMPTY;
        }
        FilesKt.add(fileSystem, string, string2, charset, byteString);
    }

    public static final void symlink(@NotNull FileSystem $this$symlink, @NotNull String linkPathString, @NotNull String targetPathString) {
        Intrinsics.checkNotNullParameter((Object)$this$symlink, (String)"$this$symlink");
        Intrinsics.checkNotNullParameter((Object)linkPathString, (String)"linkPathString");
        Intrinsics.checkNotNullParameter((Object)targetPathString, (String)"targetPathString");
        throw (Throwable)new UnsupportedOperationException("symlinks are not yet implemented in okio.FileSystem");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String get(@NotNull FileSystem $this$get, @NotNull String pathString) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        FileSystem fileSystem = $this$get;
        Path file$iv = Path.Companion.get(pathString);
        boolean $i$f$read = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
        boolean $i$f$use = false;
        Object result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
            boolean bl = false;
            BufferedSource $this$read = it$iv;
            boolean bl2 = false;
            return $this$read.readUtf8();
        }
        catch (Throwable t$iv$iv) {
            block7: {
                thrown$iv$iv = t$iv$iv;
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv2) {
                    if (thrown$iv$iv == null) {
                        thrown$iv$iv = t$iv$iv2;
                        break block7;
                    }
                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                }
            }
            if (thrown$iv$iv != null) {
                throw thrown$iv$iv;
            }
            Object v1 = result$iv$iv;
            Object v2 = v1;
            Intrinsics.checkNotNull(v1);
            throw new KotlinNothingValueException();
        }
    }

    public static final boolean exists(@NotNull FileSystem $this$exists, @NotNull String pathString) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"$this$exists");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Path path = Path.Companion.get(pathString);
        return $this$exists.exists(path);
    }

    public static final void visitAll(@NotNull FileSystem $this$visitAll, @NotNull Path path, @NotNull Function1<? super Path, Unit> block) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$visitAll, (String)"$this$visitAll");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke((Object)path);
        try {
            list = $this$visitAll.list(path);
        }
        catch (IOException e) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        List toVisit = list;
        for (Path child : toVisit) {
            FilesKt.visitAll($this$visitAll, child, block);
        }
    }

    @NotNull
    public static final Set<String> find(@NotNull FileSystem $this$find, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$find, (String)"$this$find");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean bl = false;
        Set result = new LinkedHashSet();
        FilesKt.visitAll($this$find, Path.Companion.get(path), (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>($this$find, result){
            final /* synthetic */ FileSystem $this_find;
            final /* synthetic */ Set $result;

            public final void invoke(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (!this.$this_find.metadata(path).isDirectory()) {
                    this.$result.add(path.toString());
                }
            }
            {
                this.$this_find = fileSystem;
                this.$result = set;
                super(1);
            }
        }));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void addZip(@NotNull FileSystem $this$addZip, @NotNull String pathString, Pair<String, String> ... contents) {
        Intrinsics.checkNotNullParameter((Object)$this$addZip, (String)"$this$addZip");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        Path path = Path.Companion.get(pathString);
        if (path.parent() != null) {
            Path path2 = path.parent();
            Intrinsics.checkNotNull((Object)path2);
            $this$addZip.createDirectories(path2);
        }
        FileSystem this_$iv = $this$addZip;
        boolean $i$f$write = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(path));
        boolean $i$f$use = false;
        Unit result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
            boolean bl = false;
            BufferedSink $this$write = it$iv;
            boolean bl2 = false;
            Closeable closeable = new ZipOutputStream($this$write.outputStream());
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                ZipOutputStream zipOut = (ZipOutputStream)closeable;
                boolean bl5 = false;
                BufferedSink zipSink = Okio.buffer((Sink)Okio.sink((OutputStream)zipOut));
                for (Pair<String, String> pair : contents) {
                    void elementPath;
                    String string = (String)pair.component1();
                    String elementContents = (String)pair.component2();
                    zipOut.putNextEntry(new ZipEntry((String)elementPath));
                    zipSink.writeUtf8(elementContents);
                    zipSink.flush();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            result$iv$iv = Unit.INSTANCE;
        }
        catch (Throwable t$iv$iv) {
            thrown$iv$iv = t$iv$iv;
        }
        try {
            Closeable closeable = $this$use$iv$iv;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable t$iv$iv) {
            if (thrown$iv$iv == null) {
                thrown$iv$iv = t$iv$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
        }
        if (thrown$iv$iv != null) {
            throw thrown$iv$iv;
        }
        Intrinsics.checkNotNull(result$iv$iv);
    }
}

