//[wire-grpc-client](../../index.md)/[com.squareup.wire](index.md)/[GrpcStreamingCall](-grpc-streaming-call.md)

# GrpcStreamingCall

[jvm]\

@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "grpcStreamingCall")

fun &lt;[S](-grpc-streaming-call.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), [R](-grpc-streaming-call.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [GrpcStreamingCall](-grpc-streaming-call.md)(function: suspend (ReceiveChannel&lt;[S](-grpc-streaming-call.md)&gt;, SendChannel&lt;[R](-grpc-streaming-call.md)&gt;) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)): GrpcStreamingCall&lt;[S](-grpc-streaming-call.md), [R](-grpc-streaming-call.md)&gt;

Returns a new instance of GrpcStreamingCall that can be used for a single call to executeIn or executeBlocking.

The returned instance launches [function](-grpc-streaming-call.md) on Dispatchers.IO. The function must close the SendChannel when it has no more messages to transmit. If [function](-grpc-streaming-call.md) throws, both channels will be closed using the thrown exception as a cause.

This method is useful when implementing the interfaces that are generated by Wire:

override fun RouteChat(): GrpcStreamingCall&lt;RouteNote, RouteNote&gt; {\
  return GrpcStreamingCall { requests, responses -&gt;\
    requests.consumeEach { note -&gt;\
      responses.send(translateNote(note))\
    }\
    responses.close()\
  }\
}

It is succinct when used in an expression function:

override fun RouteChat() = GrpcStreamingCall&lt;RouteNote, RouteNote&gt; { requests, responses -&gt;\
  requests.consumeEach { note -&gt;\
    responses.send(translateNote(note))\
  }\
  responses.close()\
}
