

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import java.util.Collection;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProtoFileElement extends ProtoFileElement {

  private final Location location;

  private final String packageName;

  private final ProtoFile.Syntax syntax;

  private final ImmutableList<String> imports;

  private final ImmutableList<String> publicImports;

  private final ImmutableList<TypeElement> types;

  private final ImmutableList<ServiceElement> services;

  private final ImmutableList<ExtendElement> extendDeclarations;

  private final ImmutableList<OptionElement> options;

  private AutoValue_ProtoFileElement(
      Location location,
      @Nullable String packageName,
      @Nullable ProtoFile.Syntax syntax,
      ImmutableList<String> imports,
      ImmutableList<String> publicImports,
      ImmutableList<TypeElement> types,
      ImmutableList<ServiceElement> services,
      ImmutableList<ExtendElement> extendDeclarations,
      ImmutableList<OptionElement> options) {
    this.location = location;
    this.packageName = packageName;
    this.syntax = syntax;
    this.imports = imports;
    this.publicImports = publicImports;
    this.types = types;
    this.services = services;
    this.extendDeclarations = extendDeclarations;
    this.options = options;
  }

  @Override
  public Location location() {
    return location;
  }

  @Nullable
  @Override
  public String packageName() {
    return packageName;
  }

  @Nullable
  @Override
  public ProtoFile.Syntax syntax() {
    return syntax;
  }

  @Override
  public ImmutableList<String> imports() {
    return imports;
  }

  @Override
  public ImmutableList<String> publicImports() {
    return publicImports;
  }

  @Override
  public ImmutableList<TypeElement> types() {
    return types;
  }

  @Override
  public ImmutableList<ServiceElement> services() {
    return services;
  }

  @Override
  public ImmutableList<ExtendElement> extendDeclarations() {
    return extendDeclarations;
  }

  @Override
  public ImmutableList<OptionElement> options() {
    return options;
  }

  @Override
  public String toString() {
    return "ProtoFileElement{"
         + "location=" + location + ", "
         + "packageName=" + packageName + ", "
         + "syntax=" + syntax + ", "
         + "imports=" + imports + ", "
         + "publicImports=" + publicImports + ", "
         + "types=" + types + ", "
         + "services=" + services + ", "
         + "extendDeclarations=" + extendDeclarations + ", "
         + "options=" + options
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProtoFileElement) {
      ProtoFileElement that = (ProtoFileElement) o;
      return (this.location.equals(that.location()))
           && ((this.packageName == null) ? (that.packageName() == null) : this.packageName.equals(that.packageName()))
           && ((this.syntax == null) ? (that.syntax() == null) : this.syntax.equals(that.syntax()))
           && (this.imports.equals(that.imports()))
           && (this.publicImports.equals(that.publicImports()))
           && (this.types.equals(that.types()))
           && (this.services.equals(that.services()))
           && (this.extendDeclarations.equals(that.extendDeclarations()))
           && (this.options.equals(that.options()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= (packageName == null) ? 0 : packageName.hashCode();
    h$ *= 1000003;
    h$ ^= (syntax == null) ? 0 : syntax.hashCode();
    h$ *= 1000003;
    h$ ^= imports.hashCode();
    h$ *= 1000003;
    h$ ^= publicImports.hashCode();
    h$ *= 1000003;
    h$ ^= types.hashCode();
    h$ *= 1000003;
    h$ ^= services.hashCode();
    h$ *= 1000003;
    h$ ^= extendDeclarations.hashCode();
    h$ *= 1000003;
    h$ ^= options.hashCode();
    return h$;
  }

  static final class Builder implements ProtoFileElement.Builder {
    private Location location;
    private String packageName;
    private ProtoFile.Syntax syntax;
    private ImmutableList<String> imports;
    private ImmutableList<String> publicImports;
    private ImmutableList<TypeElement> types;
    private ImmutableList<ServiceElement> services;
    private ImmutableList<ExtendElement> extendDeclarations;
    private ImmutableList<OptionElement> options;
    Builder() {
    }
    @Override
    public ProtoFileElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public ProtoFileElement.Builder packageName(@Nullable String packageName) {
      this.packageName = packageName;
      return this;
    }
    @Override
    public ProtoFileElement.Builder syntax(@Nullable ProtoFile.Syntax syntax) {
      this.syntax = syntax;
      return this;
    }
    @Override
    public ProtoFileElement.Builder imports(ImmutableList<String> imports) {
      if (imports == null) {
        throw new NullPointerException("Null imports");
      }
      this.imports = imports;
      return this;
    }
    @Override
    public ProtoFileElement.Builder publicImports(ImmutableList<String> publicImports) {
      if (publicImports == null) {
        throw new NullPointerException("Null publicImports");
      }
      this.publicImports = publicImports;
      return this;
    }
    @Override
    public ProtoFileElement.Builder types(ImmutableList<TypeElement> types) {
      if (types == null) {
        throw new NullPointerException("Null types");
      }
      this.types = types;
      return this;
    }
    @Override
    public ProtoFileElement.Builder services(ImmutableList<ServiceElement> services) {
      if (services == null) {
        throw new NullPointerException("Null services");
      }
      this.services = services;
      return this;
    }
    @Override
    public ProtoFileElement.Builder extendDeclarations(ImmutableList<ExtendElement> extendDeclarations) {
      if (extendDeclarations == null) {
        throw new NullPointerException("Null extendDeclarations");
      }
      this.extendDeclarations = extendDeclarations;
      return this;
    }
    @Override
    public ProtoFileElement.Builder options(Collection<OptionElement> options) {
      this.options = ImmutableList.copyOf(options);
      return this;
    }
    @Override
    public ProtoFileElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.imports == null) {
        missing += " imports";
      }
      if (this.publicImports == null) {
        missing += " publicImports";
      }
      if (this.types == null) {
        missing += " types";
      }
      if (this.services == null) {
        missing += " services";
      }
      if (this.extendDeclarations == null) {
        missing += " extendDeclarations";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ProtoFileElement(
          this.location,
          this.packageName,
          this.syntax,
          this.imports,
          this.publicImports,
          this.types,
          this.services,
          this.extendDeclarations,
          this.options);
    }
  }

}
