/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.internal.Util;
import com.squareup.wire.schema.internal.parser.AutoValue_GroupElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import java.util.Locale;

public abstract class GroupElement {
    public static Builder builder() {
        return new AutoValue_GroupElement.Builder().documentation("").fields((ImmutableList<FieldElement>)ImmutableList.of());
    }

    public abstract Field.Label label();

    public abstract String name();

    public abstract int tag();

    public abstract String documentation();

    public abstract ImmutableList<FieldElement> fields();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        if (this.label() != null) {
            builder.append(this.label().name().toLowerCase(Locale.US)).append(' ');
        }
        builder.append("group ").append(this.name()).append(" = ").append(this.tag()).append(" {");
        if (!this.fields().isEmpty()) {
            builder.append('\n');
            for (FieldElement field : this.fields()) {
                Util.appendIndented(builder, field.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static interface Builder {
        public Builder label(Field.Label var1);

        public Builder name(String var1);

        public Builder tag(int var1);

        public Builder documentation(String var1);

        public Builder fields(ImmutableList<FieldElement> var1);

        public GroupElement build();
    }
}

