/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import java.util.Collection;
import java.util.List;

public final class Field {
    static final ProtoMember DEPRECATED = ProtoMember.get(Options.FIELD_OPTIONS, "deprecated");
    static final ProtoMember PACKED = ProtoMember.get(Options.FIELD_OPTIONS, "packed");
    private final String packageName;
    private final Location location;
    private final Label label;
    private final String name;
    private final String documentation;
    private final int tag;
    private final String defaultValue;
    private final String elementType;
    private final boolean extension;
    private final Options options;
    private ProtoType type;
    private Object deprecated;
    private Object packed;

    private Field(String packageName, Location location, Label label, String name, String documentation, int tag, String defaultValue, String elementType, Options options, boolean extension) {
        this.packageName = packageName;
        this.location = location;
        this.label = label;
        this.name = name;
        this.documentation = documentation;
        this.tag = tag;
        this.defaultValue = defaultValue;
        this.elementType = elementType;
        this.extension = extension;
        this.options = options;
    }

    static ImmutableList<Field> fromElements(String packageName, ImmutableList<FieldElement> fieldElements, boolean extension) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (FieldElement field : fieldElements) {
            fields.add((Object)new Field(packageName, field.location(), field.label(), field.name(), field.documentation(), field.tag(), field.defaultValue(), field.type(), new Options(Options.FIELD_OPTIONS, (List<OptionElement>)field.options()), extension));
        }
        return fields.build();
    }

    static ImmutableList<FieldElement> toElements(ImmutableList<Field> fields) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Field field : fields) {
            elements.add((Object)FieldElement.builder(field.location).label(field.label).name(field.name).documentation(field.documentation).tag(field.tag).defaultValue(field.defaultValue).options(field.options.toElements()).type(field.elementType).build());
        }
        return elements.build();
    }

    public Location location() {
        return this.location;
    }

    public String packageName() {
        return this.packageName;
    }

    public Label label() {
        return this.label;
    }

    public boolean isRepeated() {
        return this.label() == Label.REPEATED;
    }

    public boolean isOptional() {
        return this.label() == Label.OPTIONAL;
    }

    public boolean isRequired() {
        return this.label() == Label.REQUIRED;
    }

    public ProtoType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String qualifiedName() {
        return this.packageName != null ? this.packageName + '.' + this.name : this.name;
    }

    public int tag() {
        return this.tag;
    }

    public String documentation() {
        return this.documentation;
    }

    public Options options() {
        return this.options;
    }

    public boolean isDeprecated() {
        return "true".equals(this.deprecated);
    }

    public boolean isPacked() {
        return "true".equals(this.packed);
    }

    public String getDefault() {
        return this.defaultValue;
    }

    private boolean isPackable(Linker linker, ProtoType type) {
        return !type.equals(ProtoType.STRING) && !type.equals(ProtoType.BYTES) && !(linker.get(type) instanceof MessageType);
    }

    public boolean isExtension() {
        return this.extension;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.type = linker.resolveType(this.elementType);
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        this.options.link(linker);
        this.deprecated = this.options().get(DEPRECATED);
        this.packed = this.options().get(PACKED);
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        if (this.isPacked() && !this.isPackable(linker, this.type)) {
            linker.addError("packed=true not permitted on %s", this.type);
        }
        if (this.extension && this.isRequired()) {
            linker.addError("extension fields cannot be required", this.type);
        }
        linker.validateImport(this.location(), this.type);
    }

    Field retainAll(Schema schema, MarkSet markSet) {
        if (!markSet.contains(this.type)) {
            return null;
        }
        Field result = new Field(this.packageName, this.location, this.label, this.name, this.documentation, this.tag, this.defaultValue, this.elementType, this.options.retainAll(schema, markSet), this.extension);
        result.type = this.type;
        result.deprecated = this.deprecated;
        result.packed = this.packed;
        return result;
    }

    static ImmutableList<Field> retainAll(Schema schema, MarkSet markSet, ProtoType enclosingType, Collection<Field> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Field field : fields) {
            Field retainedField = field.retainAll(schema, markSet);
            if (retainedField == null || !markSet.contains(ProtoMember.get(enclosingType, field.name()))) continue;
            result.add((Object)retainedField);
        }
        return result.build();
    }

    public String toString() {
        return this.name();
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED,
        ONE_OF;

    }
}

