/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.Util;
import com.squareup.wire.schema.internal.parser.AutoValue_ReservedElement;

public abstract class ReservedElement {
    public static ReservedElement create(Location location, String documentation, ImmutableList<Object> values) {
        return new AutoValue_ReservedElement(location, documentation, values);
    }

    public abstract Location location();

    public abstract String documentation();

    public abstract ImmutableList<Object> values();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("reserved ");
        ImmutableList<Object> value = this.values();
        for (int i = 0; i < value.size(); ++i) {
            Object reservation;
            if (i > 0) {
                builder.append(", ");
            }
            if ((reservation = value.get(i)) instanceof String) {
                builder.append('\"').append(reservation).append('\"');
                continue;
            }
            if (reservation instanceof Integer) {
                builder.append(reservation);
                continue;
            }
            if (reservation instanceof Range) {
                Range range = (Range)reservation;
                builder.append(range.lowerEndpoint()).append(" to ").append(range.upperEndpoint());
                continue;
            }
            throw new AssertionError();
        }
        return builder.append(";\n").toString();
    }
}

