/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.ReservedElement;

final class Reserved {
    private final Location location;
    private final String documentation;
    private final ImmutableList<Object> values;

    private Reserved(Location location, String documentation, ImmutableList<Object> values) {
        this.location = location;
        this.documentation = documentation;
        this.values = values;
    }

    public Location location() {
        return this.location;
    }

    public String documentation() {
        return this.documentation;
    }

    public ImmutableList<Object> values() {
        return this.values;
    }

    public boolean matchesTag(int tag) {
        for (Object value : this.values) {
            if (value instanceof Integer && tag == (Integer)value) {
                return true;
            }
            if (!(value instanceof Range) || !((Range)value).contains((Comparable)Integer.valueOf(tag))) continue;
            return true;
        }
        return false;
    }

    public boolean matchesName(String name) {
        for (Object value : this.values) {
            if (!(value instanceof String) || !name.equals(value)) continue;
            return true;
        }
        return false;
    }

    static ImmutableList<Reserved> fromElements(ImmutableList<ReservedElement> reserveds) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ReservedElement reserved : reserveds) {
            builder.add((Object)new Reserved(reserved.location(), reserved.documentation(), reserved.values()));
        }
        return builder.build();
    }

    static ImmutableList<ReservedElement> toElements(ImmutableList<Reserved> reserveds) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Reserved reserved : reserveds) {
            builder.add((Object)ReservedElement.create(reserved.location(), reserved.documentation(), reserved.values()));
        }
        return builder.build();
    }
}

