/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.OneOfElement;

public final class OneOf {
    private final OneOfElement element;
    private final ImmutableList<Field> fields;

    public OneOf(OneOfElement element, ImmutableList<Field> fields) {
        this.element = element;
        this.fields = fields;
    }

    public String name() {
        return this.element.name();
    }

    public String documentation() {
        return this.element.documentation();
    }

    public ImmutableList<Field> fields() {
        return this.fields;
    }

    void link(Linker linker) {
        for (Field field : this.fields) {
            field.link(linker);
        }
    }

    void linkOptions(Linker linker) {
        for (Field field : this.fields) {
            field.linkOptions(linker);
        }
    }

    OneOf retainAll(Schema schema, MarkSet markSet, ProtoType enclosingType) {
        ImmutableList<Field> retainedFields = Field.retainAll(schema, markSet, enclosingType, this.fields);
        if (retainedFields.isEmpty()) {
            return null;
        }
        return new OneOf(this.element, retainedFields);
    }
}

