/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.internal.parser.AutoValue_ProtoParser_OptionKindAndValue;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ProtoParser {
    private final Location location;
    private final char[] data;
    private final ProtoFileElement.Builder fileBuilder;
    private final ImmutableList.Builder<String> publicImports = ImmutableList.builder();
    private final ImmutableList.Builder<String> imports = ImmutableList.builder();
    private final ImmutableList.Builder<TypeElement> nestedTypes = ImmutableList.builder();
    private final ImmutableList.Builder<ServiceElement> services = ImmutableList.builder();
    private final ImmutableList.Builder<ExtendElement> extendsList = ImmutableList.builder();
    private final ImmutableList.Builder<OptionElement> options = ImmutableList.builder();
    private int declarationCount = 0;
    private ProtoFile.Syntax syntax;
    private int pos;
    private int line;
    private int lineStart;
    private String packageName;
    private String prefix = "";

    public static ProtoFileElement parse(Location location, String data) {
        return new ProtoParser(location, data.toCharArray()).readProtoFile();
    }

    ProtoParser(Location location, char[] data) {
        this.location = location;
        this.data = data;
        this.fileBuilder = ProtoFileElement.builder(location);
    }

    ProtoFileElement readProtoFile() {
        while (true) {
            String documentation = this.readDocumentation();
            if (this.pos == this.data.length) {
                return this.fileBuilder.syntax(this.syntax).publicImports((ImmutableList<String>)this.publicImports.build()).imports((ImmutableList<String>)this.imports.build()).types((ImmutableList<TypeElement>)this.nestedTypes.build()).services((ImmutableList<ServiceElement>)this.services.build()).extendDeclarations((ImmutableList<ExtendElement>)this.extendsList.build()).options((Collection<OptionElement>)this.options.build()).build();
            }
            Object declaration = this.readDeclaration(documentation, Context.FILE);
            if (declaration instanceof TypeElement) {
                this.nestedTypes.add((Object)((TypeElement)declaration));
                continue;
            }
            if (declaration instanceof ServiceElement) {
                this.services.add((Object)((ServiceElement)declaration));
                continue;
            }
            if (declaration instanceof OptionElement) {
                this.options.add((Object)((OptionElement)declaration));
                continue;
            }
            if (!(declaration instanceof ExtendElement)) continue;
            this.extendsList.add((Object)((ExtendElement)declaration));
        }
    }

    private Object readDeclaration(String documentation, Context context) {
        int index = this.declarationCount++;
        if (this.peekChar() == ';') {
            ++this.pos;
            return null;
        }
        Location location = this.location();
        String label = this.readWord();
        if (label.equals("package")) {
            if (!context.permitsPackage()) {
                throw this.unexpected(location, "'package' in " + (Object)((Object)context));
            }
            if (this.packageName != null) {
                throw this.unexpected(location, "too many package names");
            }
            this.packageName = this.readName();
            this.fileBuilder.packageName(this.packageName);
            this.prefix = this.packageName + ".";
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("import")) {
            if (!context.permitsImport()) {
                throw this.unexpected(location, "'import' in " + (Object)((Object)context));
            }
            String importString = this.readString();
            if ("public".equals(importString)) {
                this.publicImports.add((Object)this.readString());
            } else {
                this.imports.add((Object)importString);
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("syntax")) {
            if (!context.permitsSyntax()) {
                throw this.unexpected(location, "'syntax' in " + (Object)((Object)context));
            }
            if (this.readChar() != '=') {
                throw this.unexpected("expected '='");
            }
            if (index != 0) {
                throw this.unexpected(location, "'syntax' element must be the first declaration in a file");
            }
            String syntaxString = this.readQuotedString();
            try {
                this.syntax = ProtoFile.Syntax.get(syntaxString);
            }
            catch (IllegalArgumentException e) {
                throw this.unexpected(location, e.getMessage());
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("option")) {
            OptionElement result = this.readOption('=');
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return result;
        }
        if (label.equals("message")) {
            return this.readMessage(location, documentation);
        }
        if (label.equals("enum")) {
            return this.readEnumElement(location, documentation);
        }
        if (label.equals("service")) {
            return this.readService(location, documentation);
        }
        if (label.equals("extend")) {
            return this.readExtend(location, documentation);
        }
        if (label.equals("rpc")) {
            if (!context.permitsRpc()) {
                throw this.unexpected(location, "'rpc' in " + (Object)((Object)context));
            }
            return this.readRpc(location, documentation);
        }
        if (label.equals("oneof")) {
            if (!context.permitsOneOf()) {
                throw this.unexpected(location, "'oneof' must be nested in message");
            }
            return this.readOneOf(documentation);
        }
        if (label.equals("extensions")) {
            if (!context.permitsExtensions()) {
                throw this.unexpected(location, "'extensions' must be nested");
            }
            return this.readExtensions(location, documentation);
        }
        if (context == Context.MESSAGE || context == Context.EXTEND) {
            return this.readField(documentation, location, label);
        }
        if (context == Context.ENUM) {
            ImmutableList.Builder options;
            EnumConstantElement.Builder builder;
            block35: {
                if (this.readChar() != '=') {
                    throw this.unexpected("expected '='");
                }
                builder = EnumConstantElement.builder(location).name(label).tag(this.readInt());
                options = ImmutableList.builder();
                if (this.peekChar() == '[') {
                    char c;
                    this.readChar();
                    do {
                        options.add((Object)this.readOption('='));
                        c = this.readChar();
                        if (c == ']') break block35;
                    } while (c == ',');
                    throw this.unexpected("Expected ',' or ']");
                }
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            documentation = this.tryAppendTrailingDocumentation(documentation);
            return builder.documentation(documentation).options((ImmutableList<OptionElement>)options.build()).build();
        }
        throw this.unexpected(location, "unexpected label: " + label);
    }

    private MessageElement readMessage(Location location, String documentation) {
        String name = this.readName();
        MessageElement.Builder builder = MessageElement.builder(location).name(name).documentation(documentation);
        String previousPrefix = this.prefix;
        this.prefix = this.prefix + name + ".";
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder oneOfs = ImmutableList.builder();
        ImmutableList.Builder nestedTypes = ImmutableList.builder();
        ImmutableList.Builder extensions = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(nestedDocumentation, Context.MESSAGE);
            if (declared instanceof FieldElement) {
                fields.add((Object)((FieldElement)declared));
                continue;
            }
            if (declared instanceof OneOfElement) {
                oneOfs.add((Object)((OneOfElement)declared));
                continue;
            }
            if (declared instanceof TypeElement) {
                nestedTypes.add((Object)((TypeElement)declared));
                continue;
            }
            if (declared instanceof ExtensionsElement) {
                extensions.add((Object)((ExtensionsElement)declared));
                continue;
            }
            if (declared instanceof OptionElement) {
                options.add((Object)((OptionElement)declared));
                continue;
            }
            if (!(declared instanceof ExtendElement)) continue;
            this.extendsList.add((Object)((ExtendElement)declared));
        }
        this.prefix = previousPrefix;
        return builder.fields((ImmutableList<FieldElement>)fields.build()).oneOfs((ImmutableList<OneOfElement>)oneOfs.build()).nestedTypes((ImmutableList<TypeElement>)nestedTypes.build()).extensions((ImmutableList<ExtensionsElement>)extensions.build()).options((ImmutableList<OptionElement>)options.build()).build();
    }

    private ExtendElement readExtend(Location location, String documentation) {
        String name = this.readName();
        ExtendElement.Builder builder = ExtendElement.builder(location).name(name).documentation(documentation);
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(nestedDocumentation, Context.EXTEND);
            if (!(declared instanceof FieldElement)) continue;
            fields.add((Object)((FieldElement)declared));
        }
        return builder.fields((ImmutableList<FieldElement>)fields.build()).build();
    }

    private ServiceElement readService(Location location, String documentation) {
        String name = this.readName();
        ServiceElement.Builder builder = ServiceElement.builder(location).name(name).documentation(documentation);
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        ImmutableList.Builder rpcs = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        while (true) {
            String rpcDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(rpcDocumentation, Context.SERVICE);
            if (declared instanceof RpcElement) {
                rpcs.add((Object)((RpcElement)declared));
                continue;
            }
            if (!(declared instanceof OptionElement)) continue;
            options.add((Object)((OptionElement)declared));
        }
        return builder.options((ImmutableList<OptionElement>)options.build()).rpcs((ImmutableList<RpcElement>)rpcs.build()).build();
    }

    private EnumElement readEnumElement(Location location, String documentation) {
        String name = this.readName();
        EnumElement.Builder builder = EnumElement.builder(location).name(name).documentation(documentation);
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        ImmutableList.Builder constants = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        while (true) {
            String valueDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(valueDocumentation, Context.ENUM);
            if (declared instanceof EnumConstantElement) {
                constants.add((Object)((EnumConstantElement)declared));
                continue;
            }
            if (!(declared instanceof OptionElement)) continue;
            options.add((Object)((OptionElement)declared));
        }
        return builder.options((ImmutableList<OptionElement>)options.build()).constants((ImmutableList<EnumConstantElement>)constants.build()).build();
    }

    private Object readField(String documentation, Location location, String word) {
        String type;
        Field.Label label;
        switch (word) {
            case "required": {
                if (this.syntax == ProtoFile.Syntax.PROTO_3) {
                    throw this.unexpected(location, "'required' label forbidden in proto3 field declarations");
                }
                label = Field.Label.REQUIRED;
                type = this.readDataType();
                break;
            }
            case "optional": {
                if (this.syntax == ProtoFile.Syntax.PROTO_3) {
                    throw this.unexpected(location, "'optional' label forbidden in proto3 field declarations");
                }
                label = Field.Label.OPTIONAL;
                type = this.readDataType();
                break;
            }
            case "repeated": {
                label = Field.Label.REPEATED;
                type = this.readDataType();
                break;
            }
            default: {
                if (this.syntax == ProtoFile.Syntax.PROTO_2) {
                    throw this.unexpected(location, "unexpected label: " + word);
                }
                label = null;
                type = this.readDataType(word);
            }
        }
        return this.readField(location, documentation, label, type);
    }

    private FieldElement readField(Location location, String documentation, Field.Label label, String type) {
        String name = this.readName();
        if (this.readChar() != '=') {
            throw this.unexpected("expected '='");
        }
        int tag = this.readInt();
        FieldElement.Builder builder = FieldElement.builder(location).label(label).type(type).name(name).tag(tag);
        ImmutableList.Builder options = ImmutableList.builder();
        if (this.peekChar() == '[') {
            ++this.pos;
            while (true) {
                OptionElement option;
                if ((option = this.readOption('=')).name().equals("default")) {
                    builder.defaultValue(String.valueOf(option.value()));
                } else {
                    options.add((Object)option);
                }
                char c = this.peekChar();
                if (c == ']') {
                    ++this.pos;
                    break;
                }
                if (c != ',') continue;
                ++this.pos;
            }
        }
        if (this.readChar() != ';') {
            throw this.unexpected("expected ';'");
        }
        documentation = this.tryAppendTrailingDocumentation(documentation);
        return builder.documentation(documentation).options((ImmutableList<OptionElement>)options.build()).build();
    }

    private OneOfElement readOneOf(String documentation) {
        OneOfElement.Builder builder = OneOfElement.builder().name(this.readName()).documentation(documentation);
        ImmutableList.Builder fields = ImmutableList.builder();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Location location = this.location();
            String type = this.readDataType();
            fields.add((Object)this.readField(location, nestedDocumentation, null, type));
        }
        return builder.fields((ImmutableList<FieldElement>)fields.build()).build();
    }

    private ExtensionsElement readExtensions(Location location, String documentation) {
        int start;
        int end = start = this.readInt();
        if (this.peekChar() != ';') {
            if (!"to".equals(this.readWord())) {
                throw this.unexpected("expected ';' or 'to'");
            }
            String s = this.readWord();
            end = s.equals("max") ? 0x1FFFFFFF : Integer.parseInt(s);
        }
        if (this.readChar() != ';') {
            throw this.unexpected("expected ';'");
        }
        return ExtensionsElement.create(location, start, end, documentation);
    }

    private OptionElement readOption(char keyValueSeparator) {
        boolean isExtension = this.peekChar() == '[';
        boolean isParenthesized = this.peekChar() == '(';
        String name = this.readName();
        if (isExtension) {
            name = "[" + name + "]";
        }
        String subName = null;
        char c = this.readChar();
        if (c == '.') {
            subName = this.readName();
            c = this.readChar();
        }
        if (keyValueSeparator == ':' && c == '{') {
            --this.pos;
        } else if (c != keyValueSeparator) {
            throw this.unexpected("expected '" + keyValueSeparator + "' in option");
        }
        OptionKindAndValue kindAndValue = this.readKindAndValue();
        OptionElement.Kind kind = kindAndValue.kind();
        Object value = kindAndValue.value();
        if (subName != null) {
            value = OptionElement.create(subName, kind, value);
            kind = OptionElement.Kind.OPTION;
        }
        return OptionElement.create(name, kind, value, isParenthesized);
    }

    private OptionKindAndValue readKindAndValue() {
        String word;
        char peeked = this.peekChar();
        switch (peeked) {
            case '{': {
                return OptionKindAndValue.of(OptionElement.Kind.MAP, this.readMap('{', '}', ':'));
            }
            case '[': {
                return OptionKindAndValue.of(OptionElement.Kind.LIST, this.readList());
            }
            case '\"': {
                return OptionKindAndValue.of(OptionElement.Kind.STRING, this.readString());
            }
        }
        if (Character.isDigit(peeked) || peeked == '-') {
            return OptionKindAndValue.of(OptionElement.Kind.NUMBER, this.readWord());
        }
        switch (word = this.readWord()) {
            case "true": {
                return OptionKindAndValue.of(OptionElement.Kind.BOOLEAN, "true");
            }
            case "false": {
                return OptionKindAndValue.of(OptionElement.Kind.BOOLEAN, "false");
            }
        }
        return OptionKindAndValue.of(OptionElement.Kind.ENUM, word);
    }

    private Map<String, Object> readMap(char openBrace, char closeBrace, char keyValueSeparator) {
        if (this.readChar() != openBrace) {
            throw new AssertionError();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while (true) {
            if (this.peekChar() == closeBrace) {
                ++this.pos;
                return result;
            }
            OptionElement option = this.readOption(keyValueSeparator);
            String name = option.name();
            Object value = option.value();
            if (value instanceof OptionElement) {
                LinkedHashMap<String, Object> nested = (LinkedHashMap<String, Object>)result.get(name);
                if (nested == null) {
                    nested = new LinkedHashMap<String, Object>();
                    result.put(name, nested);
                }
                OptionElement valueOption = (OptionElement)value;
                nested.put(valueOption.name(), valueOption.value());
            } else {
                Object previous = result.get(name);
                if (previous == null) {
                    result.put(name, value);
                } else if (previous instanceof List) {
                    this.addToList((List)previous, value);
                } else {
                    ArrayList<Object> newList = new ArrayList<Object>();
                    newList.add(previous);
                    this.addToList(newList, value);
                    result.put(name, newList);
                }
            }
            if (this.peekChar() != ',') continue;
            ++this.pos;
        }
    }

    private void addToList(List<Object> list, Object value) {
        if (value instanceof List) {
            list.addAll((List)value);
        } else {
            list.add(value);
        }
    }

    private List<Object> readList() {
        if (this.readChar() != '[') {
            throw new AssertionError();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (true) {
            if (this.peekChar() == ']') {
                ++this.pos;
                return result;
            }
            result.add(this.readKindAndValue().value());
            char c = this.peekChar();
            if (c == ',') {
                ++this.pos;
                continue;
            }
            if (c != ']') break;
        }
        throw this.unexpected("expected ',' or ']'");
    }

    private RpcElement readRpc(Location location, String documentation) {
        RpcElement.Builder builder = RpcElement.builder(location).name(this.readName()).documentation(documentation);
        if (this.readChar() != '(') {
            throw this.unexpected("expected '('");
        }
        String requestType = this.readDataType();
        builder.requestType(requestType);
        if (this.readChar() != ')') {
            throw this.unexpected("expected ')'");
        }
        if (!this.readWord().equals("returns")) {
            throw this.unexpected("expected 'returns'");
        }
        if (this.readChar() != '(') {
            throw this.unexpected("expected '('");
        }
        String responseType = this.readDataType();
        builder.responseType(responseType);
        if (this.readChar() != ')') {
            throw this.unexpected("expected ')'");
        }
        if (this.peekChar() == '{') {
            ImmutableList.Builder options = ImmutableList.builder();
            ++this.pos;
            while (true) {
                String rpcDocumentation = this.readDocumentation();
                if (this.peekChar() == '}') {
                    ++this.pos;
                    break;
                }
                Object declared = this.readDeclaration(rpcDocumentation, Context.RPC);
                if (!(declared instanceof OptionElement)) continue;
                options.add((Object)((OptionElement)declared));
            }
            builder.options((ImmutableList<OptionElement>)options.build());
        } else if (this.readChar() != ';') {
            throw this.unexpected("expected ';'");
        }
        return builder.build();
    }

    private char readChar() {
        char result = this.peekChar();
        ++this.pos;
        return result;
    }

    private char peekChar() {
        this.skipWhitespace(true);
        if (this.pos == this.data.length) {
            throw this.unexpected("unexpected end of file");
        }
        return this.data[this.pos];
    }

    private String readString() {
        this.skipWhitespace(true);
        return this.peekChar() == '\"' ? this.readQuotedString() : this.readWord();
    }

    private String readQuotedString() {
        if (this.readChar() != '\"') {
            throw new AssertionError();
        }
        StringBuilder result = new StringBuilder();
        while (this.pos < this.data.length) {
            int c;
            if ((c = this.data[this.pos++]) == 34) {
                return result.toString();
            }
            if (c == 92) {
                if (this.pos == this.data.length) {
                    throw this.unexpected("unexpected end of file");
                }
                c = this.data[this.pos++];
                switch (c) {
                    case 97: {
                        c = 7;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 118: {
                        c = 11;
                        break;
                    }
                    case 88: 
                    case 120: {
                        c = this.readNumericEscape(16, 2);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        --this.pos;
                        c = this.readNumericEscape(8, 3);
                        break;
                    }
                }
            }
            result.append((char)c);
            if (c != 10) continue;
            this.newline();
        }
        throw this.unexpected("unterminated string");
    }

    private char readNumericEscape(int radix, int len) {
        int digit;
        int value = -1;
        int endPos = Math.min(this.pos + len, this.data.length);
        while (this.pos < endPos && (digit = this.hexDigit(this.data[this.pos])) != -1 && digit < radix) {
            value = value < 0 ? digit : value * radix + digit;
            ++this.pos;
        }
        if (value < 0) {
            throw this.unexpected("expected a digit after \\x or \\X");
        }
        return (char)value;
    }

    private int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private String readName() {
        String optionName;
        char c = this.peekChar();
        if (c == '(') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
        } else if (c == '[') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ']') {
                throw this.unexpected("expected ']'");
            }
        } else {
            optionName = this.readWord();
        }
        return optionName;
    }

    private String readDataType() {
        String name = this.readWord();
        return this.readDataType(name);
    }

    private String readDataType(String name) {
        if (name.equals("map")) {
            if (this.readChar() != '<') {
                throw this.unexpected("expected '<'");
            }
            String keyType = this.readDataType();
            if (this.readChar() != ',') {
                throw this.unexpected("expected ','");
            }
            String valueType = this.readDataType();
            if (this.readChar() != '>') {
                throw this.unexpected("expected '>'");
            }
            return String.format("map<%s, %s>", keyType, valueType);
        }
        return name;
    }

    private String readWord() {
        char c;
        this.skipWhitespace(true);
        int start = this.pos;
        while (this.pos < this.data.length && ((c = this.data[this.pos]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.')) {
            ++this.pos;
        }
        if (start == this.pos) {
            throw this.unexpected("expected a word");
        }
        return new String(this.data, start, this.pos - start);
    }

    private int readInt() {
        String tag = this.readWord();
        try {
            int radix = 10;
            if (tag.startsWith("0x") || tag.startsWith("0X")) {
                tag = tag.substring("0x".length());
                radix = 16;
            }
            return Integer.valueOf(tag, radix);
        }
        catch (Exception e) {
            throw this.unexpected("expected an integer but was " + tag);
        }
    }

    private String readDocumentation() {
        String result = null;
        while (true) {
            this.skipWhitespace(false);
            if (this.pos == this.data.length || this.data[this.pos] != '/') {
                return result != null ? result : "";
            }
            String comment = this.readComment();
            result = result == null ? comment : result + "\n" + comment;
        }
    }

    private String readComment() {
        int commentType;
        if (this.pos == this.data.length || this.data[this.pos] != '/') {
            throw new AssertionError();
        }
        ++this.pos;
        int n = commentType = this.pos < this.data.length ? this.data[this.pos++] : -1;
        if (commentType == 42) {
            StringBuilder result = new StringBuilder();
            boolean startOfLine = true;
            while (this.pos + 1 < this.data.length) {
                char c = this.data[this.pos];
                if (c == '*' && this.data[this.pos + 1] == '/') {
                    this.pos += 2;
                    return result.toString().trim();
                }
                if (c == '\n') {
                    result.append('\n');
                    this.newline();
                    startOfLine = true;
                } else if (!startOfLine) {
                    result.append(c);
                } else if (c == '*') {
                    if (this.data[this.pos + 1] == ' ') {
                        ++this.pos;
                    }
                    startOfLine = false;
                } else if (!Character.isWhitespace(c)) {
                    result.append(c);
                    startOfLine = false;
                }
                ++this.pos;
            }
            throw this.unexpected("unterminated comment");
        }
        if (commentType == 47) {
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                ++this.pos;
            }
            int start = this.pos;
            while (this.pos < this.data.length) {
                char c;
                if ((c = this.data[this.pos++]) != '\n') continue;
                this.newline();
                break;
            }
            return new String(this.data, start, this.pos - 1 - start);
        }
        throw this.unexpected("unexpected '/'");
    }

    private String tryAppendTrailingDocumentation(String documentation) {
        int end;
        int start;
        block16: {
            char c;
            while (this.pos < this.data.length) {
                char c2 = this.data[this.pos];
                if (c2 == ' ' || c2 == '\t') {
                    ++this.pos;
                    continue;
                }
                if (c2 == '/') {
                    ++this.pos;
                    break;
                }
                return documentation;
            }
            if (this.pos == this.data.length || this.data[this.pos] != '/' && this.data[this.pos] != '*') {
                --this.pos;
                throw this.unexpected("expected '//' or '/*'");
            }
            boolean isStar = this.data[this.pos] == '*';
            ++this.pos;
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                ++this.pos;
            }
            start = this.pos;
            if (isStar) {
                while (true) {
                    if (this.pos == this.data.length || this.data[this.pos] == '\n') {
                        throw this.unexpected("trailing comment must be closed on the same line");
                    }
                    if (this.data[this.pos] == '*' && this.pos + 1 < this.data.length && this.data[this.pos + 1] == '/') {
                        end = this.pos - 1;
                        this.pos += 2;
                        break;
                    }
                    ++this.pos;
                }
                while (this.pos < this.data.length) {
                    if ((c = this.data[this.pos++]) == '\n') {
                        this.newline();
                        break;
                    }
                    if (c == ' ' || c == '\t') continue;
                    throw this.unexpected("no syntax may follow trailing comment");
                }
            } else {
                do {
                    if (this.pos != this.data.length) continue;
                    end = this.pos - 1;
                    break block16;
                } while ((c = this.data[this.pos++]) != '\n');
                this.newline();
                end = this.pos - 2;
            }
        }
        while (end > start && (this.data[end] == ' ' || this.data[end] == '\t')) {
            --end;
        }
        if (end == start) {
            return documentation;
        }
        String trailingDocumentation = new String(this.data, start, end - start + 1);
        if (documentation.isEmpty()) {
            return trailingDocumentation;
        }
        return documentation + '\n' + trailingDocumentation;
    }

    private void skipWhitespace(boolean skipComments) {
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                ++this.pos;
                if (c != '\n') continue;
                this.newline();
                continue;
            }
            if (!skipComments || c != '/') break;
            this.readComment();
        }
    }

    private void newline() {
        ++this.line;
        this.lineStart = this.pos;
    }

    private Location location() {
        return this.location.at(this.line + 1, this.pos - this.lineStart + 1);
    }

    private RuntimeException unexpected(String message) {
        return this.unexpected(this.location(), message);
    }

    private RuntimeException unexpected(Location location, String message) {
        throw new IllegalStateException(String.format("Syntax error in %s: %s", location, message));
    }

    static enum Context {
        FILE,
        MESSAGE,
        ENUM,
        RPC,
        EXTEND,
        SERVICE;


        public boolean permitsPackage() {
            return this == FILE;
        }

        public boolean permitsSyntax() {
            return this == FILE;
        }

        public boolean permitsImport() {
            return this == FILE;
        }

        public boolean permitsExtensions() {
            return this != FILE;
        }

        public boolean permitsRpc() {
            return this == SERVICE;
        }

        public boolean permitsOneOf() {
            return this == MESSAGE;
        }
    }

    static abstract class OptionKindAndValue {
        OptionKindAndValue() {
        }

        static OptionKindAndValue of(OptionElement.Kind kind, Object value) {
            return new AutoValue_ProtoParser_OptionKindAndValue(kind, value);
        }

        abstract OptionElement.Kind kind();

        abstract Object value();
    }
}

