/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import okio.Okio;
import okio.Source;

public final class SchemaLoader {
    private final List<Path> sources = new ArrayList<Path>();
    private final List<String> protos = new ArrayList<String>();

    public SchemaLoader addSource(File file) {
        return this.addSource(file.toPath());
    }

    public SchemaLoader addSource(Path path) {
        this.sources.add(path);
        return this;
    }

    public List<Path> sources() {
        return this.sources;
    }

    public SchemaLoader addProto(String proto) {
        this.protos.add(proto);
        return this;
    }

    public List<String> protos() {
        return this.protos;
    }

    public Schema load() throws IOException {
        if (this.sources.isEmpty()) {
            throw new IllegalStateException("No sources added.");
        }
        try (Closer closer = Closer.create();){
            ArrayList<Path> directories = new ArrayList<Path>();
            for (Path source : this.sources) {
                if (Files.isRegularFile(source, new LinkOption[0])) {
                    FileSystem sourceFs = FileSystems.newFileSystem(source, this.getClass().getClassLoader());
                    closer.register((Closeable)sourceFs);
                    Iterables.addAll(directories, sourceFs.getRootDirectories());
                    continue;
                }
                directories.add(source);
            }
            Schema schema = this.loadFromDirectories(directories);
            return schema;
        }
    }

    private Schema loadFromDirectories(List<Path> directories) throws IOException {
        final ArrayDeque<String> protos = new ArrayDeque<String>(this.protos);
        if (protos.isEmpty()) {
            for (final Path directory : directories) {
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        protos.add(directory.relativize(file).toString());
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        LinkedHashMap<String, ProtoFile> loaded = new LinkedHashMap<String, ProtoFile>();
        while (!protos.isEmpty()) {
            String proto = (String)protos.removeFirst();
            if (loaded.containsKey(proto)) continue;
            ProtoFileElement element = null;
            for (Path directory : directories) {
                Source source = SchemaLoader.source(proto, directory);
                if (source == null) continue;
                try {
                    Location location = Location.get(directory.toString(), proto);
                    String data = Okio.buffer((Source)source).readUtf8();
                    element = ProtoParser.parse(location, data);
                }
                catch (IOException e) {
                    throw new IOException("Failed to load " + proto + " from " + directory, e);
                }
                finally {
                    source.close();
                }
            }
            if (element == null) {
                throw new FileNotFoundException("Failed to locate " + proto + " in " + this.sources);
            }
            ProtoFile protoFile = ProtoFile.get(element);
            loaded.put(proto, protoFile);
            for (String importPath : element.imports()) {
                protos.addLast(importPath);
            }
        }
        return new Linker(loaded.values()).link();
    }

    private static Source source(String proto, Path directory) throws IOException {
        Path resolvedPath = directory.resolve(proto);
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            return Okio.source((Path)resolvedPath, (OpenOption[])new OpenOption[0]);
        }
        return null;
    }
}

