/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ProtoType {
    public static final ProtoType BOOL = new ProtoType(true, "bool");
    public static final ProtoType BYTES = new ProtoType(true, "bytes");
    public static final ProtoType DOUBLE = new ProtoType(true, "double");
    public static final ProtoType FLOAT = new ProtoType(true, "float");
    public static final ProtoType FIXED32 = new ProtoType(true, "fixed32");
    public static final ProtoType FIXED64 = new ProtoType(true, "fixed64");
    public static final ProtoType INT32 = new ProtoType(true, "int32");
    public static final ProtoType INT64 = new ProtoType(true, "int64");
    public static final ProtoType SFIXED32 = new ProtoType(true, "sfixed32");
    public static final ProtoType SFIXED64 = new ProtoType(true, "sfixed64");
    public static final ProtoType SINT32 = new ProtoType(true, "sint32");
    public static final ProtoType SINT64 = new ProtoType(true, "sint64");
    public static final ProtoType STRING = new ProtoType(true, "string");
    public static final ProtoType UINT32 = new ProtoType(true, "uint32");
    public static final ProtoType UINT64 = new ProtoType(true, "uint64");
    private static final Map<String, ProtoType> SCALAR_TYPES;
    private final boolean isScalar;
    private final String string;

    private ProtoType(boolean isScalar, String string) {
        Preconditions.checkNotNull((Object)string, (String)"string == null");
        this.isScalar = isScalar;
        this.string = string;
    }

    public String simpleName() {
        int dot = this.string.lastIndexOf(46);
        return this.string.substring(dot + 1);
    }

    public String enclosingTypeOrPackage() {
        int dot = this.string.lastIndexOf(46);
        return dot == -1 ? null : this.string.substring(0, dot);
    }

    public boolean isScalar() {
        return this.isScalar;
    }

    public static ProtoType get(String enclosingTypeOrPackage, String typeName) {
        return enclosingTypeOrPackage != null ? ProtoType.get(enclosingTypeOrPackage + '.' + typeName) : ProtoType.get(typeName);
    }

    public static ProtoType get(String name) {
        ProtoType scalar = SCALAR_TYPES.get(name);
        if (scalar != null) {
            return scalar;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("unexpected name: " + name);
        }
        return new ProtoType(false, name);
    }

    public ProtoType nestedType(String name) {
        if (this.isScalar) {
            throw new UnsupportedOperationException("scalar cannot have a nested type");
        }
        if (name == null || name.contains(".") || name.isEmpty()) {
            throw new IllegalArgumentException("unexpected name: " + name);
        }
        return new ProtoType(false, this.string + '.' + name);
    }

    public boolean equals(Object o) {
        return o instanceof ProtoType && this.string.equals(((ProtoType)o).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public String toString() {
        return this.string;
    }

    static {
        LinkedHashMap<String, ProtoType> scalarTypes = new LinkedHashMap<String, ProtoType>();
        scalarTypes.put(ProtoType.BOOL.string, BOOL);
        scalarTypes.put(ProtoType.BYTES.string, BYTES);
        scalarTypes.put(ProtoType.DOUBLE.string, DOUBLE);
        scalarTypes.put(ProtoType.FLOAT.string, FLOAT);
        scalarTypes.put(ProtoType.FIXED32.string, FIXED32);
        scalarTypes.put(ProtoType.FIXED64.string, FIXED64);
        scalarTypes.put(ProtoType.INT32.string, INT32);
        scalarTypes.put(ProtoType.INT64.string, INT64);
        scalarTypes.put(ProtoType.SFIXED32.string, SFIXED32);
        scalarTypes.put(ProtoType.SFIXED64.string, SFIXED64);
        scalarTypes.put(ProtoType.SINT32.string, SINT32);
        scalarTypes.put(ProtoType.SINT64.string, SINT64);
        scalarTypes.put(ProtoType.STRING.string, STRING);
        scalarTypes.put(ProtoType.UINT32.string, UINT32);
        scalarTypes.put(ProtoType.UINT64.string, UINT64);
        SCALAR_TYPES = Collections.unmodifiableMap(scalarTypes);
    }
}

