/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal.protoparser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.Util;
import com.squareup.wire.internal.protoparser.AutoValue_EnumConstantElement;
import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.schema.Location;

public abstract class EnumConstantElement {
    public static Builder builder(Location location) {
        return new AutoValue_EnumConstantElement.Builder().location(location).documentation("").options((ImmutableList<OptionElement>)ImmutableList.of());
    }

    public abstract Location location();

    public abstract String name();

    public abstract int tag();

    public abstract String documentation();

    public abstract ImmutableList<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append(this.name()).append(" = ").append(this.tag());
        if (!this.options().isEmpty()) {
            builder.append(" [\n");
            OptionElement.formatOptionList(builder, this.options());
            builder.append(']');
        }
        return builder.append(";\n").toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder name(String var1);

        public Builder tag(int var1);

        public Builder documentation(String var1);

        public Builder options(ImmutableList<OptionElement> var1);

        public EnumConstantElement build();
    }
}

