/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.protoparser.MessageElement;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.Type;
import java.util.Set;

public final class MessageType
extends Type {
    private final Type.Name name;
    private final MessageElement element;
    private final ImmutableList<Field> fields;
    private final ImmutableList<OneOf> oneOfs;
    private final ImmutableList<Type> nestedTypes;
    private final ImmutableList<Extensions> extensionsList;
    private final Options options;

    MessageType(Type.Name name, MessageElement element, ImmutableList<Field> fields, ImmutableList<OneOf> oneOfs, ImmutableList<Type> nestedTypes, ImmutableList<Extensions> extensionsList, Options options) {
        this.name = name;
        this.element = element;
        this.fields = fields;
        this.oneOfs = oneOfs;
        this.nestedTypes = nestedTypes;
        this.extensionsList = extensionsList;
        this.options = (Options)Preconditions.checkNotNull((Object)options);
    }

    @Override
    public Location location() {
        return this.element.location();
    }

    @Override
    public Type.Name name() {
        return this.name;
    }

    @Override
    public String documentation() {
        return this.element.documentation();
    }

    @Override
    public ImmutableList<Type> nestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public Options options() {
        return this.options;
    }

    public ImmutableList<Field> fields() {
        return this.fields;
    }

    public ImmutableList<Field> getRequiredFields() {
        ImmutableList.Builder required = ImmutableList.builder();
        for (Field field : this.fieldsAndOneOfFields()) {
            if (!field.isRequired()) continue;
            required.add((Object)field);
        }
        return required.build();
    }

    public ImmutableList<Field> fieldsAndOneOfFields() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(this.fields);
        for (OneOf oneOf : this.oneOfs) {
            result.addAll(oneOf.fields());
        }
        return result.build();
    }

    public Field field(String name) {
        for (Field field : this.fields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public Field field(int tag) {
        for (Field field : this.fields) {
            if (field.tag() != tag) continue;
            return field;
        }
        return null;
    }

    public ImmutableList<OneOf> oneOfs() {
        return this.oneOfs;
    }

    public ImmutableList<Extensions> extensions() {
        return this.extensionsList;
    }

    @Override
    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateTags((Iterable<Field>)this.fieldsAndOneOfFields(), linker.extensions(this.name()));
        linker.validateEnumConstantNameUniqueness((Iterable<Type>)this.nestedTypes);
        for (Field field : this.fieldsAndOneOfFields()) {
            field.validate(linker, false);
        }
        for (Type type : this.nestedTypes) {
            type.validate(linker);
        }
        for (Extensions extensions : this.extensionsList) {
            extensions.validate(linker);
        }
    }

    @Override
    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Field field : this.fields) {
            field.link(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.link(linker);
        }
        for (Type type : this.nestedTypes) {
            type.link(linker);
        }
    }

    @Override
    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Type type : this.nestedTypes) {
            type.linkOptions(linker);
        }
        for (Field field : this.fields) {
            field.linkOptions(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.linkOptions(linker);
        }
        this.options.link(linker);
    }

    @Override
    Type retainAll(Set<String> identifiers) {
        ImmutableList.Builder retainedNestedTypesBuilder = ImmutableList.builder();
        for (Type nestedType : this.nestedTypes) {
            Type retainedNestedType = nestedType.retainAll(identifiers);
            if (retainedNestedType == null) continue;
            retainedNestedTypesBuilder.add((Object)retainedNestedType);
        }
        ImmutableList retainedNestedTypes = retainedNestedTypesBuilder.build();
        if (identifiers.contains(this.name.toString()) || !retainedNestedTypes.isEmpty()) {
            return new MessageType(this.name, this.element, this.fields, this.oneOfs, (ImmutableList<Type>)retainedNestedTypes, this.extensionsList, this.options);
        }
        return null;
    }
}

