/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.internal.protoparser.RpcElement;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.Type;
import java.util.List;

public final class Rpc {
    private final String packageName;
    private final RpcElement element;
    private final Options options;
    private Type.Name requestType;
    private Type.Name responseType;

    Rpc(String packageName, RpcElement element) {
        this.packageName = packageName;
        this.element = element;
        this.options = new Options(Type.Name.METHOD_OPTIONS, packageName, (List<OptionElement>)element.options());
    }

    public Location location() {
        return this.element.location();
    }

    public String packageName() {
        return this.packageName;
    }

    public String name() {
        return this.element.name();
    }

    public String documentation() {
        return this.element.documentation();
    }

    public Type.Name requestType() {
        return this.requestType;
    }

    public Type.Name responseType() {
        return this.responseType;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.requestType = linker.resolveNamedType(this.packageName, this.element.requestType());
        this.responseType = linker.resolveNamedType(this.packageName, this.element.responseType());
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        this.options.link(linker);
    }
}

