/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;

final class Pruner {
    final Set<String> marks = new LinkedHashSet<String>();
    final Deque<String> queue = new ArrayDeque<String>();

    Pruner() {
    }

    public Schema retainRoots(Schema schema, Collection<String> roots) {
        String name;
        if (roots.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.marks.isEmpty()) {
            throw new IllegalStateException();
        }
        for (String s : roots) {
            this.mark(s);
        }
        for (ProtoFile protoFile : schema.protoFiles()) {
            for (Extend extend : protoFile.extendList()) {
                this.markExtend(extend);
            }
            this.markOptions(protoFile.options());
        }
        while ((name = this.queue.poll()) != null) {
            if (Type.Name.getScalar(name) != null) continue;
            Type type = schema.getType(name);
            if (type != null) {
                this.markType(type);
                continue;
            }
            Service service = schema.getService(name);
            if (service != null) {
                this.markService(service);
                continue;
            }
            int hash = name.indexOf(35);
            if (hash != -1) {
                Rpc rpc;
                String serviceName = name.substring(0, hash);
                String rpcName = name.substring(hash + 1);
                Service partialService = schema.getService(serviceName);
                if (partialService != null && (rpc = partialService.rpc(rpcName)) != null) {
                    this.markOptions(partialService.options());
                    this.markRpc(rpc);
                    continue;
                }
            }
            throw new IllegalArgumentException("Unexpected type: " + name);
        }
        ImmutableList.Builder retained = ImmutableList.builder();
        for (ProtoFile protoFile : schema.protoFiles()) {
            retained.add((Object)protoFile.retainAll(this.marks));
        }
        return new Schema((Iterable<ProtoFile>)retained.build());
    }

    private void mark(Type.Name typeName) {
        this.mark(typeName.toString());
    }

    private void mark(String identifier) {
        if (this.marks.add(identifier)) {
            this.queue.add(identifier);
        }
    }

    private void markExtend(Extend extend) {
        this.mark(extend.type());
        this.markFields(extend.fields());
    }

    private void markType(Type type) {
        this.markOptions(type.options());
        Type.Name enclosingTypeName = type.name().enclosingTypeName();
        if (enclosingTypeName != null) {
            this.mark(enclosingTypeName);
        }
        for (Type nestedType : type.nestedTypes()) {
            this.mark(nestedType.name());
        }
        if (type instanceof MessageType) {
            this.markMessage((MessageType)type);
        } else if (type instanceof EnumType) {
            this.markEnum((EnumType)type);
        }
    }

    private void markMessage(MessageType message) {
        this.markFields(message.fields());
        for (OneOf oneOf : message.oneOfs()) {
            this.markFields(oneOf.fields());
        }
    }

    private void markEnum(EnumType wireEnum) {
        this.markOptions(wireEnum.options());
        for (EnumConstant constant : wireEnum.constants()) {
            this.markOptions(constant.options());
        }
    }

    private void markFields(ImmutableList<Field> fields) {
        for (Field field : fields) {
            this.markField(field);
        }
    }

    private void markField(Field field) {
        this.markOptions(field.options());
        this.mark(field.type());
    }

    private void markOptions(Options options) {
        for (Field field : options.fields()) {
            this.markField(field);
        }
    }

    private void markService(Service service) {
        this.markOptions(service.options());
        for (Rpc rpc : service.rpcs()) {
            this.markRpc(rpc);
        }
    }

    private void markRpc(Rpc rpc) {
        this.markOptions(rpc.options());
        this.mark(rpc.requestType());
        this.mark(rpc.responseType());
    }
}

