/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;

public final class Util {
    public static final int MIN_TAG_VALUE = 1;
    public static final int MAX_TAG_VALUE = 0x1FFFFFFF;
    private static final int RESERVED_TAG_VALUE_START = 19000;
    private static final int RESERVED_TAG_VALUE_END = 19999;

    public static void appendDocumentation(StringBuilder builder, String documentation) {
        if (documentation.isEmpty()) {
            return;
        }
        for (String line : documentation.split("\n")) {
            builder.append("// ").append(line).append('\n');
        }
    }

    public static void appendIndented(StringBuilder builder, String value) {
        for (String line : value.split("\n")) {
            builder.append("  ").append(line).append('\n');
        }
    }

    public static boolean isValidTag(int value) {
        return value >= 1 && value < 19000 || value > 19999 && value <= 0x1FFFFFFF;
    }

    public static <T> ImmutableList<T> concatenate(List<T> a, T b) {
        return ImmutableList.builder().addAll(a).add(b).build();
    }

    private Util() {
    }
}

