/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.Syntax;
import com.squareup.wire.internal._PlatformKt;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.SyntaxRules;
import com.squareup.wire.schema.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001e\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H&J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H&J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcom/squareup/wire/schema/SyntaxRules;", "", "validateDefaultValue", "", "hasDefaultValue", "", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "validateExtension", "protoType", "Lcom/squareup/wire/schema/ProtoType;", "validateEnumConstants", "constants", "", "Lcom/squareup/wire/schema/EnumConstant;", "validateTypeReference", "type", "Lcom/squareup/wire/schema/Type;", "isPackedByDefault", "label", "Lcom/squareup/wire/schema/Field$Label;", "getEncodeMode", "Lcom/squareup/wire/schema/Field$EncodeMode;", "isPacked", "isOneOf", "jsonName", "", "name", "declaredJsonName", "Companion", "wire-schema"})
public interface SyntaxRules {
    @NotNull
    public static final Companion Companion = com.squareup.wire.schema.SyntaxRules$Companion.$$INSTANCE;

    public void validateDefaultValue(boolean var1, @NotNull ErrorCollector var2);

    public void validateExtension(@NotNull ProtoType var1, @NotNull ErrorCollector var2);

    public void validateEnumConstants(@NotNull List<EnumConstant> var1, @NotNull ErrorCollector var2);

    public void validateTypeReference(@Nullable Type var1, @NotNull ErrorCollector var2);

    public boolean isPackedByDefault(@NotNull ProtoType var1, @Nullable Field.Label var2);

    @NotNull
    public Field.EncodeMode getEncodeMode(@NotNull ProtoType var1, @Nullable Field.Label var2, boolean var3, boolean var4);

    @NotNull
    public String jsonName(@NotNull String var1, @Nullable String var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/squareup/wire/schema/SyntaxRules$Companion;", "", "<init>", "()V", "get", "Lcom/squareup/wire/schema/SyntaxRules;", "syntax", "Lcom/squareup/wire/Syntax;", "PROTO_2_SYNTAX_RULES", "getPROTO_2_SYNTAX_RULES$wire_schema", "()Lcom/squareup/wire/schema/SyntaxRules;", "PROTO_3_SYNTAX_RULES", "getPROTO_3_SYNTAX_RULES$wire_schema", "wire-schema"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final SyntaxRules PROTO_2_SYNTAX_RULES;
        @NotNull
        private static final SyntaxRules PROTO_3_SYNTAX_RULES;

        private Companion() {
        }

        @NotNull
        public final SyntaxRules get(@Nullable Syntax syntax) {
            SyntaxRules syntaxRules;
            Syntax syntax2 = syntax;
            switch (syntax2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[syntax2.ordinal()]) {
                case 1: {
                    syntaxRules = PROTO_3_SYNTAX_RULES;
                    break;
                }
                case -1: 
                case 2: {
                    syntaxRules = PROTO_2_SYNTAX_RULES;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return syntaxRules;
        }

        @NotNull
        public final SyntaxRules getPROTO_2_SYNTAX_RULES$wire_schema() {
            return PROTO_2_SYNTAX_RULES;
        }

        @NotNull
        public final SyntaxRules getPROTO_3_SYNTAX_RULES$wire_schema() {
            return PROTO_3_SYNTAX_RULES;
        }

        static {
            $$INSTANCE = new Companion();
            PROTO_2_SYNTAX_RULES = new SyntaxRules(){

                public void validateDefaultValue(boolean hasDefaultValue, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                }

                public void validateExtension(ProtoType protoType, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                }

                public void validateEnumConstants(List<EnumConstant> constants, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter(constants, (String)"constants");
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                }

                public void validateTypeReference(Type type, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                }

                public boolean isPackedByDefault(ProtoType type, Field.Label label) {
                    Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                    return false;
                }

                public Field.EncodeMode getEncodeMode(ProtoType protoType, Field.Label label, boolean isPacked, boolean isOneOf) {
                    Field.EncodeMode encodeMode;
                    Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
                    Field.Label label2 = label;
                    switch (label2 == null ? -1 : PROTO_2_SYNTAX_RULES.WhenMappings.$EnumSwitchMapping$0[label2.ordinal()]) {
                        case 1: {
                            if (isPacked) {
                                encodeMode = Field.EncodeMode.PACKED;
                                break;
                            }
                            encodeMode = Field.EncodeMode.REPEATED;
                            break;
                        }
                        case 2: {
                            encodeMode = Field.EncodeMode.NULL_IF_ABSENT;
                            break;
                        }
                        case 3: {
                            encodeMode = Field.EncodeMode.REQUIRED;
                            break;
                        }
                        case -1: 
                        case 4: {
                            if (protoType.isMap()) {
                                encodeMode = Field.EncodeMode.MAP;
                                break;
                            }
                            encodeMode = Field.EncodeMode.NULL_IF_ABSENT;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return encodeMode;
                }

                public String jsonName(String name, String declaredJsonName) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    String string = declaredJsonName;
                    if (string == null) {
                        string = name;
                    }
                    return string;
                }
            };
            PROTO_3_SYNTAX_RULES = new SyntaxRules(){

                public void validateDefaultValue(boolean hasDefaultValue, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                    if (hasDefaultValue) {
                        errors.plusAssign("user-defined default values are not permitted in proto3");
                    }
                }

                public void validateExtension(ProtoType protoType, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                    if (!ArraysKt.contains((Object[])Options.Companion.getGOOGLE_PROTOBUF_OPTION_TYPES(), (Object)protoType)) {
                        errors.plusAssign("extensions are not allowed in proto3");
                    }
                }

                public void validateEnumConstants(List<EnumConstant> constants, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter(constants, (String)"constants");
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                    if (constants.isEmpty() || ((EnumConstant)CollectionsKt.first(constants)).getTag() != 0) {
                        errors.plusAssign("missing a zero value at the first element in proto3");
                    }
                }

                public void validateTypeReference(Type type, ErrorCollector errors) {
                    Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
                    if (type == null) {
                        return;
                    }
                    if (!(type instanceof EnumType)) {
                        return;
                    }
                    if (((EnumType)type).getSyntax() == Syntax.PROTO_3) {
                        return;
                    }
                    errors.plusAssign("Proto2 enums cannot be referenced in a proto3 message");
                }

                public boolean isPackedByDefault(ProtoType type, Field.Label label) {
                    Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                    return label == Field.Label.REPEATED && ProtoType.Companion.getNUMERIC_SCALAR_TYPES$wire_schema().contains(type);
                }

                public Field.EncodeMode getEncodeMode(ProtoType protoType, Field.Label label, boolean isPacked, boolean isOneOf) {
                    Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
                    if (label == Field.Label.REPEATED) {
                        return isPacked ? Field.EncodeMode.PACKED : Field.EncodeMode.REPEATED;
                    }
                    if (protoType.isMap()) {
                        return Field.EncodeMode.MAP;
                    }
                    if (isOneOf) {
                        return Field.EncodeMode.NULL_IF_ABSENT;
                    }
                    if (label == Field.Label.OPTIONAL) {
                        return Field.EncodeMode.NULL_IF_ABSENT;
                    }
                    return Field.EncodeMode.OMIT_IDENTITY;
                }

                public String jsonName(String name, String declaredJsonName) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    String string = declaredJsonName;
                    if (string == null) {
                        string = _PlatformKt.camelCase$default((String)name, (boolean)false, (int)2, null);
                    }
                    return string;
                }
            };
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Syntax.values().length];
                try {
                    nArray[Syntax.PROTO_3.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Syntax.PROTO_2.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

