/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.CoreLoaderKt;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Profile;
import com.squareup.wire.schema.ProfileLoader;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.RootKt;
import com.squareup.wire.schema.RootsKt;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.CommonSchemaLoaderKt;
import com.squareup.wire.schema.internal.ProfileFileElement;
import com.squareup.wire.schema.internal.TypeConfigElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0010\u0010%\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\f2\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020)0\fJ\u0006\u0010+\u001a\u00020,J\u0013\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0000\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020$H\u0016J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00101\u001a\u000202H\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020)0\fH\u0002J\r\u00105\u001a\u00020'H\u0000\u00a2\u0006\u0002\b6J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020,H\u0016J\u001e\u0010;\u001a\u00020'2\u0006\u0010:\u001a\u00020,2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\fH\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010\u00162\u0006\u0010?\u001a\u00020\u0016H\u0002J)\u0010@\u001a\b\u0012\u0004\u0012\u00020)0A2\u0006\u00109\u001a\u00020$2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020)0\fH\u0000\u00a2\u0006\u0002\bCR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R*\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R \u0010\"\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/squareup/wire/schema/internal/CommonSchemaLoader;", "Lcom/squareup/wire/schema/Loader;", "Lcom/squareup/wire/schema/ProfileLoader;", "fileSystem", "Lokio/FileSystem;", "<init>", "(Lokio/FileSystem;)V", "enclosing", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "(Lcom/squareup/wire/schema/internal/CommonSchemaLoader;Lcom/squareup/wire/schema/ErrorCollector;)V", "sourcePathRoots", "", "Lcom/squareup/wire/schema/Root;", "protoPathRoots", "permitPackageCycles", "", "getPermitPackageCycles", "()Z", "setPermitPackageCycles", "(Z)V", "opaqueTypes", "Lcom/squareup/wire/schema/ProtoType;", "getOpaqueTypes", "()Ljava/util/List;", "setOpaqueTypes", "(Ljava/util/List;)V", "loadExhaustively", "getLoadExhaustively", "setLoadExhaustively", "value", "Lcom/squareup/wire/schema/ProtoFile;", "sourcePathFiles", "getSourcePathFiles", "baseToRoots", "", "", "withErrors", "initRoots", "", "sourcePath", "Lcom/squareup/wire/schema/Location;", "protoPath", "loadSchema", "Lcom/squareup/wire/schema/Schema;", "loadSourcePathFiles", "loadSourcePathFiles$wire_schema", "load", "path", "protoFilePath", "Lcom/squareup/wire/schema/ProtoFilePath;", "allRoots", "locations", "reportLoadingErrors", "reportLoadingErrors$wire_schema", "loadProfile", "Lcom/squareup/wire/schema/Profile;", "name", "schema", "validate", "profileFiles", "Lcom/squareup/wire/schema/internal/ProfileFileElement;", "importedType", "type", "locationsToCheck", "", "input", "locationsToCheck$wire_schema", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nCommonSchemaLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonSchemaLoader.kt\ncom/squareup/wire/schema/internal/CommonSchemaLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1563#2:291\n1634#2,3:292\n*S KotlinDebug\n*F\n+ 1 CommonSchemaLoader.kt\ncom/squareup/wire/schema/internal/CommonSchemaLoader\n*L\n199#1:291\n199#1:292,3\n*E\n"})
public final class CommonSchemaLoader
implements Loader,
ProfileLoader {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ErrorCollector errors;
    @Nullable
    private List<? extends Root> sourcePathRoots;
    @Nullable
    private List<? extends Root> protoPathRoots;
    private boolean permitPackageCycles;
    @NotNull
    private List<ProtoType> opaqueTypes;
    private boolean loadExhaustively;
    @NotNull
    private List<ProtoFile> sourcePathFiles;
    @NotNull
    private final Map<String, List<Root>> baseToRoots;

    public final boolean getPermitPackageCycles() {
        return this.permitPackageCycles;
    }

    public final void setPermitPackageCycles(boolean bl) {
        this.permitPackageCycles = bl;
    }

    @NotNull
    public final List<ProtoType> getOpaqueTypes() {
        return this.opaqueTypes;
    }

    public final void setOpaqueTypes(@NotNull List<ProtoType> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.opaqueTypes = list;
    }

    public final boolean getLoadExhaustively() {
        return this.loadExhaustively;
    }

    public final void setLoadExhaustively(boolean bl) {
        this.loadExhaustively = bl;
    }

    @NotNull
    public final List<ProtoFile> getSourcePathFiles() {
        return this.sourcePathFiles;
    }

    public CommonSchemaLoader(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.opaqueTypes = CollectionsKt.emptyList();
        this.fileSystem = fileSystem;
        this.errors = new ErrorCollector();
        this.sourcePathRoots = null;
        this.protoPathRoots = null;
        this.sourcePathFiles = CollectionsKt.emptyList();
        this.baseToRoots = new LinkedHashMap();
    }

    public CommonSchemaLoader(@NotNull CommonSchemaLoader enclosing, @NotNull ErrorCollector errors) {
        Intrinsics.checkNotNullParameter((Object)enclosing, (String)"enclosing");
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        this.opaqueTypes = CollectionsKt.emptyList();
        this.fileSystem = enclosing.fileSystem;
        this.errors = errors;
        this.sourcePathRoots = enclosing.sourcePathRoots;
        this.protoPathRoots = enclosing.protoPathRoots;
        this.sourcePathFiles = enclosing.sourcePathFiles;
        this.baseToRoots = enclosing.baseToRoots;
    }

    @Override
    @NotNull
    public Loader withErrors(@NotNull ErrorCollector errors) {
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        return new CommonSchemaLoader(this, errors);
    }

    public final void initRoots(@NotNull List<Location> sourcePath, @NotNull List<Location> protoPath) {
        Intrinsics.checkNotNullParameter(sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter(protoPath, (String)"protoPath");
        if (!(this.sourcePathRoots == null && this.protoPathRoots == null)) {
            throw new IllegalStateException("Check failed.");
        }
        this.sourcePathRoots = this.allRoots(sourcePath);
        this.protoPathRoots = this.allRoots(protoPath);
    }

    public static /* synthetic */ void initRoots$default(CommonSchemaLoader commonSchemaLoader, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        commonSchemaLoader.initRoots(list, list2);
    }

    @NotNull
    public final Schema loadSchema() throws IOException {
        this.sourcePathFiles = this.loadSourcePathFiles$wire_schema();
        Linker linker = new Linker(this, this.errors, this.permitPackageCycles, this.loadExhaustively, this.opaqueTypes);
        Schema result = linker.link((Iterable<ProtoFile>)this.sourcePathFiles);
        this.errors.throwIfNonEmpty();
        return result;
    }

    @NotNull
    public final List<ProtoFile> loadSourcePathFiles$wire_schema() throws IOException {
        if (!(this.sourcePathRoots != null && this.protoPathRoots != null)) {
            boolean bl = false;
            String string = "call initRoots() before calling loadSourcePathFiles()";
            throw new IllegalStateException(string.toString());
        }
        List result = new ArrayList();
        List<? extends Root> list = this.sourcePathRoots;
        Intrinsics.checkNotNull(list);
        for (Root root : list) {
            for (ProtoFilePath locationAndPath : root.allProtoFiles()) {
                ((Collection)result).add(this.load(locationAndPath));
            }
        }
        if (result.isEmpty()) {
            this.errors.plusAssign("no sources");
        }
        this.errors.throwIfNonEmpty();
        return result;
    }

    @Override
    @NotNull
    public ProtoFile load(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ProtoFilePath loadFrom = null;
        List<? extends Root> list = this.protoPathRoots;
        Intrinsics.checkNotNull(list);
        for (Root root : list) {
            ProtoFilePath locationAndPath;
            if (root.resolve(path) == null) continue;
            if (loadFrom != null) {
                this.errors.plusAssign(path + " is ambiguous:\n  " + locationAndPath + "\n  " + loadFrom);
                continue;
            }
            loadFrom = locationAndPath;
        }
        if (loadFrom != null) {
            return this.load(loadFrom);
        }
        if (CoreLoaderKt.isWireRuntimeProto(path)) {
            return CoreLoader.INSTANCE.load(path);
        }
        StringBuilder stringBuilder = new StringBuilder().append("\n          |unable to find ").append(path).append("\n          |  searching ");
        List<? extends Root> list2 = this.protoPathRoots;
        Intrinsics.checkNotNull(list2);
        StringBuilder stringBuilder2 = stringBuilder.append(list2.size()).append(" proto paths:\n          |    ");
        List<? extends Root> list3 = this.protoPathRoots;
        Intrinsics.checkNotNull(list3);
        this.errors.plusAssign(StringsKt.trimMargin$default((String)stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"\n    ", null, null, (int)0, null, null, (int)62, null)).append("\n    ").toString(), null, (int)1, null));
        return ProtoFile.Companion.get(ProtoFileElement.Companion.empty(path));
    }

    private final ProtoFile load(ProtoFilePath protoFilePath) {
        if (CoreLoaderKt.isWireRuntimeProto(protoFilePath.getLocation())) {
            return CoreLoader.INSTANCE.load(protoFilePath.getLocation().getPath());
        }
        ProtoFile protoFile = RootsKt.parse(protoFilePath);
        String importPath = CommonSchemaLoaderKt.importPath(protoFile, protoFilePath.getLocation());
        if (((CharSequence)protoFilePath.getLocation().getBase()).length() == 0 && !Intrinsics.areEqual((Object)protoFilePath.getLocation().getPath(), (Object)importPath) && !StringsKt.endsWith$default((String)protoFilePath.getLocation().getPath(), (String)('/' + importPath), (boolean)false, (int)2, null)) {
            this.errors.plusAssign("expected " + protoFilePath.getLocation().getPath() + " to have a path ending with " + importPath);
        }
        return protoFile;
    }

    private final List<Root> allRoots(List<Location> locations) {
        List result = new ArrayList();
        for (Location location : locations) {
            try {
                CollectionsKt.addAll((Collection)result, (Iterable)RootKt.roots(location, this.fileSystem, this.baseToRoots));
            }
            catch (IllegalArgumentException e) {
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                this.errors.plusAssign(string);
            }
        }
        return result;
    }

    public final void reportLoadingErrors$wire_schema() {
        this.errors.throwIfNonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Profile loadProfile(@NotNull String name, @NotNull Schema schema) {
        Iterator<Location> $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Iterable $this$map$iv = schema.getProtoFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            ProtoFile protoFile = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLocation());
        }
        List allLocations = (List)destination$iv$iv;
        Set<Location> locationsToCheck = this.locationsToCheck$wire_schema(name, allLocations);
        List profileElements = new ArrayList();
        for (Location location : locationsToCheck) {
            List<Root> roots;
            if (this.baseToRoots.get(location.getBase()) == null) continue;
            for (Root root : roots) {
                ProtoFilePath resolved;
                if (root.resolve(location.getPath()) == null) continue;
                ((Collection)profileElements).add(resolved.parseProfile());
            }
        }
        Profile profile = new Profile(profileElements);
        this.validate(schema, profileElements);
        return profile;
    }

    private final void validate(Schema schema, List<ProfileFileElement> profileFiles) {
        for (ProfileFileElement profileFile : profileFiles) {
            for (TypeConfigElement typeConfig : profileFile.getTypeConfigs()) {
                ProtoType type;
                Type resolvedType;
                if (this.importedType(ProtoType.Companion.get(typeConfig.getType())) == null || (resolvedType = schema.getType(type)) == null) continue;
                String requiredImport = resolvedType.getLocation().getPath();
                if (profileFile.getImports().contains(requiredImport)) continue;
                this.errors.plusAssign(typeConfig.getLocation().getPath() + " needs to import " + requiredImport + " (" + typeConfig.getLocation() + ')');
            }
        }
        this.errors.throwIfNonEmpty();
    }

    private final ProtoType importedType(ProtoType type) {
        ProtoType type2 = type;
        if (type2.isMap()) {
            ProtoType protoType = type2.getValueType();
            Intrinsics.checkNotNull((Object)protoType);
            type2 = protoType;
        }
        return type2.isScalar() ? null : type2;
    }

    @NotNull
    public final Set<Location> locationsToCheck$wire_schema(@NotNull String name, @NotNull List<Location> input) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        ArrayDeque queue = new ArrayDeque((Collection)input);
        Set result = new LinkedHashSet();
        while ((Location)queue.removeFirstOrNull() != null) {
            String parentPath;
            Location protoLocation;
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)protoLocation.getPath(), (String)"/", (int)0, (boolean)false, (int)6, null);
            Intrinsics.checkNotNullExpressionValue((Object)protoLocation.getPath().substring(0, lastSlash + 1), (String)"substring(...)");
            Location profileLocation = Location.copy$default(protoLocation, null, parentPath + name + ".wire", 0, 0, 13, null);
            if (!result.add(profileLocation) || !(((CharSequence)parentPath).length() > 0)) continue;
            ((Collection)queue).add(Location.copy$default(protoLocation, null, StringsKt.dropLast((String)parentPath, (int)1), 0, 0, 13, null));
        }
        return result;
    }
}

