/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.UtilJVMKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u0003J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0015H\u0002J\u0018\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00102\u0006\u0010\"\u001a\u00020\u0001H\u0002J&\u0010#\u001a\u00020\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u000bj\b\u0012\u0004\u0012\u00020\u0001`\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006("}, d2={"Lcom/squareup/wire/schema/Pruner;", "", "schema", "Lcom/squareup/wire/schema/Schema;", "pruningRules", "Lcom/squareup/wire/schema/PruningRules;", "<init>", "(Lcom/squareup/wire/schema/Schema;Lcom/squareup/wire/schema/PruningRules;)V", "marks", "Lcom/squareup/wire/schema/MarkSet;", "queue", "Ljava/util/Queue;", "Lcom/squareup/wire/schema/internal/MutableQueue;", "Ljava/util/Queue;", "prune", "retainAll", "", "Lcom/squareup/wire/schema/ProtoFile;", "retainImports", "protoFiles", "markRoots", "", "protoFile", "markRootsIncludingNested", "type", "Lcom/squareup/wire/schema/Type;", "protoType", "Lcom/squareup/wire/schema/ProtoType;", "isRetainedVersion", "", "protoMember", "Lcom/squareup/wire/schema/ProtoMember;", "markReachable", "reachableObjects", "root", "addOptions", "options", "", "result", "", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nPruner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pruner.kt\ncom/squareup/wire/schema/Pruner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1563#2:275\n1634#2,3:276\n1563#2:279\n1634#2,3:280\n1#3:283\n*S KotlinDebug\n*F\n+ 1 Pruner.kt\ncom/squareup/wire/schema/Pruner\n*L\n50#1:275\n50#1:276,3\n57#1:279\n57#1:280,3\n*E\n"})
public final class Pruner {
    @NotNull
    private final Schema schema;
    @NotNull
    private final PruningRules pruningRules;
    @NotNull
    private final MarkSet marks;
    @NotNull
    private final Queue<Object> queue;

    public Pruner(@NotNull Schema schema, @NotNull PruningRules pruningRules) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)pruningRules, (String)"pruningRules");
        this.schema = schema;
        this.pruningRules = pruningRules;
        this.marks = new MarkSet(this.pruningRules);
        this.queue = UtilJVMKt.mutableQueueOf();
    }

    @NotNull
    public final Schema prune() {
        this.markRoots();
        this.markReachable();
        List<ProtoFile> retained = this.retainImports(this.retainAll(this.schema, this.marks));
        return new Schema((Iterable<ProtoFile>)retained);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProtoFile> retainAll(Schema schema, MarkSet marks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = schema.getProtoFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void protoFile;
            ProtoFile protoFile2 = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(protoFile.retainAll(schema, marks));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProtoFile> retainImports(List<ProtoFile> protoFiles) {
        void $this$mapTo$iv$iv;
        Schema schema = new Schema((Iterable<ProtoFile>)protoFiles);
        Iterable $this$map$iv = protoFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void protoFile;
            ProtoFile protoFile2 = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(protoFile.retainImports(schema));
        }
        return (List)destination$iv$iv;
    }

    private final void markRoots() {
        for (ProtoFile protoFile : this.schema.getProtoFiles()) {
            this.markRoots(protoFile);
        }
    }

    private final void markRoots(ProtoFile protoFile) {
        for (Type type : protoFile.getTypes()) {
            this.markRootsIncludingNested(type);
        }
        for (Service service : protoFile.getServices()) {
            this.markRoots(service.type());
        }
    }

    private final void markRootsIncludingNested(Type type) {
        this.markRoots(type.getType());
        for (Type nested : type.getNestedTypes()) {
            this.markRootsIncludingNested(nested);
        }
    }

    private final void markRoots(ProtoType protoType) {
        if (this.pruningRules.isRoot(protoType)) {
            this.marks.root(protoType);
            this.queue.add(protoType);
            return;
        }
        for (Object reachable : this.reachableObjects(protoType)) {
            if (!(reachable instanceof ProtoMember) || !this.isRetainedVersion((ProtoMember)reachable) || !this.pruningRules.isRoot((ProtoMember)reachable)) continue;
            this.marks.root((ProtoMember)reachable);
            this.marks.mark(((ProtoMember)reachable).getType());
            this.queue.add(reachable);
        }
    }

    private final boolean isRetainedVersion(ProtoMember protoMember) {
        boolean bl;
        String member = protoMember.getMember();
        Type type = this.schema.getType(protoMember.getType());
        if (type instanceof MessageType) {
            Field field;
            Field field2 = ((MessageType)type).field(member);
            if (field2 == null) {
                field2 = ((MessageType)type).extensionField(member);
            }
            if ((field = field2) != null) {
                bl = this.pruningRules.isFieldRetainedVersion(field.getOptions());
            } else {
                OneOf oneOf = ((MessageType)type).oneOf(member);
                Intrinsics.checkNotNull((Object)oneOf);
                bl = this.pruningRules.isFieldRetainedVersion(oneOf.getOptions());
            }
        } else if (type instanceof EnumType) {
            EnumConstant enumConstant = ((EnumType)type).constant(member);
            Intrinsics.checkNotNull((Object)enumConstant);
            EnumConstant enumConstant2 = enumConstant;
            bl = this.pruningRules.isEnumConstantRetainedVersion(enumConstant2.getOptions());
        } else {
            bl = true;
        }
        return bl;
    }

    private final void markReachable() {
        while (this.queue.poll() != null) {
            Object root;
            List<Object> reachableMembers = this.reachableObjects(root);
            for (Object reachable : reachableMembers) {
                Object object = reachable;
                if (object instanceof ProtoType) {
                    if (root instanceof ProtoMember) {
                        if (!this.marks.mark((ProtoType)reachable, (ProtoMember)root)) continue;
                        this.queue.add(reachable);
                        continue;
                    }
                    if (!this.marks.mark((ProtoType)reachable)) continue;
                    this.queue.add(reachable);
                    continue;
                }
                if (object instanceof ProtoMember) {
                    if (!this.isRetainedVersion((ProtoMember)reachable) || !this.marks.mark((ProtoMember)reachable)) continue;
                    this.queue.add(reachable);
                    continue;
                }
                if (object == null) continue;
                throw new IllegalStateException("unexpected object: " + reachable);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Object> reachableObjects(Object root) {
        List result = new ArrayList();
        Options options = null;
        Options fileOptions = null;
        Object object = root;
        if (object instanceof ProtoMember) {
            String member = ((ProtoMember)root).getMember();
            Type type = this.schema.getType(((ProtoMember)root).getType());
            Service service = this.schema.getService(((ProtoMember)root).getType());
            if (type instanceof MessageType) {
                Field field;
                Field field2 = ((MessageType)type).field(member);
                if (field2 == null) {
                    field2 = ((MessageType)type).extensionField(member);
                }
                if ((field = field2) != null) {
                    result.add(field.getType());
                    options = field.getOptions();
                } else {
                    OneOf oneOf = ((MessageType)type).oneOf(member);
                    if (oneOf == null) {
                        boolean bl = false;
                        String string = "unexpected member: " + member;
                        throw new IllegalStateException(string.toString());
                    }
                    OneOf oneOf2 = oneOf;
                    options = oneOf2.getOptions();
                }
            } else if (type instanceof EnumType) {
                EnumConstant enumConstant = ((EnumType)type).constant(member);
                if (enumConstant == null) {
                    throw new IllegalStateException("unexpected member: " + member);
                }
                EnumConstant constant = enumConstant;
                options = constant.getOptions();
            } else {
                if (service == null) throw new IllegalStateException("unexpected member: " + member);
                Rpc rpc = service.rpc(member);
                if (rpc == null) {
                    throw new IllegalStateException("unexpected rpc: " + member);
                }
                Rpc rpc2 = rpc;
                result.add(rpc2.getRequestType());
                result.add(rpc2.getResponseType());
                options = rpc2.getOptions();
            }
        } else {
            if (!(object instanceof ProtoType)) throw new IllegalStateException("unexpected root: " + root);
            if (((ProtoType)root).isMap()) {
                result.add(((ProtoType)root).getKeyType());
                result.add(((ProtoType)root).getValueType());
                return result;
            }
            if (((ProtoType)root).isScalar()) {
                return result;
            }
            Type type = this.schema.getType((ProtoType)root);
            Service service = this.schema.getService((ProtoType)root);
            ProtoFile protoFile = this.schema.protoFile((ProtoType)root);
            Intrinsics.checkNotNull((Object)protoFile);
            fileOptions = protoFile.getOptions();
            if (type instanceof MessageType) {
                options = ((MessageType)type).getOptions();
                for (Field field : ((MessageType)type).getDeclaredFields()) {
                    result.add(ProtoMember.Companion.get((ProtoType)root, field.getName()));
                }
                for (Field field : ((MessageType)type).getExtensionFields()) {
                    result.add(ProtoMember.Companion.get((ProtoType)root, field.getQualifiedName()));
                }
                for (OneOf oneOf : ((MessageType)type).getOneOfs()) {
                    result.add(ProtoMember.Companion.get((ProtoType)root, oneOf.getName()));
                    for (Field field : oneOf.getFields()) {
                        result.add(ProtoMember.Companion.get((ProtoType)root, field.getName()));
                    }
                }
            } else if (type instanceof EnumType) {
                options = ((EnumType)type).getOptions();
                for (EnumConstant constant : ((EnumType)type).getConstants()) {
                    result.add(ProtoMember.Companion.get(((EnumType)type).getType(), constant.getName()));
                }
            } else if (type instanceof EnclosingType) {
                options = ((EnclosingType)type).getOptions();
            } else {
                if (service == null) throw new IllegalStateException("unexpected type: " + root);
                options = service.options();
                for (Rpc rpc : service.rpcs()) {
                    result.add(ProtoMember.Companion.get(service.type(), rpc.getName()));
                }
            }
        }
        this.addOptions(options.fields(this.pruningRules).values(), result);
        if (fileOptions == null) return result;
        this.addOptions(fileOptions.fields(this.pruningRules).values(), result);
        return result;
    }

    private final void addOptions(Collection<ProtoMember> options, List<Object> result) {
        for (ProtoMember member : options) {
            if (!this.schema.isExtensionField(member)) {
                result.add(member.getType());
            }
            result.add(member);
        }
    }
}

