/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\f*\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u001a\u0010\u001b\u001a\u00020\u0017*\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001a\u0010\u001b\u001a\u00020\u0017*\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001a\u0010\u001b\u001a\u00020\u0017*\u00020\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001a\u0010\u001b\u001a\u00020\u0017*\u00020\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001a\u0010\u001b\u001a\u00020\u0017*\u00020\u001f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001a\u0010 \u001a\u00020\u0017*\u00020\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001a\u0010 \u001a\u00020\u0017*\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u0014\u0010!\u001a\u00020\f*\u00020\f2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\b\u0010#\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00120\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/squareup/wire/schema/internal/TypeMover;", "", "oldSchema", "Lcom/squareup/wire/schema/Schema;", "moves", "", "Lcom/squareup/wire/schema/internal/TypeMover$Move;", "<init>", "(Lcom/squareup/wire/schema/Schema;Ljava/util/List;)V", "pathToFile", "", "", "Lcom/squareup/wire/schema/ProtoFile;", "sourceAndTargetPaths", "", "typeToPath", "Lcom/squareup/wire/schema/ProtoType;", "pathToTypes", "", "errors", "", "move", "rebuildIndexes", "", "fixImports", "getType", "Lcom/squareup/wire/schema/Type;", "collectReferencedTypes", "sink", "Lcom/squareup/wire/schema/Service;", "Lcom/squareup/wire/schema/Rpc;", "Lcom/squareup/wire/schema/Field;", "collectDeclaredTypes", "emptyCopy", "path", "checkForErrors", "Move", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nTypeMover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeMover.kt\ncom/squareup/wire/schema/internal/TypeMover\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1202#2,2:239\n1230#2,4:241\n360#2,7:245\n1557#2:252\n1628#2,3:253\n2632#2,3:256\n1755#2,3:259\n230#2,2:262\n1#3:264\n*S KotlinDebug\n*F\n+ 1 TypeMover.kt\ncom/squareup/wire/schema/internal/TypeMover\n*L\n38#1:239,2\n38#1:241,4\n69#1:245,7\n84#1:252\n84#1:253,3\n108#1:256,3\n143#1:259,3\n167#1:262,2\n*E\n"})
public final class TypeMover {
    @NotNull
    private final Schema oldSchema;
    @NotNull
    private final List<Move> moves;
    @NotNull
    private final Map<String, ProtoFile> pathToFile;
    @NotNull
    private final Set<String> sourceAndTargetPaths;
    @NotNull
    private final Map<ProtoType, String> typeToPath;
    @NotNull
    private final Map<String, Set<ProtoType>> pathToTypes;
    @NotNull
    private final List<String> errors;

    /*
     * WARNING - void declaration
     */
    public TypeMover(@NotNull Schema oldSchema, @NotNull List<Move> moves) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)oldSchema, (String)"oldSchema");
        Intrinsics.checkNotNullParameter(moves, (String)"moves");
        this.oldSchema = oldSchema;
        this.moves = moves;
        Iterable iterable = this.oldSchema.getProtoFiles();
        TypeMover typeMover = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ProtoFile protoFile = (ProtoFile)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getLocation().getPath(), element$iv$iv);
        }
        typeMover.pathToFile = MapsKt.toMutableMap((Map)destination$iv$iv);
        this.sourceAndTargetPaths = new LinkedHashSet();
        this.typeToPath = new LinkedHashMap();
        this.pathToTypes = new LinkedHashMap();
        this.errors = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Schema move() {
        void $this$mapTo$iv$iv;
        ProtoFile targetProtoFile;
        Object targetPath;
        if (this.moves.isEmpty()) {
            return this.oldSchema;
        }
        for (Move move : this.moves) {
            if (this.oldSchema.protoFile(move.getType()) != null) continue;
            ((Collection)this.errors).add("cannot move " + move.getType() + ", it isn't in this schema");
        }
        this.checkForErrors();
        this.rebuildIndexes();
        for (Move move : this.moves) {
            int n;
            ProtoFile oldSourceProtoFile;
            List sourceTypes;
            String sourcePath;
            block7: {
                Intrinsics.checkNotNull((Object)this.typeToPath.remove(move.getType()));
                targetPath = move.getTargetPath();
                Intrinsics.checkNotNull((Object)this.pathToFile.get(sourcePath));
                List $this$indexOfFirst$iv = sourceTypes = CollectionsKt.toMutableList((Collection)oldSourceProtoFile.getTypes());
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Type it = (Type)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getType(), (Object)move.getType())) {
                        n = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int typeIndex = n;
            Type movedType = (Type)sourceTypes.remove(typeIndex);
            this.pathToFile.put(sourcePath, ProtoFile.copy$default(oldSourceProtoFile, null, null, null, null, null, sourceTypes, null, null, null, null, 991, null));
            ProtoFile protoFile = this.pathToFile.get(targetPath);
            if (protoFile == null) {
                protoFile = this.emptyCopy(oldSourceProtoFile, (String)targetPath);
            }
            targetProtoFile = protoFile;
            this.pathToFile.put((String)targetPath, ProtoFile.copy$default(targetProtoFile, null, null, null, null, null, CollectionsKt.plus((Collection)targetProtoFile.getTypes(), (Object)movedType), null, null, null, null, 991, null));
            ((Collection)this.sourceAndTargetPaths).add(sourcePath);
            ((Collection)this.sourceAndTargetPaths).add(targetPath);
        }
        this.rebuildIndexes();
        Iterable $this$map$iv = this.pathToFile.values();
        boolean $i$f$map = false;
        targetPath = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            targetProtoFile = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fixImports((ProtoFile)it));
        }
        List updatedProtoFiles = (List)destination$iv$iv;
        this.checkForErrors();
        return new Schema(updatedProtoFiles);
    }

    private final void rebuildIndexes() {
        this.pathToTypes.clear();
        this.typeToPath.clear();
        for (Map.Entry<String, ProtoFile> entry : this.pathToFile.entrySet()) {
            String path = entry.getKey();
            ProtoFile protoFile = entry.getValue();
            Set declaredTypes = new LinkedHashSet();
            this.collectDeclaredTypes(protoFile, (Set<ProtoType>)declaredTypes);
            this.pathToTypes.put(path, declaredTypes);
            for (ProtoType protoType : declaredTypes) {
                this.typeToPath.put(protoType, path);
            }
        }
    }

    private final ProtoFile fixImports(ProtoFile $this$fixImports) {
        if (!this.sourceAndTargetPaths.contains($this$fixImports.getLocation().getPath())) {
            boolean bl;
            block15: {
                Iterable $this$none$iv = this.sourceAndTargetPaths;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String string = (String)element$iv;
                        boolean bl2 = false;
                        if (!($this$fixImports.getImports().contains(string) || $this$fixImports.getPublicImports().contains(string))) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return $this$fixImports;
            }
        }
        Set referencedTypes = new LinkedHashSet();
        this.collectReferencedTypes($this$fixImports, (Set<ProtoType>)referencedTypes);
        Set definitelyNeed = new LinkedHashSet();
        Set possiblyDrop = new LinkedHashSet();
        for (Move move : this.moves) {
            ProtoFile oldSchemaFile;
            if (referencedTypes.contains(move.getType())) {
                ((Collection)definitelyNeed).add(move.getType());
            } else {
                ((Collection)possiblyDrop).add(move.getType());
            }
            if (this.oldSchema.protoFile(move.getType()) == null) {
                throw new IllegalStateException(("no source file for " + move.getType()).toString());
            }
            if (Intrinsics.areEqual((Object)oldSchemaFile.getLocation().getPath(), (Object)$this$fixImports.getLocation().getPath())) {
                this.collectReferencedTypes(this.getType(move), (Set<ProtoType>)possiblyDrop);
            }
            if (!Intrinsics.areEqual((Object)$this$fixImports.getLocation().getPath(), (Object)move.getTargetPath())) continue;
            this.collectReferencedTypes(this.getType(move), (Set<ProtoType>)definitelyNeed);
        }
        Set obsoleteImports = new LinkedHashSet();
        for (ProtoType type : possiblyDrop) {
            boolean bl;
            String path;
            block16: {
                Set<ProtoType> otherTypesInFile;
                if (this.typeToPath.get(type) == null) continue;
                Intrinsics.checkNotNull(this.pathToTypes.get(path));
                Iterable $this$any$iv = otherTypesInFile;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ProtoType it = (ProtoType)element$iv;
                        boolean bl3 = false;
                        if (!referencedTypes.contains(it)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            obsoleteImports.add(path);
        }
        List list = CollectionsKt.toMutableList((Collection)$this$fixImports.getImports());
        List newPublicImports = CollectionsKt.toMutableList((Collection)$this$fixImports.getPublicImports());
        for (ProtoType requiredType : definitelyNeed) {
            String path;
            if (this.typeToPath.get(requiredType) == null || Intrinsics.areEqual((Object)path, (Object)$this$fixImports.getLocation().getPath()) || list.contains(path) || $this$fixImports.getPublicImports().contains(path)) continue;
            ((Collection)list).add(path);
        }
        list.removeAll(obsoleteImports);
        newPublicImports.removeAll(obsoleteImports);
        return ProtoFile.copy$default($this$fixImports, null, list, newPublicImports, null, null, null, null, null, null, null, 1017, null);
    }

    private final Type getType(Move move) {
        Object element$iv2;
        block1: {
            ProtoFile protoFile = this.pathToFile.get(move.getTargetPath());
            Intrinsics.checkNotNull((Object)protoFile);
            Iterable $this$first$iv = protoFile.getTypes();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Type it = (Type)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)move.getType())) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Type)element$iv2;
    }

    private final void collectReferencedTypes(ProtoFile $this$collectReferencedTypes, Set<ProtoType> sink) {
        for (Type type : $this$collectReferencedTypes.getTypes()) {
            this.collectReferencedTypes(type, sink);
        }
        for (Service service : $this$collectReferencedTypes.getServices()) {
            this.collectReferencedTypes(service, sink);
        }
    }

    private final void collectReferencedTypes(Type $this$collectReferencedTypes, Set<ProtoType> sink) {
        for (Type type : $this$collectReferencedTypes.getNestedTypes()) {
            this.collectReferencedTypes(type, sink);
        }
        if ($this$collectReferencedTypes instanceof MessageType) {
            for (Field field : ((MessageType)$this$collectReferencedTypes).getFieldsAndOneOfFields()) {
                this.collectReferencedTypes(field, sink);
            }
        }
    }

    private final void collectReferencedTypes(Service $this$collectReferencedTypes, Set<ProtoType> sink) {
        for (Rpc rpc : $this$collectReferencedTypes.rpcs()) {
            this.collectReferencedTypes(rpc, sink);
        }
    }

    private final void collectReferencedTypes(Rpc $this$collectReferencedTypes, Set<ProtoType> sink) {
        Collection collection = sink;
        ProtoType protoType = $this$collectReferencedTypes.getRequestType();
        Intrinsics.checkNotNull((Object)protoType);
        collection.add(protoType);
        Collection collection2 = sink;
        ProtoType protoType2 = $this$collectReferencedTypes.getResponseType();
        Intrinsics.checkNotNull((Object)protoType2);
        collection2.add(protoType2);
    }

    private final void collectReferencedTypes(Field $this$collectReferencedTypes, Set<ProtoType> sink) {
        Collection collection = sink;
        ProtoType protoType = $this$collectReferencedTypes.getType();
        Intrinsics.checkNotNull((Object)protoType);
        collection.add(protoType);
    }

    private final void collectDeclaredTypes(ProtoFile $this$collectDeclaredTypes, Set<ProtoType> sink) {
        for (Type type : $this$collectDeclaredTypes.getTypes()) {
            this.collectDeclaredTypes(type, sink);
        }
    }

    private final void collectDeclaredTypes(Type $this$collectDeclaredTypes, Set<ProtoType> sink) {
        sink.add($this$collectDeclaredTypes.getType());
        for (Type type : $this$collectDeclaredTypes.getNestedTypes()) {
            this.collectDeclaredTypes(type, sink);
        }
    }

    private final ProtoFile emptyCopy(ProtoFile $this$emptyCopy, String path) {
        return ProtoFile.copy$default($this$emptyCopy, Location.copy$default($this$emptyCopy.getLocation(), null, path, 0, 0, 13, null), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, null, 792, null);
    }

    private final void checkForErrors() {
        if (!this.errors.isEmpty()) {
            boolean bl = false;
            String string = CollectionsKt.joinToString$default((Iterable)this.errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/schema/internal/TypeMover$Move;", "", "type", "Lcom/squareup/wire/schema/ProtoType;", "targetPath", "", "<init>", "(Lcom/squareup/wire/schema/ProtoType;Ljava/lang/String;)V", "getType", "()Lcom/squareup/wire/schema/ProtoType;", "getTargetPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "wire-schema"})
    public static final class Move {
        @NotNull
        private final ProtoType type;
        @NotNull
        private final String targetPath;

        public Move(@NotNull ProtoType type, @NotNull String targetPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            this.type = type;
            this.targetPath = targetPath;
        }

        @NotNull
        public final ProtoType getType() {
            return this.type;
        }

        @NotNull
        public final String getTargetPath() {
            return this.targetPath;
        }

        @NotNull
        public final ProtoType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.targetPath;
        }

        @NotNull
        public final Move copy(@NotNull ProtoType type, @NotNull String targetPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            return new Move(type, targetPath);
        }

        public static /* synthetic */ Move copy$default(Move move, ProtoType protoType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                protoType = move.type;
            }
            if ((n & 2) != 0) {
                string = move.targetPath;
            }
            return move.copy(protoType, string);
        }

        @NotNull
        public String toString() {
            return "Move(type=" + this.type + ", targetPath=" + this.targetPath + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.targetPath.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Move)) {
                return false;
            }
            Move move = (Move)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)move.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetPath, (Object)move.targetPath);
        }
    }
}

