/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.internal._PlatformKt;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.SchemaEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004@ABCB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010.\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020 0/2\b\u00100\u001a\u0004\u0018\u00010\"2\f\u00101\u001a\b\u0012\u0004\u0012\u00020(02H\u0002J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0012J\u0018\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u00020(2\u0006\u00108\u001a\u00020\u0001H\u0002J*\u00109\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u00010/2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00010/H\u0002J\u0018\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020#2\u0006\u00108\u001a\u00020\u0001H\u0002J\u000e\u0010>\u001a\u0004\u0018\u00010\u0001*\u00020?H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00020\"*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0018\u0010&\u001a\u00020'*\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0018\u0010+\u001a\u00020'*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006D"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder;", "", "schema", "Lcom/squareup/wire/schema/Schema;", "(Lcom/squareup/wire/schema/Schema;)V", "enumConstantEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$Encoder;", "Lcom/squareup/wire/schema/EnumConstant;", "enumEncoder", "Lcom/squareup/wire/schema/EnumType;", "enumOptionsProtoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "enumValueOptionsProtoAdapter", "extensionRangeEncoder", "fieldEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "fieldOptionsProtoAdapter", "fileEncoder", "Lcom/squareup/wire/schema/ProtoFile;", "fileOptionsProtoAdapter", "messageEncoder", "Lcom/squareup/wire/schema/MessageType;", "messageOptionsProtoAdapter", "oneOfEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedOneOf;", "rpcEncoder", "Lcom/squareup/wire/schema/Rpc;", "rpcOptionsProtoAdapter", "serviceEncoder", "Lcom/squareup/wire/schema/Service;", "serviceOptionsProtoAdapter", "syntheticMapEntryEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$SyntheticMapEntry;", "dotName", "", "Lcom/squareup/wire/schema/ProtoType;", "getDotName", "(Lcom/squareup/wire/schema/ProtoType;)Ljava/lang/String;", "labelTag", "", "Lcom/squareup/wire/schema/Field;", "getLabelTag", "(Lcom/squareup/wire/schema/Field;)I", "typeTag", "getTypeTag", "(Lcom/squareup/wire/schema/ProtoType;)I", "collectSyntheticMapEntries", "", "enclosingTypeOrPackage", "fields", "", "encode", "Lokio/ByteString;", "protoFile", "toJson", "field", "value", "toJsonMap", "map", "Lcom/squareup/wire/schema/ProtoMember;", "toJsonSingle", "type", "toJsonOptions", "Lcom/squareup/wire/schema/Options;", "EncodedField", "EncodedOneOf", "Encoder", "SyntheticMapEntry", "wire-schema"})
public final class SchemaEncoder {
    @NotNull
    private final Schema schema;
    @NotNull
    private final ProtoAdapter<Object> fileOptionsProtoAdapter;
    @NotNull
    private final ProtoAdapter<Object> messageOptionsProtoAdapter;
    @NotNull
    private final ProtoAdapter<Object> fieldOptionsProtoAdapter;
    @NotNull
    private final ProtoAdapter<Object> enumOptionsProtoAdapter;
    @NotNull
    private final ProtoAdapter<Object> enumValueOptionsProtoAdapter;
    @NotNull
    private final ProtoAdapter<Object> serviceOptionsProtoAdapter;
    @NotNull
    private final ProtoAdapter<Object> rpcOptionsProtoAdapter;
    @NotNull
    private final Encoder<ProtoFile> fileEncoder;
    @NotNull
    private final Encoder<MessageType> messageEncoder;
    @NotNull
    private final Encoder<SyntheticMapEntry> syntheticMapEntryEncoder;
    @NotNull
    private final Encoder<EncodedField> fieldEncoder;
    @NotNull
    private final Encoder<EncodedOneOf> oneOfEncoder;
    @NotNull
    private final Encoder<EnumType> enumEncoder;
    @NotNull
    private final Encoder<Object> extensionRangeEncoder;
    @NotNull
    private final Encoder<EnumConstant> enumConstantEncoder;
    @NotNull
    private final Encoder<Service> serviceEncoder;
    @NotNull
    private final Encoder<Rpc> rpcEncoder;

    public SchemaEncoder(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
        this.fileOptionsProtoAdapter = this.schema.protoAdapter(Options.FILE_OPTIONS.toString(), false);
        this.messageOptionsProtoAdapter = this.schema.protoAdapter(Options.MESSAGE_OPTIONS.toString(), false);
        this.fieldOptionsProtoAdapter = this.schema.protoAdapter(Options.FIELD_OPTIONS.toString(), false);
        this.enumOptionsProtoAdapter = this.schema.protoAdapter(Options.ENUM_OPTIONS.toString(), false);
        this.enumValueOptionsProtoAdapter = this.schema.protoAdapter(Options.ENUM_VALUE_OPTIONS.toString(), false);
        this.serviceOptionsProtoAdapter = this.schema.protoAdapter(Options.SERVICE_OPTIONS.toString(), false);
        this.rpcOptionsProtoAdapter = this.schema.protoAdapter(Options.METHOD_OPTIONS.toString(), false);
        this.fileEncoder = new Encoder<ProtoFile>(this){
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void encode(@NotNull ReverseProtoWriter writer, @NotNull ProtoFile value) {
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Collection<EncodedField> collection;
                void $this$map$iv;
                ProtoAdapter protoAdapter;
                ReverseProtoWriter reverseProtoWriter;
                int n;
                Object object;
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (value.getSyntax() != Syntax.PROTO_2) {
                    object = value.getSyntax();
                    ProtoAdapter.STRING.encodeWithTag(writer, 12, (Object)(object == null ? null : object.toString()));
                }
                SchemaEncoder.access$getFileOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 8, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
                for (Extend extend : CollectionsKt.reversed((Iterable)value.getExtendList())) {
                    void $this$mapTo$iv$iv;
                    Iterable iterable = extend.getFields();
                    SchemaEncoder schemaEncoder = this.this$0;
                    n = 7;
                    reverseProtoWriter = writer;
                    protoAdapter = SchemaEncoder.access$getFieldEncoder$p(this.this$0).asRepeated();
                    boolean $i$f$map = false;
                    Iterator<T> iterator = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Field field = (Field)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Syntax syntax = value.getSyntax();
                        ProtoType protoType = extend.getType();
                        Intrinsics.checkNotNull((Object)protoType);
                        EncodedField encodedField = new EncodedField(syntax, (Field)it, null, SchemaEncoder.access$getDotName(schemaEncoder, protoType), null, 20, null);
                        collection.add(encodedField);
                    }
                    collection = (List)destination$iv$iv;
                    protoAdapter.encodeWithTag(reverseProtoWriter, n, (Object)collection);
                }
                SchemaEncoder.access$getServiceEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 6, value.getServices());
                object = value.getTypes();
                n = 5;
                reverseProtoWriter = writer;
                protoAdapter = SchemaEncoder.access$getEnumEncoder$p(this.this$0).asRepeated();
                boolean $i$f$filterIsInstance = false;
                $this$map$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EnumType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
                protoAdapter.encodeWithTag(reverseProtoWriter, n, (Object)collection);
                $this$filterIsInstance$iv = value.getTypes();
                n = 4;
                reverseProtoWriter = writer;
                protoAdapter = SchemaEncoder.access$getMessageEncoder$p(this.this$0).asRepeated();
                $i$f$filterIsInstance = false;
                $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof MessageType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
                protoAdapter.encodeWithTag(reverseProtoWriter, n, collection);
                ProtoAdapter.STRING.asRepeated().encodeWithTag(writer, 3, value.getImports());
                ProtoAdapter.STRING.encodeWithTag(writer, 2, (Object)value.getPackageName());
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getLocation().getPath());
            }
        };
        this.messageEncoder = new Encoder<MessageType>(this){
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void encode(@NotNull ReverseProtoWriter writer, @NotNull MessageType value) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                void $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2;
                SyntheticMapEntry syntheticMap;
                Object object;
                Collection collection;
                Object $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoFile protoFile = SchemaEncoder.access$getSchema$p(this.this$0).protoFile(value.getType());
                Intrinsics.checkNotNull((Object)protoFile);
                Syntax syntax = protoFile.getSyntax();
                Map syntheticMaps = SchemaEncoder.access$collectSyntheticMapEntries(this.this$0, value.getType().toString(), value.getDeclaredFields());
                boolean bl = false;
                List encodedOneOfs = new ArrayList<E>();
                for (OneOf oneOf22 : value.getOneOfs()) {
                    Iterable $this$map$iv = oneOf22.getFields();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        T item$iv$iv = iterator.next();
                        Field field = (Field)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        object = new EncodedField(syntax, (Field)it, null, null, encodedOneOfs.size(), 12, null);
                        collection.add(object);
                    }
                    List oneOfFields = (List)destination$iv$iv;
                    encodedOneOfs.add(new EncodedOneOf(oneOf22.getName(), oneOfFields));
                }
                boolean oneOf22 = false;
                List encodedFields = new ArrayList<E>();
                for (Field field : value.getDeclaredFields()) {
                    ProtoType protoType;
                    syntheticMap = (SyntheticMapEntry)syntheticMaps.get(field);
                    $this$mapTo$iv$iv = syntheticMap;
                    if ($this$mapTo$iv$iv == null) {
                        ProtoType protoType2 = field.getType();
                        protoType = protoType2;
                        Intrinsics.checkNotNull((Object)protoType2);
                    } else {
                        protoType = ((SyntheticMapEntry)$this$mapTo$iv$iv).getFieldType();
                    }
                    EncodedField encodedField = new EncodedField(syntax, field, protoType, null, null, 24, null);
                    if (encodedField.isProto3Optional()) {
                        encodedField = EncodedField.copy$default(encodedField, null, null, null, null, encodedOneOfs.size(), 15, null);
                        $this$mapTo$iv$iv = encodedOneOfs;
                        EncodedOneOf destination$iv$iv = new EncodedOneOf(Intrinsics.stringPlus((String)"_", (Object)field.getName()), null, 2, null);
                        $i$f$mapTo = false;
                        $this$mapTo$iv$iv.add(destination$iv$iv);
                    }
                    $this$mapTo$iv$iv = encodedFields;
                    boolean destination$iv$iv = false;
                    $this$mapTo$iv$iv.add(encodedField);
                }
                SchemaEncoder.access$getMessageOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 7, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
                SchemaEncoder.access$getOneOfEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 8, (Object)encodedOneOfs);
                Iterable oneOf22 = value.getExtensionsList();
                int n = 5;
                object = writer;
                collection = SchemaEncoder.access$getExtensionRangeEncoder$p(this.this$0).asRepeated();
                boolean $i$f$flatMap = false;
                syntheticMap = $this$flatMap$iv2;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv2) {
                    Extensions it = (Extensions)element$iv$iv;
                    boolean bl3 = false;
                    Iterable list$iv$iv = it.getValues();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List list = (List)destination$iv$iv;
                collection.encodeWithTag((ReverseProtoWriter)object, n, list);
                $this$flatMap$iv2 = value.getNestedTypes();
                n = 4;
                object = writer;
                collection = SchemaEncoder.access$getEnumEncoder$p(this.this$0).asRepeated();
                boolean $i$f$filterIsInstance = false;
                $this$flatMapTo$iv$iv2 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EnumType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                collection.encodeWithTag((ReverseProtoWriter)object, n, list);
                SchemaEncoder.access$getSyntheticMapEntryEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 3, (Object)CollectionsKt.toList((Iterable)syntheticMaps.values()));
                $this$filterIsInstance$iv = value.getNestedTypes();
                n = 3;
                object = writer;
                collection = this.asRepeated();
                $i$f$filterIsInstance = false;
                $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof MessageType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                collection.encodeWithTag((ReverseProtoWriter)object, n, list);
                Iterable $i$f$filterIsInstance2 = encodedOneOfs;
                collection = encodedFields;
                boolean $i$f$flatMap2 = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$flatMapTo2 = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    EncodedOneOf it = (EncodedOneOf)element$iv$iv;
                    boolean bl4 = false;
                    Iterable list$iv$iv = it.getFields();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                object = (List)destination$iv$iv2;
                Function1[] function1Array = new Function1[]{messageEncoder.encode.fieldsAndOneOfFields.2.INSTANCE, messageEncoder.encode.fieldsAndOneOfFields.3.INSTANCE};
                List fieldsAndOneOfFields2 = CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
                SchemaEncoder.access$getFieldEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 2, (Object)fieldsAndOneOfFields2);
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getType().getSimpleName());
            }
        };
        this.syntheticMapEntryEncoder = new Encoder<SyntheticMapEntry>(this){
            @NotNull
            private final syntheticMapEntryEncoder.keyFieldEncoder.1 keyFieldEncoder;
            @NotNull
            private final syntheticMapEntryEncoder.valueFieldEncoder.1 valueFieldEncoder;
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
                this.keyFieldEncoder = new Encoder<SyntheticMapEntry>(this.this$0){
                    final /* synthetic */ SchemaEncoder this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void encode(@NotNull ReverseProtoWriter writer, @NotNull SyntheticMapEntry value) {
                        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        ProtoAdapter.STRING.encodeWithTag(writer, 10, (Object)"key");
                        if (!value.getKeyType().isScalar()) {
                            ProtoAdapter.STRING.encodeWithTag(writer, 6, (Object)SchemaEncoder.access$getDotName(this.this$0, value.getKeyType()));
                        }
                        ProtoAdapter.INT32.encodeWithTag(writer, 5, (Object)SchemaEncoder.access$getTypeTag(this.this$0, value.getKeyType()));
                        ProtoAdapter.INT32.encodeWithTag(writer, 4, (Object)1);
                        ProtoAdapter.INT32.encodeWithTag(writer, 3, (Object)1);
                        ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)"key");
                    }
                };
                this.valueFieldEncoder = new Encoder<SyntheticMapEntry>(this.this$0){
                    final /* synthetic */ SchemaEncoder this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void encode(@NotNull ReverseProtoWriter writer, @NotNull SyntheticMapEntry value) {
                        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        ProtoAdapter.STRING.encodeWithTag(writer, 10, (Object)"value");
                        if (!value.getValueType().isScalar()) {
                            ProtoAdapter.STRING.encodeWithTag(writer, 6, (Object)SchemaEncoder.access$getDotName(this.this$0, value.getValueType()));
                        }
                        ProtoAdapter.INT32.encodeWithTag(writer, 5, (Object)SchemaEncoder.access$getTypeTag(this.this$0, value.getValueType()));
                        ProtoAdapter.INT32.encodeWithTag(writer, 4, (Object)1);
                        ProtoAdapter.INT32.encodeWithTag(writer, 3, (Object)2);
                        ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)"value");
                    }
                };
            }

            @NotNull
            public final syntheticMapEntryEncoder.keyFieldEncoder.1 getKeyFieldEncoder() {
                return this.keyFieldEncoder;
            }

            @NotNull
            public final syntheticMapEntryEncoder.valueFieldEncoder.1 getValueFieldEncoder() {
                return this.valueFieldEncoder;
            }

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull SyntheticMapEntry value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                SchemaEncoder.access$getMessageOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 7, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"map_entry", (Object)true)));
                this.valueFieldEncoder.encodeWithTag(writer, 2, value);
                this.keyFieldEncoder.encodeWithTag(writer, 2, value);
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
            }
        };
        this.fieldEncoder = new Encoder<EncodedField>(this){
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull EncodedField value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.INT32.encodeWithTag(writer, 9, (Object)value.getOneOfIndex());
                if (value.isProto3Optional()) {
                    ProtoAdapter.BOOL.encodeWithTag(writer, 17, (Object)true);
                }
                SchemaEncoder.access$getFieldOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 8, SchemaEncoder.access$toJsonOptions(this.this$0, value.getField().getOptions()));
                if (value.getSyntax() == Syntax.PROTO_2 && !Intrinsics.areEqual((Object)value.getField().getJsonName(), (Object)value.getField().getName())) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 10, (Object)value.getField().getJsonName());
                }
                ProtoAdapter.STRING.encodeWithTag(writer, 7, (Object)value.getField().getDefault());
                ProtoAdapter.STRING.encodeWithTag(writer, 2, (Object)value.getExtendee());
                if (!value.getType().isScalar()) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 6, (Object)SchemaEncoder.access$getDotName(this.this$0, value.getType()));
                }
                ProtoType protoType = value.getField().getType();
                Intrinsics.checkNotNull((Object)protoType);
                ProtoAdapter.INT32.encodeWithTag(writer, 5, (Object)SchemaEncoder.access$getTypeTag(this.this$0, protoType));
                ProtoAdapter.INT32.encodeWithTag(writer, 4, (Object)SchemaEncoder.access$getLabelTag(this.this$0, value.getField()));
                ProtoAdapter.INT32.encodeWithTag(writer, 3, (Object)value.getField().getTag());
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getField().getName());
            }
        };
        this.oneOfEncoder = new Encoder<EncodedOneOf>(){

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull EncodedOneOf value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
            }
        };
        this.enumEncoder = new Encoder<EnumType>(this){
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull EnumType value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                SchemaEncoder.access$getEnumOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 3, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
                SchemaEncoder.access$getEnumConstantEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 2, value.getConstants());
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
            }
        };
        this.extensionRangeEncoder = new Encoder<Object>(){

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull Object value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Object object = value;
                if (object instanceof IntRange) {
                    ProtoAdapter.INT32.encodeWithTag(writer, 2, (Object)(((IntRange)value).getLast() + 1));
                    ProtoAdapter.INT32.encodeWithTag(writer, 1, (Object)((IntRange)value).getFirst());
                } else if (object instanceof Integer) {
                    ProtoAdapter.INT32.encodeWithTag(writer, 2, (Object)(((Number)value).intValue() + 1));
                    ProtoAdapter.INT32.encodeWithTag(writer, 1, value);
                } else {
                    String string = Intrinsics.stringPlus((String)"unexpected extension range: ", (Object)value);
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        };
        this.enumConstantEncoder = new Encoder<EnumConstant>(this){
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull EnumConstant value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                SchemaEncoder.access$getEnumValueOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 3, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
                ProtoAdapter.INT32.encodeWithTag(writer, 2, (Object)value.getTag());
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
            }
        };
        this.serviceEncoder = new Encoder<Service>(this){
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull Service value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                SchemaEncoder.access$getServiceOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 3, SchemaEncoder.access$toJsonOptions(this.this$0, value.options()));
                SchemaEncoder.access$getRpcEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 2, value.rpcs());
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.name());
            }
        };
        this.rpcEncoder = new Encoder<Rpc>(this){
            final /* synthetic */ SchemaEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public void encode(@NotNull ReverseProtoWriter writer, @NotNull Rpc value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (value.getResponseStreaming()) {
                    ProtoAdapter.BOOL.encodeWithTag(writer, 6, (Object)value.getResponseStreaming());
                }
                if (value.getRequestStreaming()) {
                    ProtoAdapter.BOOL.encodeWithTag(writer, 5, (Object)value.getRequestStreaming());
                }
                SchemaEncoder.access$getRpcOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 4, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
                ProtoType protoType = value.getResponseType();
                Intrinsics.checkNotNull((Object)protoType);
                ProtoAdapter.STRING.encodeWithTag(writer, 3, (Object)SchemaEncoder.access$getDotName(this.this$0, protoType));
                ProtoType protoType2 = value.getRequestType();
                Intrinsics.checkNotNull((Object)protoType2);
                ProtoAdapter.STRING.encodeWithTag(writer, 2, (Object)SchemaEncoder.access$getDotName(this.this$0, protoType2));
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
            }
        };
    }

    @NotNull
    public final ByteString encode(@NotNull ProtoFile protoFile) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])this.fileEncoder.encode(protoFile), (int)0, (int)0, (int)3, null);
    }

    private final Map<Field, SyntheticMapEntry> collectSyntheticMapEntries(String enclosingTypeOrPackage, List<Field> fields) {
        boolean bl = false;
        Map result = new LinkedHashMap();
        for (Field field : fields) {
            ProtoType fieldType;
            Intrinsics.checkNotNull((Object)field.getType());
            if (!fieldType.isMap()) continue;
            String name = Intrinsics.stringPlus((String)_PlatformKt.camelCase((String)field.getName(), (boolean)true), (Object)"Entry");
            Map map = result;
            ProtoType protoType = fieldType.getKeyType();
            Intrinsics.checkNotNull((Object)protoType);
            ProtoType protoType2 = fieldType.getValueType();
            Intrinsics.checkNotNull((Object)protoType2);
            SyntheticMapEntry syntheticMapEntry = new SyntheticMapEntry(enclosingTypeOrPackage, name, protoType, protoType2);
            boolean bl2 = false;
            map.put(field, syntheticMapEntry);
        }
        return result;
    }

    private final int getLabelTag(Field $this$labelTag) {
        int n;
        Field.EncodeMode encodeMode = $this$labelTag.getEncodeMode();
        int n2 = encodeMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[encodeMode.ordinal()];
        switch (n2) {
            case 1: 
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n = 3;
                break;
            }
            default: {
                String string = Intrinsics.stringPlus((String)"unexpected encodeMode: ", (Object)((Object)$this$labelTag.getEncodeMode()));
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return n;
    }

    private final String getDotName(ProtoType $this$dotName) {
        return Intrinsics.stringPlus((String)".", (Object)$this$dotName);
    }

    private final int getTypeTag(ProtoType $this$typeTag) {
        int n;
        if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.DOUBLE)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.FLOAT)) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.INT64)) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.UINT64)) {
            n = 4;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.INT32)) {
            n = 5;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.FIXED64)) {
            n = 6;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.FIXED32)) {
            n = 7;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.BOOL)) {
            n = 8;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.STRING)) {
            n = 9;
        } else if (this.schema.getType($this$typeTag) instanceof MessageType) {
            n = 11;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.BYTES)) {
            n = 12;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.UINT32)) {
            n = 13;
        } else if (this.schema.getType($this$typeTag) instanceof EnumType) {
            n = 14;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SFIXED32)) {
            n = 15;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SFIXED64)) {
            n = 16;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SINT32)) {
            n = 17;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SINT64)) {
            n = 18;
        } else if ($this$typeTag.isMap()) {
            n = 11;
        } else {
            String string = Intrinsics.stringPlus((String)"unexpected type: ", (Object)$this$typeTag);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    private final Object toJsonOptions(Options $this$toJsonOptions) {
        Map<ProtoMember, Object> optionsMap = $this$toJsonOptions.getMap();
        if (optionsMap.isEmpty()) {
            return null;
        }
        boolean bl = false;
        Map result = new LinkedHashMap();
        Object object = optionsMap;
        boolean bl2 = false;
        Iterator<Map.Entry<ProtoMember, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Object object2 = object = iterator.next();
            boolean bl3 = false;
            ProtoMember key = (ProtoMember)object2.getKey();
            Object object3 = object;
            boolean bl4 = false;
            Object value = object3.getValue();
            Object object4 = this.schema.getField(key);
            if (object4 == null) {
                string = Intrinsics.stringPlus((String)"unexpected options field: ", (Object)key);
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Field field = object4;
            object4 = result;
            string = field.getName();
            Object v = value;
            Intrinsics.checkNotNull(v);
            Object object5 = this.toJson(field, v);
            boolean bl6 = false;
            object4.put(string, object5);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Object toJson(Field field, Object value) {
        Object object;
        if (field.isRepeated()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (List)value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ProtoType protoType = field.getType();
                Intrinsics.checkNotNull((Object)protoType);
                void v1 = it;
                Intrinsics.checkNotNull((Object)v1);
                Object object2 = this.toJsonSingle(protoType, v1);
                collection.add(object2);
            }
            object = (List)destination$iv$iv;
        } else {
            ProtoType protoType = field.getType();
            Intrinsics.checkNotNull((Object)protoType);
            object = this.toJsonSingle(protoType, value);
        }
        return object;
    }

    private final Object toJsonSingle(ProtoType type, Object value) {
        Object object;
        ProtoType protoType = type;
        if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT32)) {
            String string = (String)value;
            boolean bl = false;
            object = Integer.parseInt(string);
        } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.DOUBLE)) {
            String string = (String)value;
            boolean bl = false;
            object = Double.parseDouble(string);
        } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.BOOL)) {
            String string = (String)value;
            boolean bl = false;
            object = Boolean.parseBoolean(string);
        } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRING)) {
            object = (String)value;
        } else {
            Type type2 = this.schema.getType(type);
            if (type2 instanceof MessageType) {
                object = this.toJsonMap((Map)value);
            } else if (type2 instanceof EnumType) {
                object = (String)value;
            } else {
                String string = "not implemented yet!!";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return object;
    }

    private final Map<String, Object> toJsonMap(Map<ProtoMember, ? extends Object> map) {
        boolean bl = false;
        Map result = new LinkedHashMap();
        Object object = map;
        boolean bl2 = false;
        Iterator<Map.Entry<ProtoMember, ? extends Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl3 = false;
            ProtoMember key = (ProtoMember)object2.getKey();
            Object object3 = object;
            boolean bl4 = false;
            Object value = object3.getValue();
            Object object4 = this.schema.getField(key);
            if (object4 == null) continue;
            Field field = object4;
            object4 = result;
            String string = key.getSimpleName();
            Object object5 = this.toJson(field, value);
            boolean bl5 = false;
            object4.put(string, object5);
        }
        return result;
    }

    public static final /* synthetic */ ProtoAdapter access$getFileOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.fileOptionsProtoAdapter;
    }

    public static final /* synthetic */ Object access$toJsonOptions(SchemaEncoder $this, Options $receiver) {
        return $this.toJsonOptions($receiver);
    }

    public static final /* synthetic */ Encoder access$getFieldEncoder$p(SchemaEncoder $this) {
        return $this.fieldEncoder;
    }

    public static final /* synthetic */ Encoder access$getServiceEncoder$p(SchemaEncoder $this) {
        return $this.serviceEncoder;
    }

    public static final /* synthetic */ Encoder access$getEnumEncoder$p(SchemaEncoder $this) {
        return $this.enumEncoder;
    }

    public static final /* synthetic */ Encoder access$getMessageEncoder$p(SchemaEncoder $this) {
        return $this.messageEncoder;
    }

    public static final /* synthetic */ String access$getDotName(SchemaEncoder $this, ProtoType $receiver) {
        return $this.getDotName($receiver);
    }

    public static final /* synthetic */ Schema access$getSchema$p(SchemaEncoder $this) {
        return $this.schema;
    }

    public static final /* synthetic */ Map access$collectSyntheticMapEntries(SchemaEncoder $this, String enclosingTypeOrPackage, List fields) {
        return $this.collectSyntheticMapEntries(enclosingTypeOrPackage, fields);
    }

    public static final /* synthetic */ ProtoAdapter access$getMessageOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.messageOptionsProtoAdapter;
    }

    public static final /* synthetic */ Encoder access$getOneOfEncoder$p(SchemaEncoder $this) {
        return $this.oneOfEncoder;
    }

    public static final /* synthetic */ Encoder access$getExtensionRangeEncoder$p(SchemaEncoder $this) {
        return $this.extensionRangeEncoder;
    }

    public static final /* synthetic */ Encoder access$getSyntheticMapEntryEncoder$p(SchemaEncoder $this) {
        return $this.syntheticMapEntryEncoder;
    }

    public static final /* synthetic */ int access$getTypeTag(SchemaEncoder $this, ProtoType $receiver) {
        return $this.getTypeTag($receiver);
    }

    public static final /* synthetic */ ProtoAdapter access$getFieldOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.fieldOptionsProtoAdapter;
    }

    public static final /* synthetic */ int access$getLabelTag(SchemaEncoder $this, Field $receiver) {
        return $this.getLabelTag($receiver);
    }

    public static final /* synthetic */ ProtoAdapter access$getEnumOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.enumOptionsProtoAdapter;
    }

    public static final /* synthetic */ Encoder access$getEnumConstantEncoder$p(SchemaEncoder $this) {
        return $this.enumConstantEncoder;
    }

    public static final /* synthetic */ ProtoAdapter access$getEnumValueOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.enumValueOptionsProtoAdapter;
    }

    public static final /* synthetic */ ProtoAdapter access$getServiceOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.serviceOptionsProtoAdapter;
    }

    public static final /* synthetic */ Encoder access$getRpcEncoder$p(SchemaEncoder $this) {
        return $this.rpcEncoder;
    }

    public static final /* synthetic */ ProtoAdapter access$getRpcOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.rpcOptionsProtoAdapter;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$SyntheticMapEntry;", "", "enclosingTypeOrPackage", "", "name", "keyType", "Lcom/squareup/wire/schema/ProtoType;", "valueType", "(Ljava/lang/String;Ljava/lang/String;Lcom/squareup/wire/schema/ProtoType;Lcom/squareup/wire/schema/ProtoType;)V", "fieldType", "getFieldType", "()Lcom/squareup/wire/schema/ProtoType;", "getKeyType", "getName", "()Ljava/lang/String;", "getValueType", "wire-schema"})
    private static final class SyntheticMapEntry {
        @NotNull
        private final String name;
        @NotNull
        private final ProtoType keyType;
        @NotNull
        private final ProtoType valueType;
        @NotNull
        private final ProtoType fieldType;

        public SyntheticMapEntry(@Nullable String enclosingTypeOrPackage, @NotNull String name, @NotNull ProtoType keyType, @NotNull ProtoType valueType) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            this.name = name;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fieldType = ProtoType.Companion.get(enclosingTypeOrPackage, this.name);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ProtoType getKeyType() {
            return this.keyType;
        }

        @NotNull
        public final ProtoType getValueType() {
            return this.valueType;
        }

        @NotNull
        public final ProtoType getFieldType() {
            return this.fieldType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015JF\u0010 \u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u000bH\u00d6\u0001J\t\u0010%\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "", "syntax", "Lcom/squareup/wire/Syntax;", "field", "Lcom/squareup/wire/schema/Field;", "type", "Lcom/squareup/wire/schema/ProtoType;", "extendee", "", "oneOfIndex", "", "(Lcom/squareup/wire/Syntax;Lcom/squareup/wire/schema/Field;Lcom/squareup/wire/schema/ProtoType;Ljava/lang/String;Ljava/lang/Integer;)V", "getExtendee", "()Ljava/lang/String;", "getField", "()Lcom/squareup/wire/schema/Field;", "isProto3Optional", "", "()Z", "getOneOfIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSyntax", "()Lcom/squareup/wire/Syntax;", "getType", "()Lcom/squareup/wire/schema/ProtoType;", "component1", "component2", "component3", "component4", "component5", "copy", "(Lcom/squareup/wire/Syntax;Lcom/squareup/wire/schema/Field;Lcom/squareup/wire/schema/ProtoType;Ljava/lang/String;Ljava/lang/Integer;)Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "equals", "other", "hashCode", "toString", "wire-schema"})
    private static final class EncodedField {
        @Nullable
        private final Syntax syntax;
        @NotNull
        private final Field field;
        @NotNull
        private final ProtoType type;
        @Nullable
        private final String extendee;
        @Nullable
        private final Integer oneOfIndex;

        public EncodedField(@Nullable Syntax syntax, @NotNull Field field, @NotNull ProtoType type, @Nullable String extendee, @Nullable Integer oneOfIndex) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.syntax = syntax;
            this.field = field;
            this.type = type;
            this.extendee = extendee;
            this.oneOfIndex = oneOfIndex;
        }

        public /* synthetic */ EncodedField(Syntax syntax, Field field, ProtoType protoType, String string, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                ProtoType protoType2 = field.getType();
                Intrinsics.checkNotNull((Object)protoType2);
                protoType = protoType2;
            }
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            this(syntax, field, protoType, string, n);
        }

        @Nullable
        public final Syntax getSyntax() {
            return this.syntax;
        }

        @NotNull
        public final Field getField() {
            return this.field;
        }

        @NotNull
        public final ProtoType getType() {
            return this.type;
        }

        @Nullable
        public final String getExtendee() {
            return this.extendee;
        }

        @Nullable
        public final Integer getOneOfIndex() {
            return this.oneOfIndex;
        }

        public final boolean isProto3Optional() {
            return this.syntax == Syntax.PROTO_3 && this.field.getLabel() == Field.Label.OPTIONAL;
        }

        @Nullable
        public final Syntax component1() {
            return this.syntax;
        }

        @NotNull
        public final Field component2() {
            return this.field;
        }

        @NotNull
        public final ProtoType component3() {
            return this.type;
        }

        @Nullable
        public final String component4() {
            return this.extendee;
        }

        @Nullable
        public final Integer component5() {
            return this.oneOfIndex;
        }

        @NotNull
        public final EncodedField copy(@Nullable Syntax syntax, @NotNull Field field, @NotNull ProtoType type, @Nullable String extendee, @Nullable Integer oneOfIndex) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new EncodedField(syntax, field, type, extendee, oneOfIndex);
        }

        public static /* synthetic */ EncodedField copy$default(EncodedField encodedField, Syntax syntax, Field field, ProtoType protoType, String string, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                syntax = encodedField.syntax;
            }
            if ((n2 & 2) != 0) {
                field = encodedField.field;
            }
            if ((n2 & 4) != 0) {
                protoType = encodedField.type;
            }
            if ((n2 & 8) != 0) {
                string = encodedField.extendee;
            }
            if ((n2 & 0x10) != 0) {
                n = encodedField.oneOfIndex;
            }
            return encodedField.copy(syntax, field, protoType, string, n);
        }

        @NotNull
        public String toString() {
            return "EncodedField(syntax=" + this.syntax + ", field=" + this.field + ", type=" + this.type + ", extendee=" + this.extendee + ", oneOfIndex=" + this.oneOfIndex + ')';
        }

        public int hashCode() {
            int result = this.syntax == null ? 0 : this.syntax.hashCode();
            result = result * 31 + this.field.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + (this.extendee == null ? 0 : this.extendee.hashCode());
            result = result * 31 + (this.oneOfIndex == null ? 0 : ((Object)this.oneOfIndex).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EncodedField)) {
                return false;
            }
            EncodedField encodedField = (EncodedField)other;
            if (this.syntax != encodedField.syntax) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.field, (Object)encodedField.field)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)encodedField.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extendee, (Object)encodedField.extendee)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.oneOfIndex, (Object)encodedField.oneOfIndex);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedOneOf;", "", "name", "", "fields", "", "Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "(Ljava/lang/String;Ljava/util/List;)V", "getFields", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "wire-schema"})
    private static final class EncodedOneOf {
        @NotNull
        private final String name;
        @NotNull
        private final List<EncodedField> fields;

        public EncodedOneOf(@NotNull String name, @NotNull List<EncodedField> fields) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            this.name = name;
            this.fields = fields;
        }

        public /* synthetic */ EncodedOneOf(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            }
            this(string, list);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<EncodedField> getFields() {
            return this.fields;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$Encoder;", "T", "Lcom/squareup/wire/ProtoAdapter;", "()V", "decode", "reader", "Lcom/squareup/wire/ProtoReader;", "(Lcom/squareup/wire/ProtoReader;)Ljava/lang/Object;", "encode", "", "writer", "Lcom/squareup/wire/ProtoWriter;", "value", "(Lcom/squareup/wire/ProtoWriter;Ljava/lang/Object;)Ljava/lang/Void;", "encodedSize", "", "(Ljava/lang/Object;)I", "redact", "(Ljava/lang/Object;)Ljava/lang/Object;", "wire-schema"})
    private static abstract class Encoder<T>
    extends ProtoAdapter<T> {
        public Encoder() {
            super(FieldEncoding.LENGTH_DELIMITED, null, null, Syntax.PROTO_2);
        }

        public T redact(T value) {
            return value;
        }

        public int encodedSize(T value) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Void encode(@NotNull ProtoWriter writer, T value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            throw new UnsupportedOperationException();
        }

        public T decode(@NotNull ProtoReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Field.EncodeMode.values().length];
            nArray[Field.EncodeMode.NULL_IF_ABSENT.ordinal()] = 1;
            nArray[Field.EncodeMode.OMIT_IDENTITY.ordinal()] = 2;
            nArray[Field.EncodeMode.REQUIRED.ordinal()] = 3;
            nArray[Field.EncodeMode.REPEATED.ordinal()] = 4;
            nArray[Field.EncodeMode.PACKED.ordinal()] = 5;
            nArray[Field.EncodeMode.MAP.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

