/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import java.lang.annotation.ElementType;
import java.math.BigInteger;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a8\u0006\u0017"}, d2={"annotationTargetType", "Ljava/lang/annotation/ElementType;", "extend", "Lcom/squareup/wire/schema/Extend;", "builtInAdapterString", "", "type", "Lcom/squareup/wire/schema/ProtoType;", "eligibleAsAnnotationMember", "", "schema", "Lcom/squareup/wire/schema/Schema;", "field", "Lcom/squareup/wire/schema/Field;", "javaPackage", "protoFile", "Lcom/squareup/wire/schema/ProtoFile;", "optionValueToInt", "", "value", "", "optionValueToLong", "", "wire-schema"})
@JvmName(name="JvmLanguages")
public final class JvmLanguages {
    @Nullable
    public static final String builtInAdapterString(@NotNull ProtoType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isScalar()) {
            StringBuilder stringBuilder = new StringBuilder().append((Object)ProtoAdapter.class.getName()).append('#');
            String string = type.toString();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
            return stringBuilder.append(string4).toString();
        }
        ProtoType protoType = type;
        return Intrinsics.areEqual((Object)protoType, (Object)ProtoType.DURATION) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#DURATION") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.TIMESTAMP) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#INSTANT") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.EMPTY) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#EMPTY") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_MAP) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#STRUCT_MAP") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#STRUCT_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_NULL) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#STRUCT_NULL") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRUCT_LIST) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#STRUCT_LIST") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.DOUBLE_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#DOUBLE_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.FLOAT_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#FLOAT_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT64_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#INT64_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.UINT64_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#UINT64_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT32_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#INT32_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.UINT32_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#UINT32_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.BOOL_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#BOOL_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRING_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#STRING_VALUE") : (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.BYTES_VALUE) ? Intrinsics.stringPlus((String)ProtoAdapter.class.getName(), (Object)"#BYTES_VALUE") : null)))))))))))))));
    }

    public static final boolean eligibleAsAnnotationMember(@NotNull Schema schema, @NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        ProtoType protoType = field.getType();
        Intrinsics.checkNotNull((Object)protoType);
        ProtoType type = protoType;
        if (Intrinsics.areEqual((Object)type, (Object)ProtoType.BYTES)) {
            return false;
        }
        if (!type.isScalar() && !(schema.getType(type) instanceof EnumType)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)field.getPackageName(), (Object)"google.protobuf") || Intrinsics.areEqual((Object)field.getPackageName(), (Object)"wire")) {
            return false;
        }
        return !Intrinsics.areEqual((Object)field.getName(), (Object)"redacted");
    }

    @Nullable
    public static final ElementType annotationTargetType(@NotNull Extend extend) {
        Intrinsics.checkNotNullParameter((Object)extend, (String)"extend");
        ProtoType protoType = extend.getType();
        Intrinsics.checkNotNull((Object)protoType);
        ProtoType protoType2 = protoType;
        return ((Intrinsics.areEqual((Object)protoType2, (Object)Options.MESSAGE_OPTIONS) ? true : Intrinsics.areEqual((Object)protoType2, (Object)Options.ENUM_OPTIONS)) ? true : Intrinsics.areEqual((Object)protoType2, (Object)Options.SERVICE_OPTIONS)) ? ElementType.TYPE : ((Intrinsics.areEqual((Object)protoType2, (Object)Options.FIELD_OPTIONS) ? true : Intrinsics.areEqual((Object)protoType2, (Object)Options.ENUM_VALUE_OPTIONS)) ? ElementType.FIELD : (Intrinsics.areEqual((Object)protoType2, (Object)Options.METHOD_OPTIONS) ? ElementType.METHOD : null));
    }

    public static final int optionValueToInt(@Nullable Object value) {
        int n;
        if (value == null) {
            return 0;
        }
        String string = value.toString();
        if (StringsKt.startsWith$default((String)string, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"0X", (boolean)false, (int)2, null)) {
            String string2 = string;
            int n2 = "0x".length();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = string4;
            n2 = 16;
            bl = false;
            n = Integer.parseInt(string2, CharsKt.checkRadix((int)n2));
        } else {
            if (StringsKt.startsWith$default((String)string, (String)"0", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)string, (Object)"0")) {
                String string5 = Intrinsics.stringPlus((String)"Octal literal unsupported: ", (Object)value);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string5.toString());
            }
            n = new BigInteger(string).intValue();
        }
        return n;
    }

    public static final long optionValueToLong(@Nullable Object value) {
        long l;
        if (value == null) {
            return 0L;
        }
        String string = value.toString();
        if (StringsKt.startsWith$default((String)string, (String)"0x", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string, (String)"0X", (boolean)false, (int)2, null)) {
            String string2 = string;
            int n = "0x".length();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = string4;
            n = 16;
            bl = false;
            l = Long.parseLong(string2, CharsKt.checkRadix((int)n));
        } else {
            if (StringsKt.startsWith$default((String)string, (String)"0", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)string, (Object)"0")) {
                String string5 = Intrinsics.stringPlus((String)"Octal literal unsupported: ", (Object)value);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string5.toString());
            }
            l = new BigInteger(string).longValue();
        }
        return l;
    }

    @NotNull
    public static final String javaPackage(@NotNull ProtoFile protoFile) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        String wirePackage = protoFile.wirePackage();
        if (wirePackage != null) {
            return wirePackage;
        }
        String javaPackage = protoFile.javaPackage();
        if (javaPackage != null) {
            return javaPackage;
        }
        String string = protoFile.getPackageName();
        return string == null ? "" : string;
    }
}

