/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldEncoding;
import java.io.IOException;
import okio.BufferedSink;
import okio.ByteString;

public final class ProtoWriter {
    private final BufferedSink sink;

    private static int makeTag(int fieldNumber, FieldEncoding fieldEncoding) {
        return fieldNumber << 3 | fieldEncoding.value;
    }

    static int tagSize(int tag) {
        return ProtoWriter.varint32Size(ProtoWriter.makeTag(tag, FieldEncoding.VARINT));
    }

    static int int32Size(int value) {
        if (value >= 0) {
            return ProtoWriter.varint32Size(value);
        }
        return 10;
    }

    static int varint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int varint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public ProtoWriter(BufferedSink sink) {
        this.sink = sink;
    }

    public void writeBytes(ByteString value) throws IOException {
        this.sink.write(value);
    }

    public void writeString(String value) throws IOException {
        this.sink.writeUtf8(value);
    }

    public void writeTag(int fieldNumber, FieldEncoding fieldEncoding) throws IOException {
        this.writeVarint32(ProtoWriter.makeTag(fieldNumber, fieldEncoding));
    }

    void writeSignedVarint32(int value) throws IOException {
        if (value >= 0) {
            this.writeVarint32(value);
        } else {
            this.writeVarint64(value);
        }
    }

    public void writeVarint32(int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            this.sink.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.sink.writeByte(value);
    }

    public void writeVarint64(long value) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.sink.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.sink.writeByte((int)value);
    }

    public void writeFixed32(int value) throws IOException {
        this.sink.writeIntLe(value);
    }

    public void writeFixed64(long value) throws IOException {
        this.sink.writeLongLe(value);
    }
}

