/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class EnumAdapter<E extends WireEnum>
extends ProtoAdapter<E> {
    protected EnumAdapter(Class<E> type) {
        super(FieldEncoding.VARINT, type);
    }

    @Override
    public final int encodedSize(E value) {
        return ProtoWriter.varint32Size(value.getValue());
    }

    @Override
    public final void encode(ProtoWriter writer, E value) throws IOException {
        writer.writeVarint32(value.getValue());
    }

    @Override
    public final E decode(ProtoReader reader) throws IOException {
        int value = reader.readVarint32();
        E constant = this.fromValue(value);
        if (constant == null) {
            throw new ProtoAdapter.EnumConstantNotFoundException(value, this.javaType);
        }
        return constant;
    }

    @Nullable
    protected abstract E fromValue(int var1);
}

