/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Extension;
import com.squareup.wire.FieldBinding;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.RuntimeEnumAdapter;
import com.squareup.wire.WireField;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class RuntimeMessageAdapter<M extends Message<M>, B extends Message.Builder<M, B>>
extends ProtoAdapter<M> {
    private final Class<M> messageType;
    private final Class<B> builderType;
    private final Constructor<B> builderCopyConstructor;
    private final Map<Integer, FieldBinding<M, B>> fieldBindings;

    static <M extends Message<M>, B extends Message.Builder<M, B>> RuntimeMessageAdapter<M, B> create(Class<M> messageType) {
        Class<B> builderType = RuntimeMessageAdapter.getBuilderType(messageType);
        Constructor<B> builderCopyConstructor = RuntimeMessageAdapter.getBuilderCopyConstructor(builderType, messageType);
        LinkedHashMap fieldBindings = new LinkedHashMap();
        for (Field messageField : messageType.getDeclaredFields()) {
            WireField wireField = messageField.getAnnotation(WireField.class);
            if (wireField == null) continue;
            fieldBindings.put(wireField.tag(), new FieldBinding(wireField, messageField, builderType));
        }
        return new RuntimeMessageAdapter<M, B>(messageType, builderType, builderCopyConstructor, Collections.unmodifiableMap(fieldBindings));
    }

    RuntimeMessageAdapter(Class<M> messageType, Class<B> builderType, Constructor<B> builderCopyConstructor, Map<Integer, FieldBinding<M, B>> fieldBindings) {
        super(FieldEncoding.LENGTH_DELIMITED, messageType);
        this.messageType = messageType;
        this.builderType = builderType;
        this.builderCopyConstructor = builderCopyConstructor;
        this.fieldBindings = fieldBindings;
    }

    Map<Integer, FieldBinding<M, B>> fieldBindings() {
        return this.fieldBindings;
    }

    B newBuilder() {
        try {
            return (B)((Message.Builder)this.builderType.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    B newBuilder(M value) {
        try {
            return (B)((Message.Builder)this.builderCopyConstructor.newInstance(value));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <M extends Message<M>, B extends Message.Builder<M, B>> Class<B> getBuilderType(Class<M> messageType) {
        try {
            return Class.forName(messageType.getName() + "$Builder");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No builder class found for message type " + messageType.getName());
        }
    }

    private static <M extends Message<M>, B extends Message.Builder<M, B>> Constructor<B> getBuilderCopyConstructor(Class<B> builderType, Class<M> messageType) {
        try {
            return builderType.getConstructor(messageType);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int encodedSize(M message) {
        int cachedSerializedSize = ((Message)message).cachedSerializedSize;
        if (cachedSerializedSize != 0) {
            return cachedSerializedSize;
        }
        int size = 0;
        for (FieldBinding<M, B> fieldBinding : this.fieldBindings.values()) {
            Object value = fieldBinding.get(message);
            if (value == null) continue;
            size += fieldBinding.adapter().encodedSize(fieldBinding.tag, value);
        }
        ((Message)message).cachedSerializedSize = size += ((Message)message).tagMapEncodedSize();
        return size;
    }

    @Override
    public void encode(ProtoWriter writer, M message) throws IOException {
        for (FieldBinding<M, B> fieldBinding : this.fieldBindings.values()) {
            Object value = fieldBinding.get(message);
            if (value == null) continue;
            fieldBinding.adapter().encodeTagged(writer, fieldBinding.tag, value);
        }
        if (((Message)message).tagMap != null) {
            ((Message)message).tagMap.encode(writer);
        }
    }

    @Override
    public M redact(M message) {
        B builder = this.newBuilder(message);
        for (FieldBinding<M, B> fieldBinding : this.fieldBindings.values()) {
            if (!fieldBinding.redacted && !Message.class.isAssignableFrom(fieldBinding.singleAdapter().javaType)) continue;
            if (fieldBinding.redacted && fieldBinding.label == WireField.Label.REQUIRED) {
                throw new IllegalArgumentException(String.format("Field %s.%s is REQUIRED and cannot be redacted.", this.javaType.getName(), fieldBinding.name));
            }
            Object builderValue = fieldBinding.getFromBuilder(builder);
            if (builderValue == null) continue;
            Object redactedValue = fieldBinding.adapter().redact(builderValue);
            fieldBinding.set(builder, redactedValue);
        }
        if (((Message.Builder)builder).tagMapBuilder != null) {
            ((Message.Builder)builder).tagMapBuilder.redact();
        }
        return (M)((Message.Builder)builder).build();
    }

    public boolean equals(Object o) {
        return o instanceof RuntimeMessageAdapter && ((RuntimeMessageAdapter)o).messageType == this.messageType;
    }

    public int hashCode() {
        return this.messageType.hashCode();
    }

    @Override
    public String toString(M message) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.messageType.getSimpleName());
        sb.append('{');
        boolean seenValue = false;
        for (FieldBinding<M, B> fieldBinding : this.fieldBindings.values()) {
            Object value = fieldBinding.get(message);
            if (value == null) continue;
            if (seenValue) {
                sb.append(", ");
            }
            sb.append(fieldBinding.name).append('=').append(fieldBinding.redacted ? "\u2588\u2588" : value);
            seenValue = true;
        }
        if (((Message)message).tagMap != null) {
            for (Extension extension : ((Message)message).tagMap.extensions(true)) {
                if (seenValue) {
                    sb.append(", ");
                }
                if (extension.isUnknown()) {
                    sb.append(extension.getTag());
                } else {
                    sb.append(extension.getName());
                }
                sb.append('=').append(((Message)message).tagMap.get(extension));
                seenValue = true;
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public M decode(ProtoReader reader) throws IOException {
        int tag;
        B builder = this.newBuilder();
        long token = reader.beginMessage();
        while ((tag = reader.nextTag()) != -1) {
            FieldBinding<M, B> fieldBinding = this.fieldBindings.get(tag);
            try {
                if (fieldBinding != null) {
                    Object value = fieldBinding.singleAdapter().decode(reader);
                    fieldBinding.value(builder, value);
                    continue;
                }
                Extension<M, ?> extension = reader.getExtension(this.messageType, tag);
                Object value = extension.getAdapter().decode(reader);
                ((Message.Builder)builder).ensureTagMap().add(extension, value);
            }
            catch (RuntimeEnumAdapter.EnumConstantNotFoundException e) {
                ((Message.Builder)builder).setExtension(Extension.unknown(this.messageType, tag, FieldEncoding.VARINT), e.value);
            }
        }
        reader.endMessage(token);
        return (M)((Message.Builder)builder).build();
    }
}

