/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoField;
import com.squareup.wire.TagBinding;
import com.squareup.wire.TypeAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class FieldTagBinding<M extends Message>
extends TagBinding<M, Message.Builder<M>> {
    private final Field messageField;
    private final Field builderField;
    private final Method builderMethod;

    private static Field getBuilderField(Class<?> builderType, String name) {
        try {
            return builderType.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)("No builder field " + builderType.getName() + "." + name));
        }
    }

    private static Method getBuilderMethod(Class<?> builderType, String name, Class<?> type) {
        try {
            return builderType.getMethod(name, type);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("No builder method " + builderType.getName() + "." + name + "(" + type.getName() + ")"));
        }
    }

    FieldTagBinding(ProtoField protoField, TypeAdapter<?> singleAdapter, Class<?> singleType, Field messageField, Class<Message.Builder<M>> builderType) {
        super(protoField.label(), protoField.type(), messageField.getName(), protoField.tag(), protoField.redacted(), singleAdapter, singleType);
        this.messageField = messageField;
        this.builderField = FieldTagBinding.getBuilderField(builderType, this.name);
        this.builderMethod = FieldTagBinding.getBuilderMethod(builderType, this.name, messageField.getType());
    }

    @Override
    void set(Message.Builder<M> builder, Object value) {
        try {
            if (this.label.isOneOf()) {
                this.builderMethod.invoke(builder, value);
            } else {
                this.builderField.set(builder, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    Object get(M message) {
        try {
            return this.messageField.get(message);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    Object getFromBuilder(Message.Builder<M> builder) {
        try {
            return this.builderField.get(builder);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

